/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.video;

import boofcv.io.image.SimpleImageSequence;
import boofcv.io.video.BoofMjpegVideo;
import boofcv.io.video.VideoInterface;
import boofcv.io.video.VideoMjpegCodec;
import boofcv.io.wrapper.images.ImageStreamSequence;
import boofcv.io.wrapper.images.JpegByteImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;

public class DynamicVideoInterface
implements VideoInterface {
    VideoInterface xuggler;
    VideoInterface jcodec;
    VideoInterface ffmpeg;
    BoofMjpegVideo mjpeg = new BoofMjpegVideo();

    public DynamicVideoInterface() {
        try {
            this.ffmpeg = DynamicVideoInterface.loadManager("boofcv.io.ffmpeg.FfmpegVideo");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.jcodec = DynamicVideoInterface.loadManager("boofcv.io.jcodec.JCodecVideoInterface");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public <T extends ImageBase<T>> SimpleImageSequence<T> load(String fileName, ImageType<T> imageType) {
        if (fileName.endsWith("mjpeg") || fileName.endsWith("MJPEG") || fileName.endsWith("mjpg") || fileName.endsWith("MJPG")) {
            try {
                VideoMjpegCodec codec = new VideoMjpegCodec();
                List<byte[]> data = codec.read(new FileInputStream(fileName));
                return new JpegByteImageSequence<T>(imageType, data, false);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (fileName.endsWith("mpng") || fileName.endsWith("MPNG")) {
            try {
                return new ImageStreamSequence<T>(fileName, true, imageType);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            if (this.xuggler != null) {
                return this.xuggler.load(fileName, imageType);
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            if (this.ffmpeg != null) {
                return this.ffmpeg.load(fileName, imageType);
            }
        }
        catch (RuntimeException ignore) {
            ignore.printStackTrace();
        }
        try {
            if (this.jcodec != null && (fileName.endsWith(".mp4") || fileName.endsWith(".MP4"))) {
                return this.jcodec.load(fileName, imageType);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        System.err.println("Codec finally not found for file: " + fileName);
        return null;
    }

    public static VideoInterface loadManager(String pathToManager) {
        try {
            Class<?> c = Class.forName(pathToManager);
            return (VideoInterface)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found.  Is it included in the class path?");
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

