/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;

public class UtilIO {
    public static String pathExample(String path) {
        File f;
        if (new File(path).isAbsolute()) {
            return path;
        }
        File pathExample = new File(UtilIO.getPathToBase(), "data/example/");
        if (!pathExample.exists()) {
            System.err.println();
            System.err.println("Can't find data/example directory!  There are three likely causes for this problem.");
            System.err.println();
            System.err.println("1) You checked out the source code from git and did not pull the data submodule too.");
            System.err.println("2) You are trying to run an example from outside the BoofCV directory tree.");
            System.err.println("3) You are trying to pass in your own image.");
            System.err.println();
            System.err.println("Solutions:");
            System.err.println("1) Follow instructions in the boofcv/readme.md file to grab the data directory.");
            System.err.println("2) Launch the example from inside BoofCV's directory tree!");
            System.err.println("3) Don't use this function and just pass in the path directly");
            System.exit(1);
        }
        if ((f = new File(pathExample.getPath(), path)).isDirectory()) {
            return f.getAbsolutePath() + System.getProperty("file.separator");
        }
        return f.getAbsolutePath();
    }

    public static String path(String path) {
        return new File(UtilIO.getPathToBase(), path).getAbsolutePath();
    }

    public static File getFileToBase() {
        return new File(UtilIO.getPathToBase());
    }

    public static String getPathToBase() {
        String[] files;
        File f;
        String path = new File(".").getAbsoluteFile().getParent();
        while ((f = new File(path)).exists() && (files = f.list()) != null) {
            boolean foundMain = false;
            boolean foundExamples = false;
            boolean foundIntegration = false;
            for (String s : files) {
                if (s.compareToIgnoreCase("main") == 0) {
                    foundMain = true;
                    continue;
                }
                if (s.compareToIgnoreCase("examples") == 0) {
                    foundExamples = true;
                    continue;
                }
                if (s.compareToIgnoreCase("integration") != 0) continue;
                foundIntegration = true;
            }
            if (foundMain && foundExamples && foundIntegration) {
                return path;
            }
            path = f.getParent();
        }
        throw new RuntimeException("Can't find path to base of project");
    }

    public static String selectFile(boolean exitOnCancel) {
        String fileName = null;
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            fileName = fc.getSelectedFile().getAbsolutePath();
        } else if (exitOnCancel) {
            System.exit(0);
        }
        return fileName;
    }

    public static void loadLibrarySmart(String libraryName) {
        String[] stuff;
        if (UtilIO.loadLibrary(libraryName)) {
            return;
        }
        String classPath = System.getProperty("java.class.path");
        for (String s : stuff = classPath.split(":")) {
            File f = new File(s);
            if (!f.isDirectory() || !(f = new File(s + "/" + libraryName)).exists()) continue;
            String libraryPath = System.getProperty("java.library.path");
            libraryPath = libraryPath + ":" + s;
            System.setProperty("java.library.path", libraryPath);
            if (!UtilIO.loadLibrary(libraryName)) {
                throw new RuntimeException("Shouldn't have failed to load this time");
            }
            return;
        }
        System.out.println("classPath");
    }

    public static boolean loadLibrary(String libraryName) {
        try {
            System.out.println("tring to load: " + libraryName);
            System.loadLibrary(libraryName);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    public static void save(Object o, String fileName) {
        try {
            FileOutputStream fileOut = new FileOutputStream(fileName);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(o);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T load(String fileName) {
        try {
            FileInputStream fileIn = new FileInputStream(fileName);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            Object obj = in.readObject();
            in.close();
            fileIn.close();
            return (T)obj;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteRecursive(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                UtilIO.deleteRecursive(c);
            }
        }
        if (!f.delete()) {
            throw new RuntimeException("Failed to delete file: " + f);
        }
    }

    public static String readAsString(String path) {
        StringBuilder code = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(path));
            while ((line = reader.readLine()) != null) {
                code.append(line).append(System.lineSeparator());
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        String output = code.toString();
        String nl = System.getProperty("line.separator");
        if (nl.compareTo("\n") != 0) {
            output = output.replaceAll(nl, "\n");
        }
        return output;
    }

    public static String readAsString(InputStream stream) {
        StringBuilder code = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                code.append(line).append(System.lineSeparator());
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        return code.toString();
    }

    public static String getSourcePath(String pkg, String app) {
        String path = "";
        if (pkg == null || app == null) {
            return path;
        }
        if (pkg.contains("examples")) {
            path = UtilIO.path("examples/src/main/java/" + pkg.replace('.', '/') + "/" + app + ".java");
        } else if (pkg.contains("demonstrations")) {
            path = UtilIO.path("demonstrations/src/main/java/" + pkg.replace('.', '/') + "/" + app + ".java");
        }
        return path;
    }

    public static String getGithubURL(String pkg, String app) {
        String dir;
        if (pkg == null || app == null) {
            return "";
        }
        String base = "https://github.com/lessthanoptimal/BoofCV/blob/v0.30/";
        if ((pkg = pkg.replace('.', '/') + "/").contains("demonstrations")) {
            dir = "demonstrations/";
        } else if (pkg.contains("examples")) {
            dir = "examples/";
        } else {
            return "";
        }
        return base + dir + "src/main/java/" + pkg + app + ".java";
    }

    public static int indexOfSourceStart(String code) {
        int state = 0;
        int indexLineStart = 0;
        int previous = 0;
        boolean justEntered = false;
        StringBuilder buffer = new StringBuilder(1024);
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (state == 1) {
                if (justEntered) {
                    justEntered = false;
                    if (c == '*') {
                        return indexLineStart;
                    }
                }
                if (previous == 42 && c == '/') {
                    state = 0;
                }
            } else if (state == 0) {
                if (previous == 47 && c == '/') {
                    state = 2;
                } else if (previous == 47 && c == '*') {
                    state = 1;
                    justEntered = true;
                } else {
                    buffer.append(c);
                }
            }
            if (c == '\n') {
                if (buffer.toString().contains("class")) {
                    return indexLineStart;
                }
                buffer.delete(0, buffer.length());
                indexLineStart = i + 1;
                if (state == 2) {
                    state = 0;
                }
            }
            previous = c;
        }
        if (buffer.toString().contains("class")) {
            return indexLineStart;
        }
        return 0;
    }

    public static List<String> listByPrefix(String directory, String prefix) {
        File[] files;
        ArrayList<String> ret = new ArrayList<String>();
        File d = new File(directory);
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory");
        }
        for (File f : files = d.listFiles()) {
            if (f.isDirectory() || f.isHidden() || !f.getName().contains(prefix)) continue;
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }

    public static List<String> listAll(String directory) {
        File[] files;
        ArrayList<String> ret = new ArrayList<String>();
        File d = new File(directory);
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory");
        }
        for (File f : files = d.listFiles()) {
            if (f.isDirectory() || f.isHidden()) continue;
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }

    public static File[] findMatches(File directory, String regex) {
        final Pattern p = Pattern.compile(regex);
        return directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return p.matcher(file.getName()).matches();
            }
        });
    }
}

