/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.io.image.ConvertRaster;
import boofcv.struct.image.GrayF;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.reflect.Array;
import java.security.AccessControlException;
import javax.swing.JComponent;

public class ConvertBufferedImage {
    public static BufferedImage checkDeclare(int width, int height, BufferedImage image, int type) {
        if (image == null) {
            return new BufferedImage(width, height, type);
        }
        if (image.getType() != type) {
            return new BufferedImage(width, height, type);
        }
        if (image.getWidth() != width || image.getHeight() != height) {
            return new BufferedImage(width, height, type);
        }
        return image;
    }

    public static BufferedImage checkDeclare(BufferedImage template, BufferedImage target) {
        int width = template.getWidth();
        int height = template.getHeight();
        int type = template.getType();
        if (type == 0) {
            type = target != null ? target.getType() : 1;
        }
        if (target == null) {
            return new BufferedImage(width, height, type);
        }
        if (target.getType() != type) {
            return new BufferedImage(width, height, type);
        }
        if (target.getWidth() != width || target.getHeight() != height) {
            return new BufferedImage(width, height, type);
        }
        return target;
    }

    public static BufferedImage checkCopy(BufferedImage original, BufferedImage output) {
        ColorModel cm = original.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        if (output == null || original.getWidth() != output.getWidth() || original.getHeight() != output.getHeight() || original.getType() != output.getType()) {
            WritableRaster raster = original.copyData(original.getRaster().createCompatibleWritableRaster());
            return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
        }
        original.copyData(output.getRaster());
        return output;
    }

    public static BufferedImage stripAlphaChannel(BufferedImage image) {
        int numBands = image.getRaster().getNumBands();
        if (numBands == 4) {
            BufferedImage output = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            output.createGraphics().drawImage((Image)image, 0, 0, null);
            return output;
        }
        return image;
    }

    public static InterleavedU8 extractInterleavedU8(BufferedImage img) {
        DataBuffer buffer = img.getRaster().getDataBuffer();
        if (buffer.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(img)) {
            WritableRaster raster = img.getRaster();
            InterleavedU8 ret = new InterleavedU8();
            ret.width = img.getWidth();
            ret.height = img.getHeight();
            ret.startIndex = ConvertRaster.getOffset(raster);
            ret.imageType.numBands = raster.getNumBands();
            ret.numBands = raster.getNumBands();
            ret.stride = ConvertRaster.stride(raster);
            ret.data = ((DataBufferByte)buffer).getData();
            ret.subImage = ret.startIndex != 0;
            return ret;
        }
        throw new IllegalArgumentException("Buffered image does not have an interleaved byte raster");
    }

    public static GrayU8 extractGrayU8(BufferedImage img) {
        WritableRaster raster = img.getRaster();
        DataBuffer buffer = raster.getDataBuffer();
        if (buffer.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(img)) {
            if (raster.getNumBands() != 1) {
                throw new IllegalArgumentException("Input image has more than one channel");
            }
            GrayU8 ret = new GrayU8();
            ret.width = img.getWidth();
            ret.height = img.getHeight();
            ret.startIndex = ConvertRaster.getOffset(img.getRaster());
            ret.stride = ConvertRaster.stride(img.getRaster());
            ret.data = ((DataBufferByte)buffer).getData();
            return ret;
        }
        throw new IllegalArgumentException("Buffered image does not have a gray scale byte raster");
    }

    public static BufferedImage extractBuffered(InterleavedU8 img) {
        ComponentColorModel colorModel;
        ColorSpace cs;
        if (img.isSubimage()) {
            throw new IllegalArgumentException("Sub-images are not supported for this operation");
        }
        int width = img.width;
        int height = img.height;
        int numBands = img.numBands;
        DataBufferByte bufferByte = new DataBufferByte(img.data, width * height * numBands, 0);
        int[] bOffs = null;
        if (numBands == 3) {
            cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8};
            bOffs = new int[]{2, 1, 0};
            colorModel = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        } else if (numBands == 1) {
            cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{8};
            bOffs = new int[]{0};
            colorModel = new ComponentColorModel(cs, nBits, false, true, 1, 0);
        } else {
            throw new IllegalArgumentException("Only 1 or 3 bands supported");
        }
        WritableRaster raster = Raster.createInterleavedRaster(bufferByte, width, height, img.stride, numBands, bOffs, new Point(0, 0));
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage extractBuffered(GrayU8 img) {
        if (img.isSubimage()) {
            throw new IllegalArgumentException("Sub-images are not supported for this operation");
        }
        int width = img.width;
        int height = img.height;
        DataBufferByte bufferByte = new DataBufferByte(img.data, width * height, 0);
        int[] bOffs = new int[]{0};
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] nBits = new int[]{8};
        ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, false, true, 1, 0);
        WritableRaster raster = Raster.createInterleavedRaster(bufferByte, width, height, img.stride, 1, bOffs, new Point(0, 0));
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static <T extends ImageBase<T>> void convertFrom(BufferedImage src, T dst, boolean orderRgb) {
        if (dst instanceof ImageGray) {
            ImageGray sb = (ImageGray)dst;
            ConvertBufferedImage.convertFromSingle(src, sb, sb.getClass());
        } else if (dst instanceof Planar) {
            Planar ms = (Planar)dst;
            ConvertBufferedImage.convertFromPlanar(src, ms, orderRgb, ms.getBandType());
        } else if (dst instanceof ImageInterleaved) {
            ConvertBufferedImage.convertFromInterleaved(src, (ImageInterleaved)dst, orderRgb);
        } else {
            throw new IllegalArgumentException("Unknown type " + dst.getClass().getSimpleName());
        }
    }

    public static <T extends ImageBase<T>> T convertFrom(BufferedImage src, boolean orderRgb, ImageType<T> imageType) {
        ImageBase out = imageType.createImage(src.getWidth(), src.getHeight());
        switch (imageType.getFamily()) {
            case GRAY: {
                ConvertBufferedImage.convertFromSingle(src, (ImageGray)out, imageType.getImageClass());
                break;
            }
            case PLANAR: {
                ConvertBufferedImage.convertFromPlanar(src, (Planar)out, orderRgb, imageType.getImageClass());
                break;
            }
            case INTERLEAVED: {
                ConvertBufferedImage.convertFromInterleaved(src, (ImageInterleaved)out, orderRgb);
                break;
            }
            default: {
                throw new RuntimeException("Not supported yet");
            }
        }
        return (T)out;
    }

    public static <T extends ImageBase<T>> T convertFrom(BufferedImage src, boolean orderRgb, T output) {
        ImageType imageType = output.getImageType();
        switch (imageType.getFamily()) {
            case GRAY: {
                ConvertBufferedImage.convertFromSingle(src, (ImageGray)output, imageType.getImageClass());
                break;
            }
            case PLANAR: {
                ConvertBufferedImage.convertFromPlanar(src, (Planar)output, orderRgb, imageType.getImageClass());
                break;
            }
            case INTERLEAVED: {
                ConvertBufferedImage.convertFromInterleaved(src, (ImageInterleaved)output, orderRgb);
                break;
            }
            default: {
                throw new RuntimeException("Not supported yet");
            }
        }
        return output;
    }

    public static <T extends ImageGray<T>> T convertFromSingle(BufferedImage src, T dst, Class<T> type) {
        if (type == GrayU8.class) {
            return (T)ConvertBufferedImage.convertFrom(src, (GrayU8)dst);
        }
        if (GrayI16.class.isAssignableFrom(type)) {
            return (T)ConvertBufferedImage.convertFrom(src, (GrayI16)dst, type);
        }
        if (type == GrayF32.class) {
            return (T)ConvertBufferedImage.convertFrom(src, (GrayF32)dst);
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static GrayU8 convertFrom(BufferedImage src, GrayU8 dst) {
        if (dst != null) {
            dst.reshape(src.getWidth(), src.getHeight());
        } else {
            dst = new GrayU8(src.getWidth(), src.getHeight());
        }
        try {
            DataBuffer buff = src.getRaster().getDataBuffer();
            if (buff.getDataType() == 0) {
                if (ConvertBufferedImage.isKnownByteFormat(src)) {
                    ConvertRaster.bufferedToGray((DataBufferByte)buff, src.getRaster(), dst);
                } else {
                    ConvertRaster.bufferedToGray(src, dst);
                }
            } else if (buff.getDataType() == 3) {
                ConvertRaster.bufferedToGray((DataBufferInt)buff, src.getRaster(), dst);
            } else {
                ConvertRaster.bufferedToGray(src, dst);
            }
        }
        catch (AccessControlException e) {
            ConvertRaster.bufferedToGray(src, dst);
        }
        return dst;
    }

    public static <T extends GrayI16<T>> T convertFrom(BufferedImage src, T dst, Class<T> type) {
        if (dst != null) {
            dst.reshape(src.getWidth(), src.getHeight());
        } else {
            dst = (GrayI16)GeneralizedImageOps.createSingleBand(type, (int)src.getWidth(), (int)src.getHeight());
        }
        DataBuffer buffer = src.getRaster().getDataBuffer();
        if (buffer.getDataType() == 1) {
            ConvertRaster.bufferedToGray((DataBufferUShort)buffer, src.getRaster(), dst);
            return dst;
        }
        ConvertRaster.bufferedToGray(src, dst);
        return dst;
    }

    public static GrayF32 convertFrom(BufferedImage src, GrayF32 dst) {
        if (dst != null) {
            dst.reshape(src.getWidth(), src.getHeight());
        } else {
            dst = new GrayF32(src.getWidth(), src.getHeight());
        }
        try {
            DataBuffer buff = src.getRaster().getDataBuffer();
            if (buff.getDataType() == 0) {
                if (ConvertBufferedImage.isKnownByteFormat(src)) {
                    ConvertRaster.bufferedToGray((DataBufferByte)buff, src.getRaster(), dst);
                } else {
                    ConvertRaster.bufferedToGray(src, dst);
                }
            } else if (buff.getDataType() == 3) {
                ConvertRaster.bufferedToGray((DataBufferInt)buff, src.getRaster(), dst);
            } else {
                ConvertRaster.bufferedToGray(src, dst);
            }
        }
        catch (AccessControlException e) {
            ConvertRaster.bufferedToGray(src, dst);
        }
        return dst;
    }

    public static <T extends ImageGray<T>> Planar<T> convertFromPlanar(BufferedImage src, Planar<T> dst, boolean orderRgb, Class<T> type) {
        block27: {
            if (src == null) {
                throw new IllegalArgumentException("src is null!");
            }
            if (dst != null) {
                dst.reshape(src.getWidth(), src.getHeight());
            }
            try {
                WritableRaster raster = src.getRaster();
                int numBands = !ConvertBufferedImage.isKnownByteFormat(src) ? 3 : raster.getNumBands();
                if (dst == null) {
                    dst = new Planar(type, src.getWidth(), src.getHeight(), numBands);
                } else if (dst.getNumBands() != numBands) {
                    dst.setNumberOfBands(numBands);
                }
                DataBuffer srcBuff = src.getRaster().getDataBuffer();
                if (type == GrayU8.class) {
                    if (srcBuff.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(src)) {
                        if (src.getType() == 10) {
                            for (int i = 0; i < dst.getNumBands(); ++i) {
                                ConvertRaster.bufferedToGray(src, (GrayU8)dst.getBand(i));
                            }
                        } else {
                            ConvertRaster.bufferedToMulti_U8((DataBufferByte)srcBuff, src.getRaster(), (Planar<GrayU8>)dst);
                        }
                    } else if (srcBuff.getDataType() == 3) {
                        ConvertRaster.bufferedToMulti_U8((DataBufferInt)srcBuff, src.getRaster(), (Planar<GrayU8>)dst);
                    } else {
                        ConvertRaster.bufferedToMulti_U8(src, (Planar<GrayU8>)dst);
                    }
                    break block27;
                }
                if (type == GrayF32.class) {
                    if (srcBuff.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(src)) {
                        if (src.getType() == 10) {
                            for (int i = 0; i < dst.getNumBands(); ++i) {
                                ConvertRaster.bufferedToGray(src, (GrayF32)dst.getBand(i));
                            }
                        } else {
                            ConvertRaster.bufferedToMulti_F32((DataBufferByte)srcBuff, src.getRaster(), (Planar<GrayF32>)dst);
                        }
                    } else if (srcBuff.getDataType() == 3) {
                        ConvertRaster.bufferedToMulti_F32((DataBufferInt)srcBuff, src.getRaster(), (Planar<GrayF32>)dst);
                    } else {
                        ConvertRaster.bufferedToMulti_F32(src, (Planar<GrayF32>)dst);
                    }
                    break block27;
                }
                throw new IllegalArgumentException("Band type not supported yet");
            }
            catch (AccessControlException e) {
                if (dst == null) {
                    dst = new Planar(type, src.getWidth(), src.getHeight(), 3);
                } else {
                    dst.setNumberOfBands(3);
                }
                if (type == GrayU8.class) {
                    ConvertRaster.bufferedToMulti_U8(src, dst);
                }
                if (type != GrayF32.class) break block27;
                ConvertRaster.bufferedToMulti_F32(src, (Planar<GrayF32>)dst);
            }
        }
        if (orderRgb) {
            ConvertBufferedImage.orderBandsIntoRGB(dst, src);
        }
        return dst;
    }

    public static <T extends ImageBase> T convertFrom(BufferedImage src, Class type, boolean orderRgb) {
        ImageInterleaved dst;
        if (ImageGray.class.isAssignableFrom(type)) {
            dst = ConvertBufferedImage.convertFromSingle(src, null, type);
        } else if (ImageInterleaved.class.isAssignableFrom(type)) {
            dst = GeneralizedImageOps.createInterleaved((Class)type, (int)1, (int)1, (int)3);
            ConvertBufferedImage.convertFromInterleaved(src, dst, orderRgb);
        } else {
            dst = new Planar(GrayU8.class, 1, 1, 3);
            ConvertBufferedImage.convertFrom(src, dst, orderRgb);
        }
        return (T)dst;
    }

    public static void convertFromInterleaved(BufferedImage src, ImageInterleaved dst, boolean orderRgb) {
        block25: {
            if (src == null) {
                throw new IllegalArgumentException("src is null!");
            }
            try {
                WritableRaster raster = src.getRaster();
                int numBands = !ConvertBufferedImage.isKnownByteFormat(src) ? 3 : raster.getNumBands();
                dst.setNumberOfBands(numBands);
                dst.reshape(src.getWidth(), src.getHeight());
                DataBuffer buffer = src.getRaster().getDataBuffer();
                if (dst instanceof InterleavedU8) {
                    if (buffer.getDataType() == 0) {
                        if (ConvertBufferedImage.isKnownByteFormat(src)) {
                            if (src.getType() == 10) {
                                ConvertRaster.bufferedToGray(src, (InterleavedU8)dst);
                            } else {
                                ConvertRaster.bufferedToInterleaved((DataBufferByte)buffer, src.getRaster(), (InterleavedU8)dst);
                            }
                        } else {
                            ConvertRaster.bufferedToInterleaved(src, (InterleavedU8)dst);
                        }
                    } else if (buffer.getDataType() == 3) {
                        ConvertRaster.bufferedToInterleaved((DataBufferInt)buffer, src.getRaster(), (InterleavedU8)dst);
                    } else {
                        ConvertRaster.bufferedToInterleaved(src, (InterleavedU8)dst);
                    }
                    break block25;
                }
                if (dst instanceof InterleavedF32) {
                    if (buffer.getDataType() == 0) {
                        if (ConvertBufferedImage.isKnownByteFormat(src)) {
                            if (src.getType() == 10) {
                                ConvertRaster.bufferedToGray(src, (InterleavedF32)dst);
                            } else {
                                ConvertRaster.bufferedToInterleaved((DataBufferByte)buffer, src.getRaster(), (InterleavedF32)dst);
                            }
                        } else {
                            ConvertRaster.bufferedToInterleaved(src, (InterleavedF32)dst);
                        }
                    } else if (buffer.getDataType() == 3) {
                        ConvertRaster.bufferedToInterleaved((DataBufferInt)buffer, src.getRaster(), (InterleavedF32)dst);
                    } else {
                        ConvertRaster.bufferedToInterleaved(src, (InterleavedF32)dst);
                    }
                    break block25;
                }
                throw new IllegalArgumentException("Data type not supported yet");
            }
            catch (AccessControlException e) {
                if (dst.getNumBands() != 3 || dst.getNumBands() != 1) {
                    dst.setNumberOfBands(3);
                }
                dst.reshape(src.getWidth(), src.getHeight());
                if (dst instanceof InterleavedU8) {
                    ConvertRaster.bufferedToInterleaved(src, (InterleavedU8)dst);
                }
                if (dst instanceof InterleavedF32) {
                    ConvertRaster.bufferedToInterleaved(src, (InterleavedF32)dst);
                }
                throw new IllegalArgumentException("Unsupported dst image type");
            }
        }
        if (orderRgb) {
            ConvertBufferedImage.orderBandsIntoRGB(dst, src);
        }
    }

    public static BufferedImage convertTo(ImageBase src, BufferedImage dst, boolean orderRgb) {
        if (src instanceof ImageGray) {
            if (GrayU8.class == src.getClass()) {
                return ConvertBufferedImage.convertTo((GrayU8)src, dst);
            }
            if (GrayI16.class.isInstance(src)) {
                return ConvertBufferedImage.convertTo((GrayI16)src, dst);
            }
            if (GrayF32.class == src.getClass()) {
                return ConvertBufferedImage.convertTo((GrayF32)src, dst);
            }
            throw new IllegalArgumentException("ImageGray type is not yet supported: " + src.getClass().getSimpleName());
        }
        if (src instanceof Planar) {
            Planar ms = (Planar)src;
            if (GrayU8.class == ms.getBandType()) {
                return ConvertBufferedImage.convertTo_U8((Planar<GrayU8>)ms, dst, orderRgb);
            }
            if (GrayF32.class == ms.getBandType()) {
                return ConvertBufferedImage.convertTo_F32((Planar<GrayF32>)ms, dst, orderRgb);
            }
            throw new IllegalArgumentException("Planar type is not yet supported: " + ms.getBandType().getSimpleName());
        }
        if (src instanceof ImageInterleaved) {
            if (InterleavedU8.class == src.getClass()) {
                return ConvertBufferedImage.convertTo((InterleavedU8)src, dst, orderRgb);
            }
            if (InterleavedF32.class == src.getClass()) {
                return ConvertBufferedImage.convertTo((InterleavedF32)src, dst, orderRgb);
            }
            throw new IllegalArgumentException("ImageGray type is not yet supported: " + src.getClass().getSimpleName());
        }
        throw new IllegalArgumentException("Image type is not yet supported: " + src.getClass().getSimpleName());
    }

    public static BufferedImage convertTo(GrayU8 src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs((ImageBase)src, dst);
        DataBuffer buffer = dst.getRaster().getDataBuffer();
        try {
            if (buffer.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(dst)) {
                ConvertRaster.grayToBuffered(src, (DataBufferByte)buffer, dst.getRaster());
            } else if (buffer.getDataType() == 3) {
                ConvertRaster.grayToBuffered(src, (DataBufferInt)buffer, dst.getRaster());
            } else {
                ConvertRaster.grayToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.grayToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo(GrayI16 src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs((ImageBase)src, dst);
        DataBuffer buffer = dst.getRaster().getDataBuffer();
        try {
            if (buffer.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(dst)) {
                ConvertRaster.grayToBuffered(src, (DataBufferByte)buffer, dst.getRaster());
            } else if (buffer.getDataType() == 3) {
                ConvertRaster.grayToBuffered(src, (DataBufferInt)buffer, dst.getRaster());
            } else if (buffer.getDataType() == 1) {
                ConvertRaster.grayToBuffered(src, (DataBufferUShort)buffer, dst.getRaster());
            } else {
                ConvertRaster.grayToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.grayToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo(GrayF32 src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs((ImageBase)src, dst);
        DataBuffer buffer = dst.getRaster().getDataBuffer();
        try {
            if (buffer.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(dst)) {
                ConvertRaster.grayToBuffered(src, (DataBufferByte)buffer, dst.getRaster());
            } else if (buffer.getDataType() == 3) {
                ConvertRaster.grayToBuffered(src, (DataBufferInt)buffer, dst.getRaster());
            } else {
                ConvertRaster.grayToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.grayToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo_U8(Planar<GrayU8> src, BufferedImage dst, boolean orderRgb) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        if (orderRgb) {
            src = ConvertBufferedImage.orderBandsIntoBuffered(src, dst);
        }
        DataBuffer buffer = dst.getRaster().getDataBuffer();
        try {
            if (buffer.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(dst)) {
                ConvertRaster.multToBuffered_U8((Planar<GrayU8>)src, (DataBufferByte)buffer, dst.getRaster());
            } else if (buffer.getDataType() == 3) {
                ConvertRaster.multToBuffered_U8((Planar<GrayU8>)src, (DataBufferInt)buffer, dst.getRaster());
            } else {
                ConvertRaster.multToBuffered_U8((Planar<GrayU8>)src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.multToBuffered_U8((Planar<GrayU8>)src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo_F32(Planar<GrayF32> src, BufferedImage dst, boolean orderRgb) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        if (orderRgb) {
            src = ConvertBufferedImage.orderBandsIntoBuffered(src, dst);
        }
        DataBuffer buffer = dst.getRaster().getDataBuffer();
        try {
            if (buffer.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(dst)) {
                ConvertRaster.multToBuffered_F32((Planar<GrayF32>)src, (DataBufferByte)buffer, dst.getRaster());
            } else if (buffer.getDataType() == 3) {
                ConvertRaster.multToBuffered_F32((Planar<GrayF32>)src, (DataBufferInt)buffer, dst.getRaster());
            } else {
                ConvertRaster.multToBuffered_F32((Planar<GrayF32>)src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.multToBuffered_F32((Planar<GrayF32>)src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo(InterleavedU8 src, BufferedImage dst, boolean orderRgb) {
        dst = ConvertBufferedImage.checkInputs((ImageBase)src, dst);
        DataBuffer buffer = dst.getRaster().getDataBuffer();
        try {
            if (buffer.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(dst)) {
                ConvertRaster.interleavedToBuffered(src, (DataBufferByte)buffer, dst.getRaster());
                if (orderRgb) {
                    ConvertBufferedImage.orderBandsBufferedFromRGB((DataBufferByte)buffer, dst.getRaster(), dst.getType());
                }
            } else if (buffer.getDataType() == 3) {
                ConvertRaster.interleavedToBuffered(src, (DataBufferInt)buffer, dst.getRaster());
                if (orderRgb) {
                    ConvertBufferedImage.orderBandsBufferedFromRGB((DataBufferInt)buffer, dst.getRaster(), dst.getType());
                }
            } else {
                ConvertRaster.interleavedToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.interleavedToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo(InterleavedF32 src, BufferedImage dst, boolean orderRgb) {
        dst = ConvertBufferedImage.checkInputs((ImageBase)src, dst);
        DataBuffer buffer = dst.getRaster().getDataBuffer();
        try {
            if (buffer.getDataType() == 0 && ConvertBufferedImage.isKnownByteFormat(dst)) {
                ConvertRaster.interleavedToBuffered(src, (DataBufferByte)buffer, dst.getRaster());
                if (orderRgb) {
                    ConvertBufferedImage.orderBandsBufferedFromRGB((DataBufferByte)buffer, dst.getRaster(), dst.getType());
                }
            } else if (buffer.getDataType() == 3) {
                ConvertRaster.interleavedToBuffered(src, (DataBufferInt)buffer, dst.getRaster());
                if (orderRgb) {
                    ConvertBufferedImage.orderBandsBufferedFromRGB((DataBufferInt)buffer, dst.getRaster(), dst.getType());
                }
            } else {
                ConvertRaster.interleavedToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.interleavedToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage checkInputs(ImageBase src, BufferedImage dst) {
        if (dst != null) {
            if (dst.getWidth() != src.getWidth() || dst.getHeight() != src.getHeight()) {
                throw new IllegalArgumentException("Shapes do not match: src = ( " + src.width + " , " + src.height + " )  dst = ( " + dst.getWidth() + " , " + dst.getHeight() + " )");
            }
        } else {
            dst = GrayI8.class.isInstance(src) ? new BufferedImage(src.getWidth(), src.getHeight(), 10) : (GrayF.class.isInstance(src) ? new BufferedImage(src.getWidth(), src.getHeight(), 10) : (GrayI.class.isInstance(src) ? new BufferedImage(src.getWidth(), src.getHeight(), 11) : new BufferedImage(src.getWidth(), src.getHeight(), 1)));
        }
        return dst;
    }

    public static BufferedImage convertTo(JComponent comp, BufferedImage storage) {
        if (storage == null) {
            storage = new BufferedImage(comp.getWidth(), comp.getHeight(), 1);
        }
        Graphics2D g2 = storage.createGraphics();
        comp.paintComponents(g2);
        return storage;
    }

    public static Planar orderBandsIntoBuffered(Planar src, BufferedImage dst) {
        if (dst.getType() == 1) {
            return src;
        }
        Planar tmp = new Planar(src.type, src.getNumBands());
        tmp.width = src.width;
        tmp.height = src.height;
        tmp.stride = src.stride;
        tmp.startIndex = src.startIndex;
        for (int i = 0; i < src.getNumBands(); ++i) {
            tmp.bands[i] = src.bands[i];
        }
        ConvertBufferedImage.orderBandsBufferedFromRgb(tmp, dst);
        return tmp;
    }

    public static void orderBandsBufferedFromRGB(DataBufferByte buffer, WritableRaster raster, int type) {
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = ConvertRaster.stride(raster);
        int offset = ConvertRaster.getOffset(raster);
        byte[] data = buffer.getData();
        if (5 == type) {
            for (int y = 0; y < height; ++y) {
                int index = offset + y * stride;
                for (int x = 0; x < width; ++x) {
                    byte tmp = data[index];
                    data[index] = data[index + 2];
                    data[index + 2] = tmp;
                    index += 3;
                }
            }
        } else if (6 == type) {
            for (int y = 0; y < height; ++y) {
                int index = offset + y * stride;
                for (int x = 0; x < width; ++x) {
                    byte tmp0 = data[index];
                    byte tmp1 = data[index + 1];
                    data[index] = data[index + 3];
                    data[index + 1] = data[index + 2];
                    data[index + 2] = tmp1;
                    data[index + 3] = tmp0;
                    index += 4;
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported buffered image type");
        }
    }

    public static void orderBandsBufferedFromRGB(DataBufferInt buffer, WritableRaster raster, int type) {
        if (1 == type) {
            return;
        }
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = ConvertRaster.stride(raster);
        int offset = ConvertRaster.getOffset(raster);
        int[] data = buffer.getData();
        if (4 == type) {
            for (int y = 0; y < height; ++y) {
                int index = offset + y * stride;
                int x = 0;
                while (x < width) {
                    int tmp = data[index];
                    int c1 = tmp & 0xFF;
                    int c2 = tmp >> 8 & 0xFF;
                    int c3 = tmp >> 16 & 0xFF;
                    data[index] = c1 << 16 | c2 << 8 | c3;
                    ++x;
                    ++index;
                }
            }
        } else if (2 == type) {
            for (int y = 0; y < height; ++y) {
                int index = offset + y * stride;
                int x = 0;
                while (x < width) {
                    int tmp = data[index];
                    int c1 = tmp & 0xFF;
                    int c2 = tmp >> 8 & 0xFF;
                    int c3 = tmp >> 16 & 0xFF;
                    int c4 = tmp >> 24 & 0xFF;
                    data[index] = c1 << 24 | c4 << 16 | c3 << 8 | c2;
                    ++x;
                    ++index;
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported buffered image type");
        }
    }

    public static <T extends ImageGray<T>> void orderBandsIntoRGB(Planar<T> image, BufferedImage input) {
        boolean swap = ConvertBufferedImage.swapBandOrder(input);
        if (swap) {
            if (image.getNumBands() == 3) {
                int bufferedImageType = input.getType();
                if (bufferedImageType == 5 || bufferedImageType == 4) {
                    ImageGray tmp = image.getBand(0);
                    image.bands[0] = image.getBand(2);
                    image.bands[2] = tmp;
                }
            } else if (image.getNumBands() == 4) {
                ImageGray[] temp = (ImageGray[])Array.newInstance(image.getBandType(), 4);
                int bufferedImageType = input.getType();
                if (bufferedImageType == 2) {
                    temp[0] = image.getBand(1);
                    temp[1] = image.getBand(2);
                    temp[2] = image.getBand(3);
                    temp[3] = image.getBand(0);
                } else if (bufferedImageType == 6) {
                    temp[0] = image.getBand(3);
                    temp[1] = image.getBand(2);
                    temp[2] = image.getBand(1);
                    temp[3] = image.getBand(0);
                }
                image.bands[0] = temp[0];
                image.bands[1] = temp[1];
                image.bands[2] = temp[2];
                image.bands[3] = temp[3];
            }
        }
    }

    public static <T extends ImageGray<T>> void orderBandsBufferedFromRgb(Planar<T> image, BufferedImage input) {
        boolean swap = ConvertBufferedImage.swapBandOrder(input);
        if (swap) {
            if (image.getNumBands() == 3) {
                int bufferedImageType = input.getType();
                if (bufferedImageType == 5 || bufferedImageType == 4) {
                    ImageGray tmp = image.getBand(0);
                    image.bands[0] = image.getBand(2);
                    image.bands[2] = tmp;
                }
            } else if (image.getNumBands() == 4) {
                ImageGray[] temp = (ImageGray[])Array.newInstance(image.getBandType(), 4);
                int bufferedImageType = input.getType();
                if (bufferedImageType == 2) {
                    temp[0] = image.getBand(3);
                    temp[1] = image.getBand(0);
                    temp[2] = image.getBand(1);
                    temp[3] = image.getBand(2);
                } else if (bufferedImageType == 6) {
                    temp[0] = image.getBand(3);
                    temp[1] = image.getBand(2);
                    temp[2] = image.getBand(1);
                    temp[3] = image.getBand(0);
                }
                image.bands[0] = temp[0];
                image.bands[1] = temp[1];
                image.bands[2] = temp[2];
                image.bands[3] = temp[3];
            }
        }
    }

    public static void orderBandsIntoRGB(ImageInterleaved image, BufferedImage input) {
        if (image instanceof InterleavedU8) {
            ConvertBufferedImage.orderBandsIntoRGB((InterleavedU8)image, input);
        } else if (image instanceof InterleavedF32) {
            ConvertBufferedImage.orderBandsIntoRGB((InterleavedF32)image, input);
        } else {
            throw new IllegalArgumentException("Unsupported interleaved type");
        }
    }

    public static void orderBandsIntoRGB(InterleavedU8 image, BufferedImage input) {
        block6: {
            int bufferedImageType;
            block8: {
                block7: {
                    boolean swap = ConvertBufferedImage.swapBandOrder(input);
                    if (!swap) break block6;
                    if (image.getNumBands() != 3) break block7;
                    for (int y = 0; y < image.height; ++y) {
                        int index;
                        int indexEnd = index + image.width * 3;
                        for (index = image.startIndex + y * image.stride; index < indexEnd; index += 3) {
                            byte tmp = image.data[index + 2];
                            image.data[index + 2] = image.data[index];
                            image.data[index] = tmp;
                        }
                    }
                    break block6;
                }
                if (image.getNumBands() != 4) break block6;
                bufferedImageType = input.getType();
                if (bufferedImageType != 2) break block8;
                for (int y = 0; y < image.height; ++y) {
                    int index;
                    int indexEnd = index + image.width * 3;
                    for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                        byte tmp = image.data[index];
                        image.data[index] = image.data[index + 1];
                        image.data[index + 1] = image.data[index + 2];
                        image.data[index + 2] = image.data[index + 3];
                        image.data[index + 3] = tmp;
                    }
                }
                break block6;
            }
            if (bufferedImageType != 6) break block6;
            for (int y = 0; y < image.height; ++y) {
                int index;
                int indexEnd = index + image.width * 3;
                for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                    byte tmp1 = image.data[index + 1];
                    byte tmp0 = image.data[index];
                    image.data[index] = image.data[index + 3];
                    image.data[index + 1] = image.data[index + 2];
                    image.data[index + 2] = tmp1;
                    image.data[index + 3] = tmp0;
                }
            }
        }
    }

    public static void orderBandsIntoRGB(InterleavedF32 image, BufferedImage input) {
        block6: {
            int bufferedImageType;
            block8: {
                block7: {
                    boolean swap = ConvertBufferedImage.swapBandOrder(input);
                    if (!swap) break block6;
                    if (image.getNumBands() != 3) break block7;
                    for (int y = 0; y < image.height; ++y) {
                        int index;
                        int indexEnd = index + image.width * 3;
                        for (index = image.startIndex + y * image.stride; index < indexEnd; index += 3) {
                            float tmp = image.data[index + 2];
                            image.data[index + 2] = image.data[index];
                            image.data[index] = tmp;
                        }
                    }
                    break block6;
                }
                if (image.getNumBands() != 4) break block6;
                bufferedImageType = input.getType();
                if (bufferedImageType != 2) break block8;
                for (int y = 0; y < image.height; ++y) {
                    int index;
                    int indexEnd = index + image.width * 3;
                    for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                        float tmp = image.data[index];
                        image.data[index] = image.data[index + 1];
                        image.data[index + 1] = image.data[index + 2];
                        image.data[index + 2] = image.data[index + 3];
                        image.data[index + 3] = tmp;
                    }
                }
                break block6;
            }
            if (bufferedImageType != 6) break block6;
            for (int y = 0; y < image.height; ++y) {
                int index;
                int indexEnd = index + image.width * 3;
                for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                    float tmp1 = image.data[index + 1];
                    float tmp0 = image.data[index];
                    image.data[index] = image.data[index + 3];
                    image.data[index + 1] = image.data[index + 2];
                    image.data[index + 2] = tmp1;
                    image.data[index + 3] = tmp0;
                }
            }
        }
    }

    private static boolean swapBandOrder(BufferedImage input) {
        int bufferedImageType = input.getType();
        return bufferedImageType == 5 || bufferedImageType == 4 || bufferedImageType == 2 || bufferedImageType == 6;
    }

    public static boolean isKnownByteFormat(BufferedImage image) {
        int type = image.getType();
        return type != 13 && type != 12 && type != 0;
    }

    public static boolean isSubImage(BufferedImage img) {
        return img.getRaster().getParent() != null;
    }
}

