/*
 * Decompiled with CFR 0.152.
 */
package boofcv.visualize;

import boofcv.visualize.PeriodicColorizer;

public abstract class TwoAxisRgbPlane
extends PeriodicColorizer {
    double planeScale;

    public TwoAxisRgbPlane(double planeScale) {
        this.planeScale = planeScale;
    }

    protected int color(double axis, double plane) {
        int red = (int)(255.0 * axis);
        int other = (int)(255.0 * plane);
        return red << 16 | other << 8 | 255 - other;
    }

    public static class Z_XY
    extends TwoAxisRgbPlane {
        public Z_XY(double planeScale) {
            super(planeScale);
        }

        @Override
        public int color(int index, double x, double y, double z) {
            double a = this.triangleWave(z);
            double b = this.triangleWave(x + y, this.period * this.planeScale);
            return this.color(a, b);
        }
    }

    public static class Y_XZ
    extends TwoAxisRgbPlane {
        public Y_XZ(double planeScale) {
            super(planeScale);
        }

        @Override
        public int color(int index, double x, double y, double z) {
            double a = this.triangleWave(y);
            double b = this.triangleWave(x + z, this.period * this.planeScale);
            return this.color(a, b);
        }
    }

    public static class X_YZ
    extends TwoAxisRgbPlane {
        public X_YZ(double planeScale) {
            super(planeScale);
        }

        @Override
        public int color(int index, double x, double y, double z) {
            double a = this.triangleWave(x);
            double b = this.triangleWave(y + z, this.period * this.planeScale);
            return this.color(a, b);
        }
    }
}

