/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.geo;

import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.alg.sfm.structure.SceneWorkingGraph;
import boofcv.io.calibration.CalibrationIO;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.image.ImageDimension;
import georegression.struct.se.Se3_F64;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class MultiViewIO {
    public static void save(PairwiseImageGraph graph, String path) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);
            MultiViewIO.save(graph, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(PairwiseImageGraph graph, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        out.println("# " + graph.getClass().getSimpleName() + " in YAML format. BoofCV " + "0.37");
        ArrayList motions = new ArrayList();
        for (int motionIdx = 0; motionIdx < graph.edges.size; ++motionIdx) {
            PairwiseImageGraph.Motion pmotion = (PairwiseImageGraph.Motion)graph.edges.get(motionIdx);
            BoofMiscOps.checkEq((int)pmotion.index, (int)motionIdx);
            HashMap<String, Object> element = new HashMap<String, Object>();
            motions.add(element);
            element.put("count_f", pmotion.countF);
            element.put("count_h", pmotion.countH);
            element.put("is_3D", pmotion.is3D);
            element.put("src", pmotion.src.id);
            element.put("dst", pmotion.dst.id);
            element.put("F", pmotion.F.data);
            element.put("inliers", MultiViewIO.encodeInliers((FastAccess<AssociatedIndex>)pmotion.inliers));
        }
        ArrayList views = new ArrayList();
        for (int viewIdx = 0; viewIdx < graph.nodes.size; ++viewIdx) {
            PairwiseImageGraph.View pview = (PairwiseImageGraph.View)graph.nodes.get(viewIdx);
            ArrayList connections = new ArrayList();
            pview.connections.forIdx((i, v) -> connections.add(v.index));
            HashMap<String, Object> element = new HashMap<String, Object>();
            views.add(element);
            element.put("id", pview.id);
            element.put("total_observations", pview.totalObservations);
            element.put("connections", connections);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("motions", motions);
        data.put("views", views);
        data.put("data_type", "PairwiseImageGraph");
        data.put("version", 0);
        yaml.dump(data, (Writer)out);
        out.close();
    }

    public static void save(SceneStructureMetric scene, String path) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);
            MultiViewIO.save(scene, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(SceneStructureMetric scene, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        out.println("# " + scene.getClass().getSimpleName() + " in YAML format. BoofCV " + "0.37");
        ArrayList views = new ArrayList();
        ArrayList motions = new ArrayList();
        ArrayList rigids = new ArrayList();
        ArrayList cameras = new ArrayList();
        ArrayList points = new ArrayList();
        scene.views.forEach(v -> views.add(MultiViewIO.encodeSceneView(scene, v)));
        scene.motions.forEach(m -> motions.add(MultiViewIO.encodeSceneMotion(m)));
        scene.rigids.forEach(r -> rigids.add(MultiViewIO.encodeSceneRigid(r)));
        scene.cameras.forEach(c -> cameras.add(MultiViewIO.encodeSceneCamera(c)));
        scene.points.forEach(p -> points.add(MultiViewIO.encodeScenePoint(p)));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("views", views);
        data.put("motions", motions);
        data.put("rigids", rigids);
        data.put("cameras", cameras);
        data.put("points", points);
        data.put("homogenous", scene.isHomogenous());
        data.put("data_type", "SceneStructureMetric");
        data.put("version", 0);
        yaml.dump(data, (Writer)out);
        out.close();
    }

    private static Map<String, Object> encodeSceneView(SceneStructureMetric scene, SceneStructureMetric.View v) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("camera", v.camera);
        encoded.put("parent_to_view", v.parent_to_view);
        if (v.parent != null) {
            encoded.put("parent", scene.views.indexOf((Object)v.parent));
        }
        return encoded;
    }

    private static Map<String, Object> encodeSceneMotion(SceneStructureMetric.Motion m) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("known", m.known);
        encoded.put("motion", MultiViewIO.putSE3(m.motion));
        return encoded;
    }

    private static Map<String, Object> encodeSceneRigid(SceneStructureMetric.Rigid r) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("known", r.known);
        encoded.put("object_to_world", MultiViewIO.putSE3(r.object_to_world));
        encoded.put("indexFirst", r.indexFirst);
        ArrayList<Map<String, Object>> points = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < r.points.length; ++i) {
            points.add(MultiViewIO.encodeScenePoint(r.points[i]));
        }
        encoded.put("points", points);
        return encoded;
    }

    private static Map<String, Object> encodeScenePoint(SceneStructureCommon.Point p) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("coordinate", p.coordinate);
        encoded.put("views", p.views.toArray());
        return encoded;
    }

    private static SceneStructureCommon.Point decodeScenePoint(Map<String, Object> map, @Nullable SceneStructureCommon.Point p) throws IOException {
        int i;
        List coordinate = (List)BoofMiscOps.getOrThrow(map, (Object)"coordinate");
        List views = (List)BoofMiscOps.getOrThrow(map, (Object)"views");
        if (p == null) {
            p = new SceneStructureCommon.Point(coordinate.size());
        }
        for (i = 0; i < coordinate.size(); ++i) {
            p.coordinate[i] = (Double)coordinate.get(i);
        }
        p.views.resize(views.size());
        for (i = 0; i < views.size(); ++i) {
            p.views.data[i] = (Integer)views.get(i);
        }
        return p;
    }

    private static List<Map<String, Object>> encodeInliers(FastAccess<AssociatedIndex> inliers) {
        ArrayList<Map<String, Object>> encoded = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < inliers.size; ++i) {
            AssociatedIndex a = (AssociatedIndex)inliers.get(i);
            HashMap<String, Integer> element = new HashMap<String, Integer>();
            element.put("src", a.src);
            element.put("dst", a.dst);
            encoded.add(element);
        }
        return encoded;
    }

    private static Map<String, Object> encodeSceneCamera(SceneStructureCommon.Camera c) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("known", c.known);
        if (!(c.model instanceof BundlePinholeSimplified)) {
            throw new RuntimeException("BundleAdjustmentCamera type not yet supported. " + c.getClass().getSimpleName());
        }
        Map<String, Object> model = MultiViewIO.putPinholeSimplified((BundlePinholeSimplified)c.model);
        model.put("type", "PinholeSimplified");
        encoded.put("model", model);
        return encoded;
    }

    private static SceneStructureCommon.Camera decodeSceneCamera(Map<String, Object> map, @Nullable SceneStructureCommon.Camera c) throws IOException {
        String type;
        if (c == null) {
            c = new SceneStructureCommon.Camera();
        }
        c.known = (Boolean)BoofMiscOps.getOrThrow(map, (Object)"known");
        Map model = (Map)BoofMiscOps.getOrThrow(map, (Object)"model");
        switch (type = (String)BoofMiscOps.getOrThrow((Map)model, (Object)"type")) {
            case "PinholeSimplified": {
                break;
            }
            default: {
                throw new RuntimeException("Unknown camera. " + type);
            }
        }
        c.model = MultiViewIO.loadPinholeSimplified(model, null);
        return c;
    }

    public static SceneStructureMetric load(String path, @Nullable SceneStructureMetric graph) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);
            return MultiViewIO.load((Reader)reader, graph);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SceneStructureMetric load(Reader reader, @Nullable SceneStructureMetric scene) {
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        try {
            int i;
            reader.close();
            boolean homogenous = (Boolean)BoofMiscOps.getOrThrow((Map)data, (Object)"homogenous");
            List yamlViews = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"views");
            List yamlMotions = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"motions");
            List yamlRigids = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"rigids");
            List yamlCameras = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"cameras");
            List yamlPoints = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"points");
            if (scene != null && scene.isHomogenous() != homogenous) {
                scene = null;
            }
            if (scene == null) {
                scene = new SceneStructureMetric(homogenous);
            }
            SceneStructureMetric _scene = scene;
            scene.initialize(yamlCameras.size(), yamlViews.size(), yamlMotions.size(), yamlPoints.size(), yamlRigids.size());
            for (i = 0; i < yamlViews.size(); ++i) {
                SceneStructureMetric.View v = (SceneStructureMetric.View)scene.views.get(i);
                Map yamlView = (Map)yamlViews.get(i);
                v.camera = (Integer)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"camera");
                v.parent_to_view = (Integer)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"parent_to_view");
                v.parent = yamlView.containsKey("parent") ? (SceneStructureMetric.View)scene.views.get(((Integer)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"parent")).intValue()) : null;
            }
            for (i = 0; i < yamlMotions.size(); ++i) {
                SceneStructureMetric.Motion m = (SceneStructureMetric.Motion)scene.motions.grow();
                Map yamlMotion = (Map)yamlMotions.get(i);
                m.known = (Boolean)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"known");
                MultiViewIO.loadSE3((Map)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"motion"), m.motion);
            }
            for (i = 0; i < yamlRigids.size(); ++i) {
                SceneStructureMetric.Rigid r = (SceneStructureMetric.Rigid)scene.rigids.get(i);
                Map yamlRigid = (Map)yamlRigids.get(i);
                r.known = (Boolean)BoofMiscOps.getOrThrow((Map)yamlRigid, (Object)"known");
                r.indexFirst = (Integer)BoofMiscOps.getOrThrow((Map)yamlRigid, (Object)"indexFirst");
                MultiViewIO.loadSE3((Map)BoofMiscOps.getOrThrow((Map)yamlRigid, (Object)"object_to_world"), r.object_to_world);
                List points = (List)BoofMiscOps.getOrThrow((Map)yamlRigid, (Object)"points");
                r.points = new SceneStructureCommon.Point[points.size()];
                for (int j = 0; j < r.points.length; ++j) {
                    r.points[j] = MultiViewIO.decodeScenePoint((Map)points.get(j), null);
                }
            }
            for (i = 0; i < scene.points.size; ++i) {
                MultiViewIO.decodeScenePoint((Map)yamlPoints.get(i), (SceneStructureCommon.Point)scene.points.get(i));
            }
            for (i = 0; i < yamlCameras.size(); ++i) {
                MultiViewIO.decodeSceneCamera((Map)yamlCameras.get(i), (SceneStructureCommon.Camera)scene.cameras.get(i));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return scene;
    }

    public static PairwiseImageGraph load(String path, @Nullable PairwiseImageGraph graph) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);
            return MultiViewIO.load((Reader)reader, graph);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static PairwiseImageGraph load(Reader reader, @Nullable PairwiseImageGraph graph) {
        if (graph == null) {
            graph = new PairwiseImageGraph();
        } else {
            graph.reset();
        }
        PairwiseImageGraph _graph = graph;
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        try {
            int i;
            reader.close();
            List yamlViews = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"views");
            List yamlMotions = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"motions");
            graph.nodes.resize(yamlViews.size());
            graph.edges.resize(yamlMotions.size());
            for (i = 0; i < yamlViews.size(); ++i) {
                Map yamlView = (Map)yamlViews.get(i);
                PairwiseImageGraph.View v = (PairwiseImageGraph.View)graph.nodes.get(i);
                v.id = (String)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"id");
                v.totalObservations = (Integer)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"total_observations");
                List yamlConnections = (List)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"connections");
                v.connections.resize(yamlConnections.size());
                v.connections.reset();
                yamlConnections.forEach(it -> v.connections.add((Object)((PairwiseImageGraph.Motion)_graph.edges.get(it.intValue()))));
                graph.mapNodes.put(v.id, v);
            }
            i = 0;
            while (i < yamlMotions.size()) {
                Map yamlMotion = (Map)yamlMotions.get(i);
                PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)graph.edges.get(i);
                m.countF = (Integer)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"count_f");
                m.countH = (Integer)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"count_h");
                m.is3D = (Boolean)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"is_3D");
                m.src = (PairwiseImageGraph.View)BoofMiscOps.getOrThrow((Map)graph.mapNodes, (Object)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"src"));
                m.dst = (PairwiseImageGraph.View)BoofMiscOps.getOrThrow((Map)graph.mapNodes, (Object)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"dst"));
                m.index = i++;
                MultiViewIO.copyIntoMatrix((List)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"F"), m.F);
                MultiViewIO.decodeInliers((List)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"inliers"), (DogArray<AssociatedIndex>)m.inliers);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return graph;
    }

    private static void copyIntoMatrix(List<Double> arrayData, DMatrixRMaj matrix) {
        BoofMiscOps.checkEq((int)arrayData.size(), (int)matrix.data.length);
        for (int j = 0; j < matrix.data.length; ++j) {
            matrix.data[j] = arrayData.get(j);
        }
    }

    private static void decodeInliers(List<Map<String, Object>> encoded, DogArray<AssociatedIndex> inliers) throws IOException {
        inliers.resize(encoded.size());
        for (int i = 0; i < inliers.size; ++i) {
            Map<String, Object> element = encoded.get(i);
            AssociatedIndex a = (AssociatedIndex)inliers.get(i);
            a.src = (Integer)BoofMiscOps.getOrThrow(element, (Object)"src");
            a.dst = (Integer)BoofMiscOps.getOrThrow(element, (Object)"dst");
        }
    }

    public static void save(SceneWorkingGraph working, String path) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);
            MultiViewIO.save(working, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(SceneWorkingGraph working, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        out.println("# " + working.getClass().getSimpleName() + " in YAML format. BoofCV " + "0.37");
        ArrayList views = new ArrayList();
        for (int viewIdx = 0; viewIdx < working.viewList.size(); ++viewIdx) {
            SceneWorkingGraph.View wview = (SceneWorkingGraph.View)working.viewList.get(viewIdx);
            HashMap<String, Object> element = new HashMap<String, Object>();
            views.add(element);
            element.put("pview", wview.pview.id);
            element.put("projective", wview.projective.data);
            element.put("intrinsic", MultiViewIO.putPinholeSimplified(wview.intrinsic));
            element.put("world_to_view", CalibrationIO.putSe3(wview.world_to_view));
            element.put("image_dimension", MultiViewIO.putDimension(wview.imageDimension));
            element.put("inliers", MultiViewIO.putInlierInfo(wview.inliers));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("views", views);
        data.put("data_type", "SceneWorkingGraph");
        data.put("version", 0);
        yaml.dump(data, (Writer)out);
        out.close();
    }

    public static SceneWorkingGraph load(String path, PairwiseImageGraph pairwise, @Nullable SceneWorkingGraph working) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);
            return MultiViewIO.load(reader, pairwise, working);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SceneWorkingGraph load(Reader reader, PairwiseImageGraph pairwise, @Nullable SceneWorkingGraph working) {
        if (working == null) {
            working = new SceneWorkingGraph();
        } else {
            working.reset();
        }
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        try {
            reader.close();
            List yamlViews = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"views");
            for (Map yamlView : yamlViews) {
                PairwiseImageGraph.View pview = pairwise.lookupNode((String)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"pview"));
                working.addView(pview);
            }
            for (Map yamlView : yamlViews) {
                SceneWorkingGraph.View wview = working.lookupView((String)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"pview"));
                MultiViewIO.copyIntoMatrix((List)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"projective"), wview.projective);
                MultiViewIO.loadPinholeSimplified((Map)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"intrinsic"), wview.intrinsic);
                CalibrationIO.loadSe3((Map)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"world_to_view"), wview.world_to_view);
                MultiViewIO.loadDimension((Map)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"image_dimension"), wview.imageDimension);
                MultiViewIO.loadInlierInfo((Map)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"inliers"), pairwise, wview.inliers);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return working;
    }

    public static Map<String, Object> putInlierInfo(SceneWorkingGraph.InlierInfo inliers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList views = new ArrayList();
        inliers.views.forIdx((i, v) -> views.add(v.id));
        ArrayList observations = new ArrayList();
        for (int viewIdx = 0; viewIdx < inliers.views.size; ++viewIdx) {
            ArrayList obs = new ArrayList();
            ((DogArray_I32)inliers.observations.get(viewIdx)).forIdx((i, v) -> obs.add(v));
            observations.add(obs);
        }
        map.put("views", views);
        map.put("observations", observations);
        return map;
    }

    public static SceneWorkingGraph.InlierInfo loadInlierInfo(Map<String, Object> map, PairwiseImageGraph pairwise, @Nullable SceneWorkingGraph.InlierInfo inliers) throws IOException {
        if (inliers == null) {
            inliers = new SceneWorkingGraph.InlierInfo();
        }
        SceneWorkingGraph.InlierInfo _inliers = inliers;
        List views = (List)BoofMiscOps.getOrThrow(map, (Object)"views");
        List observations = (List)BoofMiscOps.getOrThrow(map, (Object)"observations");
        inliers.views.resize(views.size());
        inliers.views.reset();
        BoofMiscOps.forIdx((List)views, (i, v) -> _inliers.views.add((Object)pairwise.lookupNode(v)));
        inliers.observations.resize(views.size());
        for (int viewIdx = 0; viewIdx < inliers.views.size; ++viewIdx) {
            List src = (List)observations.get(viewIdx);
            DogArray_I32 dst = (DogArray_I32)inliers.observations.get(viewIdx);
            dst.resize(src.size());
            dst.reset();
            src.forEach(arg_0 -> ((DogArray_I32)dst).add(arg_0));
        }
        return inliers;
    }

    public static Map<String, Object> putDimension(ImageDimension d) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", d.width);
        map.put("height", d.height);
        return map;
    }

    public static ImageDimension loadDimension(Map<String, Object> map, @Nullable ImageDimension dimension) {
        if (dimension == null) {
            dimension = new ImageDimension();
        }
        dimension.width = (Integer)map.get("width");
        dimension.height = (Integer)map.get("height");
        return dimension;
    }

    public static Map<String, Object> putPinholeSimplified(BundlePinholeSimplified intrinsic) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("f", intrinsic.f);
        map.put("k1", intrinsic.k1);
        map.put("k2", intrinsic.k2);
        return map;
    }

    public static BundlePinholeSimplified loadPinholeSimplified(Map<String, Object> map, @Nullable BundlePinholeSimplified intrinsic) {
        if (intrinsic == null) {
            intrinsic = new BundlePinholeSimplified();
        }
        intrinsic.f = (Double)map.get("f");
        intrinsic.k1 = (Double)map.get("k1");
        intrinsic.k2 = (Double)map.get("k2");
        return intrinsic;
    }

    public static Map<String, Object> putSE3(Se3_F64 m) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", m.T.x);
        map.put("y", m.T.y);
        map.put("z", m.T.z);
        map.put("R", m.R.data);
        return map;
    }

    public static Se3_F64 loadSE3(Map<String, Object> map, @Nullable Se3_F64 m) throws IOException {
        if (m == null) {
            m = new Se3_F64();
        }
        m.T.x = (Double)map.get("x");
        m.T.y = (Double)map.get("y");
        m.T.z = (Double)map.get("z");
        MultiViewIO.copyIntoMatrix((List)BoofMiscOps.getOrThrow(map, (Object)"R"), m.R);
        return m;
    }
}

