/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.video;

import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.video.BoofMjpegVideo;
import boofcv.io.video.VideoInterface;
import boofcv.io.video.VideoMjpegCodec;
import boofcv.io.wrapper.images.ImageStreamSequence;
import boofcv.io.wrapper.images.JpegByteImageSequence;
import boofcv.io.wrapper.images.LoadFileImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;

public class DynamicVideoInterface
implements VideoInterface {
    VideoInterface jcodec;
    VideoInterface ffmpeg;
    BoofMjpegVideo mjpeg = new BoofMjpegVideo();

    public DynamicVideoInterface() {
        try {
            this.ffmpeg = DynamicVideoInterface.loadManager("boofcv.io.ffmpeg.FfmpegVideo");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.jcodec = DynamicVideoInterface.loadManager("boofcv.io.jcodec.JCodecVideoInterface");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ImageBase<T>> SimpleImageSequence<T> load(String fileName, ImageType<T> imageType) {
        File f;
        URL url = UtilIO.ensureURL(fileName);
        if (url == null) {
            throw new RuntimeException("Can't open " + fileName);
        }
        String protocol = url.getProtocol();
        if (protocol.equals("file") && (f = new File(url.getFile())).isDirectory()) {
            return new LoadFileImageSequence<T>(imageType, url.getFile(), null);
        }
        String lowerName = fileName.toLowerCase();
        InputStream stream = null;
        try {
            stream = url.openStream();
            if (lowerName.endsWith("mjpeg") || lowerName.endsWith("mjpg")) {
                VideoMjpegCodec codec = new VideoMjpegCodec();
                List<byte[]> data = codec.read(stream);
                JpegByteImageSequence<T> jpegByteImageSequence = new JpegByteImageSequence<T>(imageType, data, false);
                return jpegByteImageSequence;
            }
            if (lowerName.endsWith("mpng")) {
                ImageStreamSequence<T> codec = new ImageStreamSequence<T>(stream, true, imageType);
                return codec;
            }
            if (this.ffmpeg != null) {
                SimpleImageSequence<T> codec = this.ffmpeg.load(fileName, imageType);
                return codec;
            }
            try {
                if (this.jcodec != null) {
                    SimpleImageSequence<T> sequence = this.jcodec.load(fileName, imageType);
                    System.err.println("WARNING: Using JCodec to read movie files as a last resort. Great that it works, but it's very slow. Might want to look at alternatives.");
                    SimpleImageSequence<T> simpleImageSequence = sequence;
                    return simpleImageSequence;
                }
            }
            catch (RuntimeException e) {
                System.err.println("JCodec Error: " + e.getMessage());
            }
            System.err.println("No working codec found for file: " + fileName);
        }
        catch (IOException e) {
            System.err.println("Error opening. " + e.getMessage());
            SimpleImageSequence<T> simpleImageSequence = null;
            return simpleImageSequence;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to close stream. " + e.getMessage());
                }
            }
        }
        return null;
    }

    public static VideoInterface loadManager(String pathToManager) {
        try {
            Class<?> c = Class.forName(pathToManager);
            return (VideoInterface)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found.  Is it included in the class path?");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

