/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU16;

public class ImplConvertImageMisc {
    public static void convert_F32_U16(GrayF32 src, int fractionBits, GrayU16 dst) {
        float scale = 1 << fractionBits;
        for (int y = 0; y < src.height; ++y) {
            int idxSrc = src.startIndex + y * src.stride;
            int idxDst = dst.startIndex + y * dst.stride;
            int end = idxSrc + src.width;
            while (idxSrc != end) {
                dst.data[idxDst++] = (short)(src.data[idxSrc++] * scale + 0.5f);
            }
        }
    }

    public static void convert_U16_F32(GrayU16 src, int fractionBits, GrayF32 dst) {
        float scale = 1 << fractionBits;
        for (int y = 0; y < src.height; ++y) {
            int idxSrc = src.startIndex + y * src.stride;
            int idxDst = dst.startIndex + y * dst.stride;
            int end = idxSrc + src.width;
            while (idxSrc != end) {
                dst.data[idxDst++] = (float)(src.data[idxSrc++] & 0xFFFF) / scale;
            }
        }
    }
}

