/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io;

import boofcv.io.MediaManager;
import boofcv.io.SerializeConfigYaml;
import boofcv.io.calibration.CalibrationIO;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;
import boofcv.struct.calib.CameraPinholeBrown;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.EulerType;
import georegression.struct.RotationType;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Quaternion_F64;
import georegression.struct.so.Rodrigues_F64;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.FileNameMap;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.swing.JFileChooser;
import org.apache.commons.io.FilenameUtils;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class UtilIO {
    public static final String UTF8 = "UTF-8";
    public static final String IMAGE_REGEX = "(.*/)*.+\\.(png|jpg|gif|bmp|jpeg|PNG|JPG|GIF|BMP|JPEG)$";

    public static void saveListStringYaml(List<String> list, File file) {
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
            Yaml yaml = CalibrationIO.createYmlObject();
            yaml.dump(list, (Writer)new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<String> loadListStringYaml(File file) {
        List list;
        URL url = UtilIO.ensureURL(file.getPath());
        if (url == null) {
            throw new RuntimeException("Unknown file=" + file.getPath());
        }
        BufferedInputStream reader = new BufferedInputStream(url.openStream());
        try {
            Yaml yaml = CalibrationIO.createYmlObject();
            list = (List)yaml.load((InputStream)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return list;
    }

    public static void savePoseListCsv(List<Se3_F64> list, RotationType type, File file) {
        try (FileOutputStream stream = new FileOutputStream(file);){
            UtilIO.savePoseListCsv(list, type, stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void savePoseListCsv(List<Se3_F64> list, RotationType type, OutputStream output) {
        PrintStream out = new PrintStream(output);
        out.println("# 6-DOF pose");
        out.println("# x, y, z, (rotation)");
        out.println("rotation=" + type.name());
        out.println("count=" + list.size());
        block5: for (int i = 0; i < list.size(); ++i) {
            Se3_F64 pose = list.get(i);
            out.printf("%.8e %.8e %.8e ", pose.T.x, pose.T.y, pose.T.z);
            switch (type) {
                case EULER: {
                    double[] euler = ConvertRotation3D_F64.matrixToEuler((DMatrixRMaj)pose.R, (EulerType)EulerType.XYZ, null);
                    out.printf("%.8e %.8e %.8e\n", euler[0], euler[1], euler[2]);
                    continue block5;
                }
                case QUATERNION: {
                    Quaternion_F64 quat = ConvertRotation3D_F64.matrixToQuaternion((DMatrixRMaj)pose.R, null);
                    out.printf("%.8e %.8e %.8e %.8e\n", quat.x, quat.y, quat.z, quat.w);
                    continue block5;
                }
                case RODRIGUES: {
                    Rodrigues_F64 rod = ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)pose.R, null);
                    Vector3D_F64 v = rod.unitAxisRotation;
                    out.printf("%.8e %.8e %.8e %.8e\n", v.x, v.y, v.z, rod.theta);
                }
            }
        }
    }

    public static void saveConfig(Configuration config, File file) {
        try (FileOutputStream stream = new FileOutputStream(file);){
            BufferedOutputStream output = new BufferedOutputStream(stream);
            new SerializeConfigYaml().serialize(config, null, new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <C extends Configuration> void saveConfig(C config, @Nullable C canonical, File file) {
        try {
            if (canonical == null) {
                canonical = (Configuration)config.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        try (FileOutputStream stream = new FileOutputStream(file);){
            BufferedOutputStream output = new BufferedOutputStream(stream);
            new SerializeConfigYaml().serialize(config, canonical, new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Configuration> T loadConfig(File file) {
        URL url = UtilIO.ensureURL(file.getPath());
        if (url == null) {
            throw new RuntimeException("Unknown file=" + file.getPath());
        }
        try (InputStream stream = url.openStream();){
            BufferedInputStream output = new BufferedInputStream(stream);
            Object t = new SerializeConfigYaml().deserialize(new InputStreamReader((InputStream)output, StandardCharsets.UTF_8));
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static URL pathExampleURL(String path) {
        try {
            File pathExample;
            File fpath = new File(path);
            if (fpath.isAbsolute()) {
                return fpath.toURI().toURL();
            }
            String pathToBase = UtilIO.getPathToBase();
            if (pathToBase != null && (pathExample = new File(pathToBase, "data/example/")).exists()) {
                return new File(pathExample.getPath(), path).getAbsoluteFile().toURI().toURL();
            }
            URL url = UtilIO.class.getClassLoader().getResource(path);
            if (url == null) {
                System.err.println(path);
                System.err.println();
                System.err.println("Can't find data/example directory!  There are three likely causes for this problem.");
                System.err.println();
                System.err.println("1) You checked out the source code from git and did not pull the data submodule too.");
                System.err.println("2) You are trying to run an example from outside the BoofCV directory tree.");
                System.err.println("3) You are trying to pass in your own image.");
                System.err.println();
                System.err.println("Solutions:");
                System.err.println("1) Follow instructions in the boofcv/readme.md file to grab the data directory.");
                System.err.println("2) Launch the example from inside BoofCV's directory tree!");
                System.err.println("3) Don't use this function and just pass in the path directly");
                System.exit(1);
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static CameraPinholeBrown loadExampleIntrinsic(MediaManager media, File exampleFile) {
        CameraPinholeBrown intrinsic = null;
        String specialName = FilenameUtils.getBaseName((String)exampleFile.getName()) + "_intrinsic.yaml";
        File specialIntrinsic = new File(exampleFile.getParent(), specialName);
        Reader reader = media.openFile(specialIntrinsic.getPath());
        if (reader != null) {
            intrinsic = (CameraPinholeBrown)CalibrationIO.load(reader);
        } else {
            reader = media.openFile(new File(exampleFile.getParent(), "intrinsic.yaml").getPath());
            if (reader != null) {
                intrinsic = (CameraPinholeBrown)CalibrationIO.load(reader);
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return Objects.requireNonNull(intrinsic);
    }

    public static BufferedReader openBufferedReader(String fileName) throws FileNotFoundException {
        InputStream stream = UtilIO.openStream(fileName);
        if (stream == null) {
            throw new FileNotFoundException("Can't open " + fileName);
        }
        return new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    @Nullable
    public static URL ensureURL(String path) {
        URL url;
        if ((path = UtilIO.systemToUnix(path)) == null) {
            return null;
        }
        try {
            url = new URL(path);
            if (url.getProtocol().equals("jar")) {
                return UtilIO.simplifyJarPath(url);
            }
        }
        catch (MalformedURLException e) {
            try {
                url = new File(path).toURI().toURL();
            }
            catch (MalformedURLException e2) {
                return null;
            }
        }
        return url;
    }

    public static URL ensureUrlNotNull(@Nullable String path) {
        if (path == null) {
            throw new RuntimeException("Null path provided");
        }
        return Objects.requireNonNull(UtilIO.ensureURL(path));
    }

    @Nullable
    public static String ensureFilePath(String path) {
        URL url = UtilIO.ensureURL(path);
        if (url == null) {
            return null;
        }
        try {
            return URLDecoder.decode(url.getPath(), UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static URL simplifyJarPath(URL url) {
        try {
            String[] segments = url.toString().split(".jar!/");
            String path = UtilIO.simplifyJarPath(segments[1]);
            return new URL(segments[0] + ".jar!/" + path);
        }
        catch (IOException e) {
            return url;
        }
    }

    public static String systemToUnix(String path) {
        if (path == null) {
            throw new RuntimeException("Path can't be null");
        }
        if (File.separatorChar == '\\') {
            return path.replace('\\', '/');
        }
        return path;
    }

    public static String simplifyJarPath(String path) {
        ArrayList<String> elements = new ArrayList<String>();
        File f = new File((String)path);
        boolean skip = false;
        do {
            if (!skip) {
                if (f.getName().equals("..")) {
                    skip = true;
                    continue;
                }
                elements.add(f.getName());
                continue;
            }
            skip = false;
        } while ((f = f.getParentFile()) != null);
        path = "";
        for (int i = elements.size() - 1; i >= 0; --i) {
            path = (String)path + (String)elements.get(i);
            if (i <= 0) continue;
            path = (String)path + "/";
        }
        return path;
    }

    @Nullable
    public static InputStream openStream(String path) {
        try {
            URL url = UtilIO.ensureURL(path);
            if (url != null) {
                return url.openStream();
            }
            System.err.println("Unable to open " + path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String readLine(InputStream input, StringBuilder buffer) throws IOException {
        buffer.setLength(0);
        int v;
        while ((v = input.read()) != -1 && v != 10) {
            if (v == 13) continue;
            buffer.append((char)v);
        }
        return buffer.toString();
    }

    public static int readInt(InputStream input) throws IOException {
        int v0 = UtilIO.checkEOF(input);
        int v1 = UtilIO.checkEOF(input);
        int v2 = UtilIO.checkEOF(input);
        int v3 = UtilIO.checkEOF(input);
        return v0 << 24 | v1 << 16 | v2 << 8 | v3;
    }

    private static int checkEOF(InputStream input) throws IOException {
        int value = input.read();
        if (value == -1) {
            throw new IOException("EOF reached");
        }
        return value;
    }

    public static void write(OutputStream output, String message) throws IOException {
        output.write(message.getBytes(StandardCharsets.UTF_8));
    }

    public static String pathExample(String path) {
        File pathExample;
        File fpath = new File(path);
        if (fpath.isAbsolute()) {
            return path;
        }
        String pathToBase = UtilIO.getPathToBase();
        if (pathToBase != null && (pathExample = new File(pathToBase, "data/example/")).exists()) {
            return UtilIO.ensureTrailingSlash(path, new File(pathExample.getPath(), path).getAbsolutePath());
        }
        return UtilIO.ensureTrailingSlash(path, UtilIO.pathExampleURL(path).toString());
    }

    private static String ensureTrailingSlash(String original, String result) {
        if (original.charAt(original.length() - 1) != '/') {
            return result;
        }
        if (result.charAt(result.length() - 1) == '/') {
            return result;
        }
        return result + "/";
    }

    public static File fileExample(String path) {
        return new File(UtilIO.pathExample(path));
    }

    public static String path(String path) {
        String pathToBase = UtilIO.getPathToBase();
        if (pathToBase == null) {
            return path;
        }
        return new File(pathToBase, path).getAbsolutePath();
    }

    public static File getFileToBase() {
        return new File(Objects.requireNonNull(UtilIO.getPathToBase()));
    }

    @Nullable
    public static String getPathToBase() {
        String[] files;
        File f;
        String path = new File(".").getAbsoluteFile().getParent();
        while (path != null && (f = new File(path)).exists() && (files = f.list()) != null) {
            boolean foundReadme = false;
            boolean foundMain = false;
            boolean foundExamples = false;
            boolean foundIntegration = false;
            for (String s : files) {
                if (s.compareToIgnoreCase("README.md") == 0) {
                    foundReadme = true;
                    continue;
                }
                if (s.compareToIgnoreCase("main") == 0) {
                    foundMain = true;
                    continue;
                }
                if (s.compareToIgnoreCase("examples") == 0) {
                    foundExamples = true;
                    continue;
                }
                if (s.compareToIgnoreCase("integration") != 0) continue;
                foundIntegration = true;
            }
            if (foundMain && foundExamples && foundIntegration && foundReadme) {
                return path;
            }
            path = f.getParent();
        }
        return null;
    }

    public static String selectFile(boolean exitOnCancel) {
        String fileName = null;
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            fileName = fc.getSelectedFile().getAbsolutePath();
        } else if (exitOnCancel) {
            System.exit(0);
        }
        return fileName;
    }

    public static void loadLibrarySmart(String libraryName) {
        String[] stuff;
        if (UtilIO.loadLibrary(libraryName)) {
            return;
        }
        String classPath = System.getProperty("java.class.path");
        for (String s : stuff = classPath.split(":")) {
            File f = new File(s);
            if (!f.isDirectory() || !(f = new File(s + "/" + libraryName)).exists()) continue;
            Object libraryPath = System.getProperty("java.library.path");
            libraryPath = (String)libraryPath + ":" + s;
            System.setProperty("java.library.path", (String)libraryPath);
            if (!UtilIO.loadLibrary(libraryName)) {
                throw new RuntimeException("Shouldn't have failed to load this time");
            }
            return;
        }
        System.out.println("classPath");
    }

    public static boolean loadLibrary(String libraryName) {
        try {
            System.out.println("tring to load: " + libraryName);
            System.loadLibrary(libraryName);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    public static void save(Object o, String fileName) {
        try (FileOutputStream fileOut = new FileOutputStream(fileName);){
            new ObjectOutputStream(fileOut).writeObject(o);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T load(String fileName) {
        @Nullable URL url = UtilIO.ensureURL(fileName);
        if (url == null) {
            throw new RuntimeException("Unknown path=" + fileName);
        }
        try (InputStream fileIn = url.openStream();){
            ObjectInputStream in = new ObjectInputStream(fileIn);
            Object object = in.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteRecursive(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                UtilIO.deleteRecursive(c);
            }
        }
        if (!f.delete()) {
            throw new RuntimeException("Failed to delete file: " + f);
        }
    }

    public static void copyRecursive(File src, File dst) {
        try {
            if (src.isDirectory()) {
                if (!dst.exists() && !dst.mkdirs()) {
                    throw new IOException("Cannot create dir " + dst.getAbsolutePath());
                }
                String[] children = src.list();
                for (int i = 0; i < children.length; ++i) {
                    UtilIO.copyRecursive(new File(src, children[i]), new File(dst, children[i]));
                }
            } else {
                int len;
                File directory = dst.getParentFile();
                if (directory != null && !directory.exists() && !directory.mkdirs()) {
                    throw new IOException("Cannot create dir " + directory.getAbsolutePath());
                }
                FileInputStream in = new FileInputStream(src);
                FileOutputStream out = new FileOutputStream(dst);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    public static String readAsString(String path) {
        InputStream stream = UtilIO.openStream(path);
        if (stream == null) {
            System.err.println("Failed to open " + path);
            return null;
        }
        return UtilIO.readAsString(stream);
    }

    @Nullable
    public static String readAsString(InputStream stream) {
        StringBuilder code = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                code.append(line).append(System.lineSeparator());
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        String output = code.toString();
        String nl = System.getProperty("line.separator");
        if (nl.compareTo("\n") != 0) {
            output = output.replaceAll(nl, "\n");
        }
        return output;
    }

    public static String getSourcePath(String pkg, String app) {
        String path = "";
        if (pkg == null || app == null) {
            return path;
        }
        String pathToBase = UtilIO.getPathToBase();
        if (pathToBase != null) {
            if (pkg.contains("examples")) {
                path = new File(pathToBase, "examples/src/main/java/").getAbsolutePath();
            } else if (pkg.contains("demonstrations")) {
                path = new File(pathToBase, "demonstrations/src/main/java/").getAbsolutePath();
            } else {
                System.err.println("pkg must be to examples or demonstrations. " + pkg);
                return path;
            }
            String pathToCode = pkg.replace('.', '/') + "/" + app + ".java";
            return new File(path, pathToCode).getPath();
        }
        String pathToCode = pkg.replace('.', '/') + "/" + app + ".java";
        URL url = UtilIO.class.getClassLoader().getResource(pathToCode);
        if (url != null) {
            return url.toString();
        }
        return pathToCode;
    }

    public static String getGithubURL(String pkg, String app) {
        String dir;
        if (pkg == null || app == null) {
            return "";
        }
        String base = "0.42".contains("SNAPSHOT") ? "https://github.com/lessthanoptimal/BoofCV/blob/769d3b60b3b58da2eb2606022c6a9495685e52cc/" : "https://github.com/lessthanoptimal/BoofCV/blob/v0.42/";
        if (((String)(pkg = ((String)pkg).replace('.', '/') + "/")).contains("demonstrations")) {
            dir = "demonstrations/";
        } else if (((String)pkg).contains("examples")) {
            dir = "examples/";
        } else {
            return "";
        }
        return base + dir + "src/main/java/" + (String)pkg + app + ".java";
    }

    public static int indexOfSourceStart(String code) {
        int state = 0;
        int indexLineStart = 0;
        int previous = 0;
        boolean justEntered = false;
        StringBuilder buffer = new StringBuilder(1024);
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (state == 1) {
                if (justEntered) {
                    justEntered = false;
                    if (c == '*') {
                        return indexLineStart;
                    }
                }
                if (previous == 42 && c == '/') {
                    state = 0;
                }
            } else if (state == 0) {
                if (previous == 47 && c == '/') {
                    state = 2;
                } else if (previous == 47 && c == '*') {
                    state = 1;
                    justEntered = true;
                } else {
                    buffer.append(c);
                }
            }
            if (c == '\n') {
                if (buffer.toString().contains("class")) {
                    return indexLineStart;
                }
                buffer.delete(0, buffer.length());
                indexLineStart = i + 1;
                if (state == 2) {
                    state = 0;
                }
            }
            previous = c;
        }
        if (buffer.toString().contains("class")) {
            return indexLineStart;
        }
        return 0;
    }

    public static List<String> listByPrefix(String directory, @Nullable String prefix, @Nullable String suffix) {
        File[] files;
        ArrayList<String> ret = new ArrayList<String>();
        File d = new File(directory);
        if (!d.isDirectory()) {
            try {
                URL url = new URL(directory);
                if (url.getProtocol().equals("file")) {
                    d = new File(url.getFile());
                } else if (url.getProtocol().equals("jar")) {
                    return UtilIO.listJarPrefix(url, prefix, suffix);
                }
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
        }
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory. " + directory);
        }
        for (File f : files = d.listFiles()) {
            if (f.isDirectory() || f.isHidden() || prefix != null && !f.getName().startsWith(prefix) || suffix != null && !f.getName().endsWith(suffix)) continue;
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }

    public static List<String> listSmart(String pathPattern, boolean sort, final BoofLambdas.Filter<Path> filter) {
        final ArrayList<String> results = new ArrayList<String>();
        if (pathPattern.startsWith("glob:") || pathPattern.startsWith("regex:")) {
            try {
                String baseDirectory = UtilIO.findBaseDirectoryInPattern(pathPattern);
                final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(pathPattern);
                Files.walkFileTree(Paths.get(baseDirectory, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                        if (pathMatcher.matches(path) && filter.keep((Object)path)) {
                            results.add(path.toString());
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        File directory = new File(pathPattern);
        if (!directory.isDirectory()) {
            try {
                URL url = new URL(pathPattern);
                if (url.getProtocol().equals("file")) {
                    directory = new File(url.getFile());
                } else if (url.getProtocol().equals("jar")) {
                    results.addAll(UtilIO.listJarFilter(url, (BoofLambdas.Filter<String>)((BoofLambdas.Filter)name -> filter.keep((Object)Path.of(name, new String[0])))));
                }
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
        }
        if (results.isEmpty()) {
            File[] files;
            if (directory.isFile()) {
                if (filter.keep((Object)directory.toPath())) {
                    results.add(pathPattern);
                }
            } else if (directory.isDirectory() && (files = directory.listFiles()) != null) {
                for (File f : files) {
                    if (!filter.keep((Object)f.toPath())) continue;
                    results.add(f.getPath());
                }
            }
        }
        if (sort) {
            Collections.sort(results);
        }
        return results;
    }

    static String findBaseDirectoryInPattern(String pathPattern) {
        File lastDirectory = new File("/");
        int start = pathPattern.indexOf(58) + 1;
        int end = -1;
        boolean previousDirectory = false;
        for (int i = start + 1; i <= pathPattern.length(); ++i) {
            File f = new File(pathPattern.substring(start, i));
            File parent = f.getParentFile();
            if (parent != null && previousDirectory && parent.getPath().equals(lastDirectory.getPath())) {
                end = i - 1;
            }
            if (!f.isDirectory()) {
                previousDirectory = false;
                continue;
            }
            previousDirectory = true;
            lastDirectory = f;
        }
        if (previousDirectory) {
            end = pathPattern.length();
        }
        return end != -1 ? pathPattern.substring(start, end) : "";
    }

    public static List<String> listSmartImages(String pathPattern, boolean sort) {
        return UtilIO.listSmart(pathPattern, sort, (BoofLambdas.Filter<Path>)((BoofLambdas.Filter)path -> path.toString().matches(IMAGE_REGEX)));
    }

    public static List<String> listImages(String directory, boolean sort) {
        List<String> found = UtilIO.listByRegex(directory, IMAGE_REGEX);
        if (sort) {
            Collections.sort(found);
        }
        return found;
    }

    public static List<String> listByRegex(String directory, String regex) {
        File[] files;
        ArrayList<String> ret = new ArrayList<String>();
        File d = new File(directory);
        if (!d.isDirectory()) {
            try {
                URL url = new URL(directory);
                if (url.getProtocol().equals("file")) {
                    d = new File(url.getFile());
                } else if (url.getProtocol().equals("jar")) {
                    return UtilIO.listJarRegex(url, regex);
                }
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
        }
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory. " + directory);
        }
        for (File f : files = d.listFiles()) {
            if (f.isDirectory() || f.isHidden() || !f.getName().matches(regex)) continue;
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }

    public static List<File> listFilesSorted(File directory) {
        ArrayList<File> ret = new ArrayList<File>();
        if (!directory.isDirectory()) {
            return ret;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return ret;
        }
        ret.addAll(Arrays.asList(files));
        Collections.sort(ret);
        return ret;
    }

    public static List<String> listAll(String directory) {
        File[] files;
        ArrayList<String> ret = new ArrayList<String>();
        try {
            URL url = new URL(directory);
            if (!url.getProtocol().equals("file")) {
                if (url.getProtocol().equals("jar")) {
                    return UtilIO.listJarPrefix(url, null, null);
                }
                throw new RuntimeException("Not sure what to do with this url. " + url.toString());
            }
            directory = url.getFile();
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        File d = new File(directory);
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory");
        }
        for (File f : files = d.listFiles()) {
            if (f.isDirectory() || f.isHidden()) continue;
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }

    public static List<String> listAllMime(String directory, String type) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            URL url = new URL(directory);
            if (!url.getProtocol().equals("file")) {
                if (url.getProtocol().equals("jar")) {
                    return UtilIO.listJarMime(url, null, null);
                }
                throw new RuntimeException("Not sure what to do with this url. " + url.toString());
            }
            directory = url.getFile();
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        File d = new File(directory);
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory");
        }
        File[] files = d.listFiles();
        if (files == null) {
            return ret;
        }
        for (File f : files) {
            if (f.isDirectory()) continue;
            try {
                String mimeType = Files.probeContentType(f.toPath());
                if (!mimeType.contains(type)) continue;
                ret.add(f.getAbsolutePath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Collections.sort(ret);
        return ret;
    }

    private static List<String> listJarFilter(URL url, BoofLambdas.Filter<String> filter) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            JarFile jarfile = connection.getJarFile();
            String targetPath = connection.getEntryName() + "/";
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (!ze.getName().startsWith(targetPath) || ze.getName().length() == targetPath.length() || !filter.keep((Object)ze.getName())) continue;
                output.add("jar:file:" + jarfile.getName() + "!/" + ze.getName());
            }
            jarfile.close();
            return output;
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    private static List<String> listJarPrefix(URL url, @Nullable String prefix, @Nullable String suffix) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            JarFile jarfile = connection.getJarFile();
            String targetPath = connection.getEntryName() + "/";
            if (prefix != null) {
                targetPath = targetPath + prefix;
            }
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (!ze.getName().startsWith(targetPath) || ze.getName().length() == targetPath.length() || suffix != null && !ze.getName().endsWith(suffix)) continue;
                output.add("jar:file:" + jarfile.getName() + "!/" + ze.getName());
            }
            jarfile.close();
            return output;
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    private static List<String> listJarMime(URL url, @Nullable String prefix, @Nullable String type) {
        ArrayList<String> output = new ArrayList<String>();
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            JarFile jarfile = connection.getJarFile();
            String targetPath = connection.getEntryName() + "/";
            if (prefix != null) {
                targetPath = targetPath + prefix;
            }
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                String path;
                String mimeType;
                ZipEntry ze = e.nextElement();
                if (!ze.getName().startsWith(targetPath) || ze.getName().length() == targetPath.length() || !(mimeType = fileNameMap.getContentTypeFor(path = "jar:file:" + jarfile.getName() + "!/" + ze.getName())).contains(type)) continue;
                output.add(path);
            }
            jarfile.close();
            return output;
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    private static List<String> listJarRegex(URL url, String regex) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            JarFile jarfile = connection.getJarFile();
            String targetPath = connection.getEntryName() + "/";
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                String shortName;
                ZipEntry ze = e.nextElement();
                if (!ze.getName().startsWith(targetPath) || ze.getName().length() == targetPath.length() || !(shortName = ze.getName().substring(targetPath.length())).matches(regex)) continue;
                output.add("jar:file:" + jarfile.getName() + "!/" + ze.getName());
            }
            jarfile.close();
            return output;
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    public static File[] findMatches(File directory, String regex) {
        Pattern p = Pattern.compile(regex);
        return directory.listFiles(file -> p.matcher(file.getName()).matches());
    }

    public static boolean validURL(URL url) {
        try {
            url.openConnection();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void copyToFile(InputStream in, File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            if (in == null) {
                throw new RuntimeException("Input is null");
            }
            byte[] buffer = new byte[0x100000];
            while (in.available() > 0) {
                int amount = in.read(buffer, 0, buffer.length);
                out.write(buffer, 0, amount);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void delete(File f, FileTest test) throws IOException {
        File[] files;
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File c : files) {
                UtilIO.delete(c, test);
            }
        }
        if (test.isTarget(f) && !f.delete()) {
            throw new IOException("Failed to delete file: " + f);
        }
    }

    public static String checkIfJarAndCopyToTemp(String filename) {
        URL url = UtilIO.ensureURL(filename);
        if (url == null) {
            throw new RuntimeException("Invalid: " + filename);
        }
        switch (url.getProtocol()) {
            case "file": {
                filename = url.getPath();
                try {
                    filename = URLDecoder.decode(filename, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                filename = new File(filename).getAbsolutePath();
                break;
            }
            case "jar": {
                System.out.println("Copying the file from the jar as a work around");
                String suffix = FilenameUtils.getExtension((String)filename);
                try {
                    InputStream in = UtilIO.openStream(filename);
                    if (in == null) {
                        throw new RuntimeException("Failed to open " + filename);
                    }
                    File tempFile = File.createTempFile("boofcv_jar_hack_", suffix);
                    tempFile.deleteOnExit();
                    UtilIO.copyToFile(in, tempFile);
                    in.close();
                    filename = tempFile.getAbsolutePath();
                    break;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return filename;
    }

    public static void mkdirs(File directory) {
        if (directory.exists()) {
            BoofMiscOps.checkTrue((boolean)directory.isDirectory());
        } else {
            BoofMiscOps.checkTrue((boolean)directory.mkdirs());
        }
    }

    public static void mkdirs(File directory, boolean delete) {
        if (!delete) {
            UtilIO.mkdirs(directory);
            return;
        }
        if (directory.exists()) {
            UtilIO.deleteRecursive(directory);
        }
        BoofMiscOps.checkTrue((boolean)directory.mkdirs());
    }

    public static interface FileTest {
        public boolean isTarget(File var1);
    }
}

