/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.PolygonRegion;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_F64;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ConvertLabeledImageFormats {
    public static GrayS32 convert(List<PolygonRegion> regions, int width, int height, @Nullable GrayS32 output) {
        if (output == null) {
            output = new GrayS32(width, height);
        } else {
            output.reshape(width, height);
        }
        GrayU8 gray = new GrayU8(width, height);
        BufferedImage buffered = new BufferedImage(width, height, 10);
        Polygon polygon = new Polygon();
        for (PolygonRegion r : regions) {
            Graphics2D g2 = buffered.createGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, width, height);
            g2.setColor(Color.BLACK);
            polygon.reset();
            for (int i = 0; i < r.polygon.size(); ++i) {
                Point2D_F64 p = r.polygon.get(i);
                polygon.addPoint((int)p.x, (int)p.y);
            }
            Point2D_F64 p = r.polygon.get(0);
            polygon.addPoint((int)p.x, (int)p.y);
            g2.fill(polygon);
            ConvertBufferedImage.convertFrom(buffered, gray);
            GrayS32 _output = output;
            gray.forEachXY((x, y) -> {
                if (gray.unsafe_get(x, y) == 0) {
                    _output.unsafe_set(x, y, r.regionID);
                }
            });
        }
        return output;
    }
}

