/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.misc.BoofLambdas;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;

public class ImageFileListIterator<T extends ImageBase<T>>
implements Iterator<T> {
    protected T image;
    protected List<String> paths;
    protected int index;
    protected BoofLambdas.Transform<T> filter = a -> a;
    protected HandleException exception = (idx, path, e) -> {
        e.printStackTrace(System.err);
        System.err.println("Bad Image: " + this.paths.get(this.index));
    };

    public ImageFileListIterator(List<String> paths, ImageType<T> imageType) {
        this.image = imageType.createImage(1, 1);
        this.paths = paths;
        this.reset();
    }

    public void reset() {
        this.index = -1;
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.paths.size();
    }

    @Override
    public T next() {
        while (true) {
            try {
                ++this.index;
                this.loadImage(this.index);
            }
            catch (RuntimeException e) {
                this.exception.process(this.index, this.paths.get(this.index), e);
                if (this.index < this.paths.size()) continue;
            }
            break;
        }
        return (T)((ImageBase)this.filter.process(this.image));
    }

    public T loadImage(int index) {
        BufferedImage buffered = UtilImageIO.loadImage(this.paths.get(index));
        if (buffered == null) {
            throw new RuntimeException("Unknown path=" + this.paths.get(index));
        }
        ConvertBufferedImage.convertFrom(buffered, true, this.image);
        return this.image;
    }

    public T getImage() {
        return this.image;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public int getIndex() {
        return this.index;
    }

    public BoofLambdas.Transform<T> getFilter() {
        return this.filter;
    }

    public void setFilter(BoofLambdas.Transform<T> filter) {
        this.filter = filter;
    }

    public HandleException getException() {
        return this.exception;
    }

    public void setException(HandleException exception) {
        this.exception = exception;
    }

    @FunctionalInterface
    public static interface HandleException {
        public void process(int var1, String var2, RuntimeException var3);
    }
}

