/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.alg.misc.ImageStatistics;
import boofcv.io.UtilIO;
import boofcv.struct.image.GrayS32;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class LabeledImageRleCodec {
    public static void encode(GrayS32 labeled, OutputStream writer, String ... comments) throws IOException {
        int numLabels = ImageStatistics.max((GrayS32)labeled) + 1;
        writer.write(String.format("LabeledRLE,w=%d,h=%d,labels=%d,format=txt,version=1\n", labeled.width, labeled.height, numLabels).getBytes(StandardCharsets.UTF_8));
        for (String comment : comments) {
            writer.write(("# " + comment + "\n").getBytes(StandardCharsets.UTF_8));
        }
        int value = labeled.get(0, 0);
        int length = 0;
        for (int y = 0; y < labeled.height; ++y) {
            int index = labeled.startIndex + y * labeled.stride;
            for (int x = 0; x < labeled.width; ++x) {
                int v;
                if ((v = labeled.data[index++]) == value) {
                    ++length;
                    continue;
                }
                writer.write((length + "," + value + "\n").getBytes(StandardCharsets.UTF_8));
                value = v;
                length = 1;
            }
        }
        writer.write((length + "," + value + "\n").getBytes(StandardCharsets.UTF_8));
    }

    public static void decode(InputStream reader, GrayS32 labeled) throws IOException {
        StringBuilder buffer = new StringBuilder(1024);
        String line = UtilIO.readLine(reader, buffer);
        if (!line.startsWith("LabeledRLE")) {
            throw new IOException("Invalid. Does not start with LabeledRLE");
        }
        String[] words = line.split(",");
        int width = 0;
        int height = 0;
        int version = -1;
        boolean txt = false;
        block12: for (int i = 1; i < words.length; ++i) {
            String[] values = words[i].split("=");
            if (values.length != 2) {
                throw new IOException("Unexpected: " + words[i]);
            }
            switch (values[0]) {
                case "w": {
                    width = Integer.parseInt(values[1]);
                    continue block12;
                }
                case "h": {
                    height = Integer.parseInt(values[1]);
                    continue block12;
                }
                case "version": {
                    version = Integer.parseInt(values[1]);
                    continue block12;
                }
                case "format": {
                    txt = values[1].equalsIgnoreCase("txt");
                }
            }
        }
        if (!txt) {
            throw new IOException("Can only read text format");
        }
        if (version <= 0) {
            throw new IOException("Unknown version.");
        }
        labeled.reshape(width, height);
        int index = 0;
        while (reader.available() > 0) {
            line = UtilIO.readLine(reader, buffer);
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            words = line.split(",");
            if (words.length != 2) {
                throw new IOException("Unexpected: " + line);
            }
            int length = Integer.parseInt(words[0]);
            int value = Integer.parseInt(words[1]);
            for (int i = 0; i < length; ++i) {
                labeled.data[index++] = value;
            }
        }
    }
}

