/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import boofcv.alg.cloud.PointCloudReader;
import boofcv.alg.cloud.PointCloudWriter;
import boofcv.alg.meshing.VertexMesh;
import boofcv.io.UtilIO;
import boofcv.io.points.impl.PlyReader;
import boofcv.io.points.impl.PlyWriter;
import georegression.struct.point.Point3D_F64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class PlyCodec {
    public static void saveAscii(PlyWriter data, Writer outputWriter) throws IOException {
        PlyCodec.writeAsciiHeader(data.getVertexCount(), data.getPolygonCount(), data.isColor(), outputWriter);
        boolean color = data.isColor();
        Point3D_F64 p = new Point3D_F64();
        for (int i = 0; i < data.getVertexCount(); ++i) {
            data.getVertex(i, p);
            if (color) {
                int rgb = data.getColor(i);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                outputWriter.write(String.format("%f %f %f %d %d %d\n", p.x, p.y, p.z, r, g, b));
                continue;
            }
            outputWriter.write(String.format("%f %f %f\n", p.x, p.y, p.z));
        }
        int[] indexes = new int[100];
        for (int i = 0; i < data.getPolygonCount(); ++i) {
            int size = data.getIndexes(i, indexes);
            outputWriter.write(size);
            for (int idxidx = 0; idxidx < size; ++idxidx) {
                outputWriter.write(" " + indexes[idxidx]);
            }
            outputWriter.write(10);
        }
        outputWriter.flush();
    }

    public static void saveMeshAscii(VertexMesh mesh, @Nullable DogArray_I32 colorRGB, Writer outputWriter) throws IOException {
        PlyCodec.saveAscii(PlyCodec.wrapMeshForWriting(mesh, colorRGB), outputWriter);
    }

    public static void saveCloudAscii(PointCloudReader cloud, boolean saveRgb, Writer outputWriter) throws IOException {
        PlyCodec.saveAscii(PlyCodec.wrapCloudForWriting(cloud, saveRgb), outputWriter);
    }

    private static void writeAsciiHeader(int vertexCount, int triangleCount, boolean hasColor, Writer outputWriter) throws IOException {
        outputWriter.write("ply\n");
        outputWriter.write("format ascii 1.0\n");
        outputWriter.write("comment Created using BoofCV!\n");
        outputWriter.write("element vertex " + vertexCount + "\nproperty float x\nproperty float y\nproperty float z\n");
        if (hasColor) {
            outputWriter.write("property uchar red\nproperty uchar green\nproperty uchar blue\n");
        }
        if (triangleCount > 0) {
            outputWriter.write("element face " + triangleCount + "\nproperty list uchar int vertex_indices\n");
        }
        outputWriter.write("end_header\n");
    }

    public static void saveCloudBinary(PointCloudReader cloud, ByteOrder order, boolean saveRgb, boolean saveAsFloat, OutputStream outputWriter) throws IOException {
        PlyCodec.saveBinary(PlyCodec.wrapCloudForWriting(cloud, saveRgb), order, saveAsFloat, outputWriter);
    }

    public static void saveMeshBinary(VertexMesh mesh, @Nullable DogArray_I32 colorRGB, ByteOrder order, boolean saveAsFloat, OutputStream outputWriter) throws IOException {
        PlyCodec.saveBinary(PlyCodec.wrapMeshForWriting(mesh, colorRGB), order, saveAsFloat, outputWriter);
    }

    public static void saveBinary(PlyWriter data, ByteOrder order, boolean saveAsFloat, OutputStream outputWriter) throws IOException {
        String format = "UTF-8";
        int dataLength = saveAsFloat ? 4 : 8;
        PlyCodec.writeBinaryHeader(data.getVertexCount(), data.getPolygonCount(), order, data.isColor(), saveAsFloat, format, outputWriter);
        boolean color = data.isColor();
        int end = dataLength * 3;
        ByteBuffer bytes = ByteBuffer.allocate(dataLength * 3 + (color ? 3 : 0));
        bytes.order(order);
        Point3D_F64 p = new Point3D_F64();
        for (int i = 0; i < data.getVertexCount(); ++i) {
            data.getVertex(i, p);
            if (saveAsFloat) {
                bytes.putFloat(0, (float)p.x);
                bytes.putFloat(4, (float)p.y);
                bytes.putFloat(8, (float)p.z);
            } else {
                bytes.putDouble(0, p.x);
                bytes.putDouble(8, p.y);
                bytes.putDouble(16, p.z);
            }
            if (color) {
                int rgb = data.getColor(i);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                bytes.put(end, (byte)r);
                bytes.put(end + 1, (byte)g);
                bytes.put(end + 2, (byte)b);
            }
            outputWriter.write(bytes.array());
        }
        int[] indexes = new int[100];
        bytes = ByteBuffer.allocate(1 + indexes.length * 4);
        for (int i = 0; i < data.getPolygonCount(); ++i) {
            int size = data.getIndexes(i, indexes);
            bytes.position(0);
            bytes.put((byte)size);
            for (int idx = 0; idx < indexes.length; ++idx) {
                bytes.putInt(indexes[idx]);
            }
            outputWriter.write(bytes.array(), 0, 1 + 4 * size);
        }
        outputWriter.flush();
    }

    private static void writeBinaryHeader(int vertexCount, int triangleCount, ByteOrder order, boolean hasColor, boolean saveAsFloat, String format, OutputStream outputWriter) throws IOException {
        String string;
        String dataType = saveAsFloat ? "float" : "double";
        outputWriter.write("ply\n".getBytes(format));
        switch (order.toString()) {
            case "LITTLE_ENDIAN": {
                string = "little";
                break;
            }
            case "BIG_ENDIAN": {
                string = "big";
                break;
            }
            default: {
                throw new RuntimeException("Unexpected order=" + order);
            }
        }
        String orderStr = string;
        outputWriter.write(("format binary_" + orderStr + "_endian 1.0\n").getBytes(format));
        outputWriter.write("comment Created using BoofCV!\n".getBytes(format));
        outputWriter.write(("element vertex " + vertexCount + "\n").getBytes(format));
        outputWriter.write(("property " + dataType + " x\nproperty " + dataType + " y\nproperty " + dataType + " z\n").getBytes(format));
        if (hasColor) {
            outputWriter.write("property uchar red\nproperty uchar green\nproperty uchar blue\n".getBytes(format));
        }
        if (triangleCount > 0) {
            outputWriter.write(("element face " + triangleCount + "\nproperty list uchar int vertex_indices\n").getBytes(format));
        }
        outputWriter.write("end_header\n".getBytes(format));
    }

    private static String readNextPly(InputStream reader, boolean failIfNull, StringBuilder buffer) throws IOException {
        String line = UtilIO.readLine(reader, buffer);
        while (line.length() != 0) {
            if (line.startsWith("comment")) {
                line = UtilIO.readLine(reader, buffer);
                continue;
            }
            return line;
        }
        if (failIfNull) {
            throw new IOException("Unexpected end of file");
        }
        return line;
    }

    private static void readHeader(InputStream input, Header header) throws IOException {
        StringBuilder buffer = new StringBuilder();
        String line = UtilIO.readLine(input, buffer);
        if (line.length() == 0) {
            throw new IOException("Missing first line");
        }
        if (line.compareToIgnoreCase("ply") != 0) {
            throw new IOException("Expected PLY at start of file");
        }
        line = PlyCodec.readNextPly(input, true, buffer);
        boolean previousVertex = false;
        while (line.length() != 0 && !line.equals("end_header")) {
            String[] words = line.split("\\s+");
            if (words.length == 1) {
                throw new IOException("Expected more than one word");
            }
            if (line.startsWith("format")) {
                Format format;
                switch (words[1]) {
                    case "ascii": {
                        format = Format.ASCII;
                        break;
                    }
                    case "binary_little_endian": {
                        format = Format.BINARY_LITTLE;
                        break;
                    }
                    case "binary_big_endian": {
                        format = Format.BINARY_BIG;
                        break;
                    }
                    default: {
                        throw new IOException("Unknown format " + words[1]);
                    }
                }
                header.format = format;
            } else if (line.startsWith("element")) {
                previousVertex = false;
                if (words[1].equals("vertex")) {
                    previousVertex = true;
                    header.vertexCount = Integer.parseInt(words[2]);
                } else if (words[1].equals("face")) {
                    header.triangleCount = Integer.parseInt(words[2]);
                }
            } else if (words[0].equals("property") && previousVertex) {
                VarType v;
                DataType dataType;
                switch (words[1].toLowerCase()) {
                    case "float": {
                        dataType = DataType.FLOAT;
                        break;
                    }
                    case "double": {
                        dataType = DataType.DOUBLE;
                        break;
                    }
                    case "char": {
                        dataType = DataType.CHAR;
                        break;
                    }
                    case "short": {
                        dataType = DataType.SHORT;
                        break;
                    }
                    case "int": {
                        dataType = DataType.INT;
                        break;
                    }
                    case "uchar": {
                        dataType = DataType.UCHAR;
                        break;
                    }
                    case "ushort": {
                        dataType = DataType.USHORT;
                        break;
                    }
                    case "uint": {
                        dataType = DataType.UINT;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Add support for " + words[1]);
                    }
                }
                DataType d = dataType;
                switch (words[2].toLowerCase()) {
                    case "x": {
                        v = VarType.X;
                        break;
                    }
                    case "y": {
                        v = VarType.Y;
                        break;
                    }
                    case "z": {
                        v = VarType.Z;
                        break;
                    }
                    case "red": {
                        v = VarType.R;
                        header.rgb = true;
                        break;
                    }
                    case "green": {
                        v = VarType.G;
                        header.rgb = true;
                        break;
                    }
                    case "blue": {
                        v = VarType.B;
                        header.rgb = true;
                        break;
                    }
                    default: {
                        v = VarType.UNKNOWN;
                    }
                }
                header.dataWords.add(new DataWord(v, d));
            } else if (!words[0].equals("property") || !words[1].equals("list")) {
                throw new IOException("Unknown header element: '" + line + "'");
            }
            line = PlyCodec.readNextPly(input, true, buffer);
        }
    }

    public static void readCloud(InputStream input, final PointCloudWriter output) throws IOException {
        PlyCodec.read(input, new PlyReader(){

            @Override
            public void initialize(int vertexes, int triangles, boolean color) {
                output.initialize(vertexes, color);
            }

            @Override
            public void addVertex(double x, double y, double z, int rgb) {
                output.add(x, y, z, rgb);
            }

            @Override
            public void addPolygon(int[] indexes, int offset, int length) {
            }
        });
    }

    public static void readMesh(InputStream input, final VertexMesh mesh, final DogArray_I32 colorRGB) throws IOException {
        PlyCodec.read(input, new PlyReader(){

            @Override
            public void initialize(int vertexes, int triangles, boolean color) {
                colorRGB.reset();
                mesh.vertexes.reset();
                mesh.indexes.reset();
                mesh.vertexes.reserve(vertexes);
                mesh.indexes.reserve(triangles * 3);
                mesh.offsets.add(0);
            }

            @Override
            public void addVertex(double x, double y, double z, int rgb) {
                mesh.vertexes.append(x, y, z);
                colorRGB.add(rgb);
            }

            @Override
            public void addPolygon(int[] indexes, int offset, int length) {
                mesh.offsets.add(mesh.indexes.size + length);
                mesh.indexes.addAll(indexes, offset, offset + length);
            }
        });
    }

    public static void read(InputStream input, PlyReader output) throws IOException {
        Header header = new Header();
        PlyCodec.readHeader(input, header);
        if (header.vertexCount == -1) {
            throw new IOException("File is missing vertex count");
        }
        if (header.format == null) {
            throw new IOException("Format is never specified");
        }
        output.initialize(header.vertexCount, header.triangleCount, header.rgb);
        switch (header.format) {
            case ASCII: {
                PlyCodec.readAscii(output, input, header.dataWords, header.vertexCount, header.rgb, header.triangleCount);
                break;
            }
            case BINARY_LITTLE: {
                PlyCodec.readCloudBinary(output, input, header.dataWords, ByteOrder.LITTLE_ENDIAN, header.vertexCount, header.rgb, header.triangleCount);
                break;
            }
            case BINARY_BIG: {
                PlyCodec.readCloudBinary(output, input, header.dataWords, ByteOrder.BIG_ENDIAN, header.vertexCount, header.rgb, header.triangleCount);
                break;
            }
            default: {
                throw new RuntimeException("BUG!");
            }
        }
    }

    private static void readAscii(PlyReader output, InputStream reader, List<DataWord> dataWords, int vertexCount, boolean rgb, int triangleCount) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int I32 = -1;
        double F64 = -1.0;
        int r = 0;
        int g = 0;
        int b = 0;
        double x = -1.0;
        double y = -1.0;
        double z = -1.0;
        for (int i = 0; i < vertexCount; ++i) {
            String line = PlyCodec.readNextPly(reader, true, buffer);
            String[] words = line.split("\\s+");
            if (words.length != dataWords.size()) {
                throw new IOException("unexpected number of words. " + line);
            }
            block13: for (int j = 0; j < dataWords.size(); ++j) {
                DataWord d = dataWords.get(j);
                String word = words[j];
                switch (d.data) {
                    case FLOAT: 
                    case DOUBLE: {
                        F64 = Double.parseDouble(word);
                        break;
                    }
                    case UINT: 
                    case INT: 
                    case USHORT: 
                    case SHORT: 
                    case UCHAR: 
                    case CHAR: {
                        I32 = Integer.parseInt(word);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported");
                    }
                }
                switch (d.var) {
                    case X: {
                        x = F64;
                        continue block13;
                    }
                    case Y: {
                        y = F64;
                        continue block13;
                    }
                    case Z: {
                        z = F64;
                        continue block13;
                    }
                    case R: {
                        r = I32;
                        continue block13;
                    }
                    case G: {
                        g = I32;
                        continue block13;
                    }
                    case B: {
                        b = I32;
                        continue block13;
                    }
                }
            }
            output.addVertex(x, y, z, r << 16 | g << 8 | b);
        }
        int[] indexes = new int[100];
        for (int i = 0; i < triangleCount; ++i) {
            int n;
            String line = PlyCodec.readNextPly(reader, true, buffer);
            String[] words = line.split("\\s+");
            if (words.length != (n = Integer.parseInt(words[0])) + 1) {
                throw new RuntimeException("Unexpected number of words.");
            }
            for (int wordIdx = 1; wordIdx <= n; ++wordIdx) {
                indexes[wordIdx - 1] = Integer.parseInt(words[i]);
            }
            output.addPolygon(indexes, 0, n);
        }
    }

    private static void readCloudBinary(PlyReader output, InputStream reader, List<DataWord> dataWords, ByteOrder order, int vertexCount, boolean rgb, int triangleCount) throws IOException {
        int totalBytes = 0;
        for (int i = 0; i < dataWords.size(); ++i) {
            totalBytes += dataWords.get((int)i).data.size;
        }
        byte[] line = new byte[totalBytes];
        ByteBuffer bb = ByteBuffer.wrap(line);
        bb.order(order);
        int I32 = -1;
        double F64 = -1.0;
        int r = -1;
        int g = -1;
        int b = -1;
        double x = -1.0;
        double y = -1.0;
        double z = -1.0;
        for (int i = 0; i < vertexCount; ++i) {
            int found = reader.read(line);
            if (line.length != found) {
                throw new IOException("Read unexpected number of bytes. " + found + " vs " + line.length);
            }
            int location = 0;
            block20: for (int j = 0; j < dataWords.size(); ++j) {
                DataWord d = dataWords.get(j);
                switch (d.data) {
                    case FLOAT: {
                        F64 = bb.getFloat(location);
                        break;
                    }
                    case DOUBLE: {
                        F64 = bb.getDouble(location);
                        break;
                    }
                    case CHAR: {
                        I32 = bb.get(location);
                        break;
                    }
                    case UCHAR: {
                        I32 = bb.get(location) & 0xFF;
                        break;
                    }
                    case SHORT: {
                        I32 = bb.getShort(location);
                        break;
                    }
                    case USHORT: {
                        I32 = bb.getShort(location) & 0xFFFF;
                        break;
                    }
                    case INT: {
                        I32 = bb.getInt(location);
                        break;
                    }
                    case UINT: {
                        I32 = bb.getInt(location);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported");
                    }
                }
                location += d.data.size;
                switch (d.var) {
                    case X: {
                        x = F64;
                        continue block20;
                    }
                    case Y: {
                        y = F64;
                        continue block20;
                    }
                    case Z: {
                        z = F64;
                        continue block20;
                    }
                    case R: {
                        r = I32;
                        continue block20;
                    }
                    case G: {
                        g = I32;
                        continue block20;
                    }
                    case B: {
                        b = I32;
                        continue block20;
                    }
                }
            }
            output.addVertex(x, y, z, r << 16 | g << 8 | b);
        }
        byte[] polygonLine = new byte[40];
        ByteBuffer polygonBB = ByteBuffer.wrap(polygonLine);
        int[] indexes = new int[100];
        boolean offset = false;
        for (int i = 0; i < triangleCount; ++i) {
            if (1 != reader.read(line, 0, 1)) {
                throw new RuntimeException("Couldn't read count byte");
            }
            int count = line[0] & 0xFF;
            int lineLength = count * 4;
            if (polygonLine.length < lineLength) {
                throw new RuntimeException("polygonLine is too small. vertexes=" + count);
            }
            int found = reader.read(polygonLine, 0, lineLength);
            if (found != lineLength) {
                throw new IOException("Read unexpected number of bytes. " + found + " vs " + lineLength);
            }
            for (int wordIndex = 0; wordIndex < count; ++wordIndex) {
                indexes[wordIndex] = polygonBB.getInt(wordIndex * 4);
            }
            output.addPolygon(indexes, 0, count);
        }
    }

    private static PlyWriter wrapMeshForWriting(final VertexMesh mesh, final @Nullable DogArray_I32 colorRGB) {
        return new PlyWriter(){

            @Override
            public int getVertexCount() {
                return mesh.vertexes.size();
            }

            @Override
            public int getPolygonCount() {
                return mesh.offsets.size - 1;
            }

            @Override
            public boolean isColor() {
                return colorRGB != null;
            }

            @Override
            public void getVertex(int which, Point3D_F64 vertex) {
                mesh.vertexes.getCopy(which, vertex);
            }

            @Override
            public int getColor(int which) {
                return colorRGB.get(which);
            }

            @Override
            public int getIndexes(int which, int[] indexes) {
                int idx0 = mesh.offsets.get(which);
                int idx1 = mesh.offsets.get(which + 1);
                for (int i = idx0; i < idx1; ++i) {
                    indexes[i - idx0] = mesh.indexes.get(i);
                }
                return idx1 - idx0;
            }
        };
    }

    private static PlyWriter wrapCloudForWriting(final PointCloudReader cloud, final boolean saveRgb) {
        return new PlyWriter(){

            @Override
            public int getVertexCount() {
                return cloud.size();
            }

            @Override
            public int getPolygonCount() {
                return 0;
            }

            @Override
            public boolean isColor() {
                return saveRgb;
            }

            @Override
            public void getVertex(int which, Point3D_F64 vertex) {
                cloud.get(which, vertex);
            }

            @Override
            public int getColor(int which) {
                return cloud.getRGB(which);
            }

            @Override
            public int getIndexes(int which, int[] indexes) {
                return 0;
            }
        };
    }

    private static enum Format {
        ASCII,
        BINARY_LITTLE,
        BINARY_BIG;

    }

    private static class Header {
        List<DataWord> dataWords = new ArrayList<DataWord>();
        int vertexCount = -1;
        int triangleCount = -1;
        boolean rgb = false;
        Format format = Format.ASCII;

        private Header() {
        }
    }

    private static enum DataType {
        FLOAT(4),
        DOUBLE(8),
        CHAR(1),
        SHORT(2),
        INT(4),
        UCHAR(1),
        USHORT(2),
        UINT(4);

        final int size;

        private DataType(int size) {
            this.size = size;
        }
    }

    private static enum VarType {
        X,
        Y,
        Z,
        R,
        G,
        B,
        UNKNOWN;

    }

    private static class DataWord {
        VarType var;
        DataType data;

        public DataWord(VarType var, DataType data) {
            this.var = var;
            this.data = data;
        }
    }
}

