/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.video;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class VideoMjpegCodec {
    public static final byte SOI = -40;
    public static final byte EOI = -39;

    public List<byte[]> read(InputStream streamIn) {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        try {
            byte[] b = VideoMjpegCodec.convertToByteArray(streamIn);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(b));
            while (this.findMarker(in, (byte)-40) && in.available() > 0) {
                byte[] data = this.readJpegData(in, (byte)-39);
                ret.add(data);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    @Nullable
    public byte[] readFrame(DataInputStream in) {
        try {
            if (this.findMarker(in, (byte)-40) && in.available() > 0) {
                return this.readJpegData(in, (byte)-39);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static byte[] convertToByteArray(InputStream streamIn) throws IOException {
        int length;
        ByteArrayOutputStream temp = new ByteArrayOutputStream(1024);
        byte[] data = new byte[1024];
        while ((length = streamIn.read(data)) != -1) {
            temp.write(data, 0, length);
        }
        return temp.toByteArray();
    }

    private boolean findMarker(DataInputStream in, byte marker) throws IOException {
        boolean foundFF = false;
        while (in.available() > 0) {
            byte b = in.readByte();
            if (foundFF) {
                if (b == marker) {
                    return true;
                }
                if (b == -1) continue;
                foundFF = false;
                continue;
            }
            if (b != -1) continue;
            foundFF = true;
        }
        return foundFF;
    }

    private byte[] readJpegData(DataInputStream in, byte marker) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        bout.write(255);
        bout.write(-40);
        boolean foundFF = false;
        while (in.available() > 0) {
            byte d = in.readByte();
            if (foundFF) {
                if (d == marker) break;
                bout.write(255);
                bout.write(d);
                foundFF = false;
                continue;
            }
            if (d == -1) {
                foundFF = true;
                continue;
            }
            bout.write(d);
        }
        return bout.toByteArray();
    }
}

