/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import boofcv.alg.cloud.PointCloudReader;
import boofcv.alg.cloud.PointCloudWriter;
import boofcv.io.points.impl.ObjFileReader;
import boofcv.io.points.impl.ObjFileWriter;
import boofcv.struct.mesh.VertexMesh;
import georegression.struct.point.Point3D_F64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.ddogleg.struct.DogArray_I32;

public class ObjFileCodec {
    public static void save(PointCloudReader cloud, Writer writer) throws IOException {
        ObjFileWriter obj = new ObjFileWriter(writer);
        obj.addComment("Created by BoofCV");
        Point3D_F64 point = new Point3D_F64();
        int N = cloud.size();
        for (int i = 0; i < N; ++i) {
            cloud.get(i, point);
            obj.addVertex(point.x, point.y, point.z);
            obj.addPoint(-1);
        }
    }

    public static void save(VertexMesh mesh, Writer writer) throws IOException {
        ObjFileWriter obj = new ObjFileWriter(writer);
        obj.addComment("Created by BoofCV");
        int N = mesh.vertexes.size();
        for (int i = 0; i < N; ++i) {
            Point3D_F64 p = mesh.vertexes.getTemp(i);
            obj.addVertex(p.x, p.y, p.z);
        }
        DogArray_I32 indexes = new DogArray_I32();
        for (int i = 1; i < mesh.offsets.size; ++i) {
            int idx0 = mesh.offsets.get(i - 1);
            int idx1 = mesh.offsets.get(i);
            indexes.reset();
            indexes.addAll(mesh.indexes.data, idx0, idx1);
            obj.addFace(indexes);
        }
    }

    public static void load(InputStream input, final PointCloudWriter output) throws IOException {
        ObjFileReader obj = new ObjFileReader(){

            @Override
            protected void addVertex(double x, double y, double z) {
                output.add(x, y, z, 0);
            }

            @Override
            protected void addPoint(int vertex) {
            }

            @Override
            protected void addLine(DogArray_I32 vertexes) {
            }

            @Override
            protected void addFace(DogArray_I32 vertexes) {
            }
        };
        obj.parse(new BufferedReader(new InputStreamReader(input)));
    }

    public static void load(InputStream input, final VertexMesh output) throws IOException {
        output.reset();
        ObjFileReader obj = new ObjFileReader(){

            @Override
            protected void addVertex(double x, double y, double z) {
                output.vertexes.append(x, y, z);
            }

            @Override
            protected void addPoint(int vertex) {
            }

            @Override
            protected void addLine(DogArray_I32 vertexes) {
            }

            @Override
            protected void addFace(DogArray_I32 vertexes) {
                output.indexes.addAll(vertexes);
                output.offsets.add(output.indexes.size);
            }
        };
        obj.parse(new BufferedReader(new InputStreamReader(input)));
    }
}

