/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import java.io.BufferedReader;
import java.io.IOException;
import org.ddogleg.struct.DogArray_I32;

public abstract class ObjFileReader {
    DogArray_I32 vertexIndexes = new DogArray_I32();
    int vertexCount = 0;

    public void parse(BufferedReader reader) throws IOException {
        String l;
        this.vertexCount = 0;
        StringBuilder builder = new StringBuilder();
        int actualLineCount = 0;
        while ((l = reader.readLine()) != null) {
            Object line;
            String chunk;
            ++actualLineCount;
            if (l.length() == 0 || l.charAt(0) == '#' || (chunk = l.trim()).isEmpty()) continue;
            if (chunk.endsWith("\\")) {
                if (builder.length() != 0) {
                    builder.append(' ');
                }
                builder.append(chunk);
                continue;
            }
            if (builder.length() == 0) {
                line = chunk;
            } else {
                line = builder.toString() + " " + chunk;
                builder.setLength(0);
            }
            String[] words = ((String)line).split("\\s+");
            try {
                switch (words[0]) {
                    case "v": {
                        double x = Double.parseDouble(words[1]);
                        double y = Double.parseDouble(words[2]);
                        double z = Double.parseDouble(words[3]);
                        this.addVertex(x, y, z);
                        ++this.vertexCount;
                        break;
                    }
                    case "p": {
                        this.addPoint(this.ensureIndex(Integer.parseInt(words[1])));
                        break;
                    }
                    case "l": {
                        this.readPoints(words);
                        this.addLine(this.vertexIndexes);
                        break;
                    }
                    case "f": {
                        this.readPoints(words);
                        this.addFace(this.vertexIndexes);
                        break;
                    }
                    default: {
                        this.handleError(actualLineCount + " Unknown object type. '" + words[0] + "'");
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.handleError(actualLineCount + " Bad object description " + words[0] + " '" + e.getMessage() + "'");
            }
        }
    }

    int ensureIndex(int found) {
        if (found > 0) {
            return found - 1;
        }
        return this.vertexCount + found;
    }

    private void readPoints(String[] words) {
        this.vertexIndexes.reset();
        for (int i = 1; i < words.length; ++i) {
            this.vertexIndexes.add(this.ensureIndex(Integer.parseInt(words[i])));
        }
    }

    protected abstract void addVertex(double var1, double var3, double var5);

    protected abstract void addPoint(int var1);

    protected abstract void addLine(DogArray_I32 var1);

    protected abstract void addFace(DogArray_I32 var1);

    protected void handleError(String message) {
        System.err.println(message);
    }
}

