/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.recognition;

import boofcv.abst.scene.ConfigFeatureToSceneRecognition;
import boofcv.abst.scene.WrapFeatureToSceneRecognition;
import boofcv.abst.scene.ann.FeatureSceneRecognitionNearestNeighbor;
import boofcv.abst.scene.nister2006.FeatureSceneRecognitionNister2006;
import boofcv.alg.scene.ann.RecognitionNearestNeighborInvertedFile;
import boofcv.alg.scene.bow.InvertedFile;
import boofcv.alg.scene.nister2006.RecognitionVocabularyTreeNister2006;
import boofcv.alg.scene.vocabtree.HierarchicalVocabularyTree;
import boofcv.factory.scene.FactorySceneRecognition;
import boofcv.io.UtilIO;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;
import boofcv.struct.PackedArray;
import boofcv.struct.feature.PackedTupleBigArray_B;
import boofcv.struct.feature.PackedTupleBigArray_F32;
import boofcv.struct.feature.PackedTupleBigArray_F64;
import boofcv.struct.feature.PackedTupleBigArray_U8;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_I8;
import boofcv.struct.feature.TupleDesc_S8;
import boofcv.struct.feature.TupleDesc_U8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.kmeans.TuplePointDistanceEuclideanSq;
import boofcv.struct.kmeans.TuplePointDistanceHamming;
import deepboof.io.DeepBoofDataBaseOps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ddogleg.clustering.PointDistance;
import org.ddogleg.struct.BigDogArray_I32;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class RecognitionIO {
    public static final String CONFIG_NAME = "config.yaml";
    public static final String IMAGE_ID_NAME = "image_ids.yaml";
    public static final String DATABASE_NAME = "database.bin";
    public static final String DICTIONARY_NAME = "dictionary.bin";
    public static final String INVERTED_NAME = "inverted_files.bin";

    public static <Image extends ImageBase<Image>, TD extends TupleDesc<TD>> WrapFeatureToSceneRecognition<Image, TD> downloadDefaultSceneRecognition(File destination, ImageType<Image> imageType) {
        if (!destination.exists()) {
            BoofMiscOps.checkTrue((boolean)destination.mkdirs());
        } else if (destination.isFile()) {
            throw new IllegalArgumentException("Destination must be a directory not a file");
        }
        File modelDir = new File(destination, "scene_recognition");
        if (!modelDir.exists()) {
            DeepBoofDataBaseOps.downloadModel((String)"http://boofcv.org/notwiki/largefiles/scene_recognition_default38_inria_holidays.zip", (File)destination);
        }
        return RecognitionIO.loadFeatureToScene(modelDir, imageType);
    }

    public static <TD extends TupleDesc<TD>> void saveFeatureToScene(WrapFeatureToSceneRecognition<?, TD> def, File dir) {
        if (dir.exists() && !dir.isDirectory()) {
            throw new IllegalArgumentException("Destination must not exist or be a directory");
        }
        if (!dir.exists()) {
            BoofMiscOps.checkTrue((boolean)dir.mkdirs());
        }
        UtilIO.saveConfig((Configuration)def.getConfig(), new File(dir, CONFIG_NAME));
        List listImageIds = null;
        switch (def.getConfig().typeRecognize) {
            case NISTER_2006: {
                FeatureSceneRecognitionNister2006 recognizer = (FeatureSceneRecognitionNister2006)def.getRecognizer();
                RecognitionIO.saveTreeBin(recognizer.getDatabase(), new File(dir, DATABASE_NAME));
                listImageIds = recognizer.getImageIds();
                break;
            }
            case NEAREST_NEIGHBOR: {
                FeatureSceneRecognitionNearestNeighbor recognizer = (FeatureSceneRecognitionNearestNeighbor)def.getRecognizer();
                RecognitionIO.saveDictionaryBin(recognizer.getDictionary(), recognizer.getTupleDOF(), recognizer.getDescriptorType(), new File(dir, DICTIONARY_NAME));
                RecognitionIO.saveNearestNeighborBin(recognizer.getDatabase(), new File(dir, INVERTED_NAME));
                listImageIds = recognizer.getImageIds();
            }
        }
        Objects.requireNonNull(listImageIds);
        if (!listImageIds.isEmpty()) {
            UtilIO.saveListStringYaml(listImageIds, new File(dir, IMAGE_ID_NAME));
        }
    }

    public static <Image extends ImageBase<Image>, TD extends TupleDesc<TD>> WrapFeatureToSceneRecognition<Image, TD> loadFeatureToScene(File dir, ImageType<Image> imageType) {
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory doesn't exist: " + dir.getPath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Path is not a directory: " + dir.getPath());
        }
        ConfigFeatureToSceneRecognition config = (ConfigFeatureToSceneRecognition)UtilIO.loadConfig(new File(dir, CONFIG_NAME));
        WrapFeatureToSceneRecognition alg = FactorySceneRecognition.createFeatureToScene((ConfigFeatureToSceneRecognition)config, imageType);
        boolean loadImagesIDs = new File(dir, IMAGE_ID_NAME).exists();
        switch (config.typeRecognize) {
            case NISTER_2006: {
                FeatureSceneRecognitionNister2006 recognizer = (FeatureSceneRecognitionNister2006)alg.getRecognizer();
                RecognitionIO.loadTreeBin(new File(dir, DATABASE_NAME), recognizer.getDatabase());
                if (loadImagesIDs) {
                    recognizer.getImageIds().addAll(UtilIO.loadListStringYaml(new File(dir, IMAGE_ID_NAME)));
                }
                recognizer.setDatabase(recognizer.getDatabase());
                break;
            }
            case NEAREST_NEIGHBOR: {
                FeatureSceneRecognitionNearestNeighbor recognizer = (FeatureSceneRecognitionNearestNeighbor)alg.getRecognizer();
                List<TD> dictionary = RecognitionIO.loadDictionaryBin(new File(dir, DICTIONARY_NAME));
                recognizer.setDictionary(dictionary);
                RecognitionIO.loadNearestNeighborBin(new File(dir, INVERTED_NAME), recognizer.getDatabase());
                if (!loadImagesIDs) break;
                recognizer.getImageIds().addAll(UtilIO.loadListStringYaml(new File(dir, IMAGE_ID_NAME)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + config.typeRecognize);
            }
        }
        return alg;
    }

    public static <TD extends TupleDesc<TD>> void saveNister2006(FeatureSceneRecognitionNister2006<TD> def, File dir) {
        if (dir.exists() && !dir.isDirectory()) {
            throw new IllegalArgumentException("Destination must not exist or be a directory");
        }
        if (!dir.exists()) {
            BoofMiscOps.checkTrue((boolean)dir.mkdirs());
        }
        UtilIO.saveConfig((Configuration)def.getConfig(), new File(dir, CONFIG_NAME));
        RecognitionIO.saveTreeBin(def.getDatabase(), new File(dir, DATABASE_NAME));
        UtilIO.saveListStringYaml(def.getImageIds(), new File(dir, IMAGE_ID_NAME));
    }

    public static <TD extends TupleDesc<TD>> void loadNister2006(File dir, FeatureSceneRecognitionNister2006<TD> recognizer) {
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory doesn't exist: " + dir.getPath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Path is not a directory: " + dir.getPath());
        }
        RecognitionIO.loadTreeBin(new File(dir, DATABASE_NAME), recognizer.getDatabase());
        recognizer.getImageIds().addAll(UtilIO.loadListStringYaml(new File(dir, IMAGE_ID_NAME)));
        recognizer.setDatabase(recognizer.getDatabase());
    }

    public static <TD extends TupleDesc<TD>> void saveBin(HierarchicalVocabularyTree<TD> tree, File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            RecognitionIO.saveTreeBin(tree, out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <TD extends TupleDesc<TD>> HierarchicalVocabularyTree<TD> loadTreeBin(File file, @Nullable HierarchicalVocabularyTree<TD> tree) {
        HierarchicalVocabularyTree<TD> hierarchicalVocabularyTree;
        FileInputStream in = new FileInputStream(file);
        try {
            hierarchicalVocabularyTree = RecognitionIO.loadTreeBin(in, tree);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        in.close();
        return hierarchicalVocabularyTree;
    }

    public static <TD extends TupleDesc<TD>> void saveDictionaryBin(List<TD> dictionary, int dof, Class<TD> descType, File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            RecognitionIO.saveDictionaryBin(dictionary, dof, descType, out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <TD extends TupleDesc<TD>> List<TD> loadDictionaryBin(File file) {
        List<TD> list;
        FileInputStream in = new FileInputStream(file);
        try {
            list = RecognitionIO.loadDictionaryBin(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        in.close();
        return list;
    }

    public static void saveNearestNeighborBin(RecognitionNearestNeighborInvertedFile<?> nn, File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            RecognitionIO.saveNearestNeighborBin(nn, out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void loadNearestNeighborBin(File file, RecognitionNearestNeighborInvertedFile<?> nn) {
        try (FileInputStream in = new FileInputStream(file);){
            RecognitionIO.loadNearestNeighborBin(in, nn);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <TD extends TupleDesc<TD>> void saveTreeBin(HierarchicalVocabularyTree<TD> tree, OutputStream out) {
        Object header = "BOOFCV_HIERARCHICAL_VOCABULARY_TREE\n";
        header = (String)header + "# Graph format: id=int,parent=int,branch=int,descIdx=int,dataIdx=int,weight=double,children.size=int,children=int[]\n";
        header = (String)header + "# Description format: raw array used internally\n";
        header = (String)header + "format_version 1\n";
        header = (String)header + "boofcv_version 0.43.1\n";
        header = (String)header + "git_sha 5cbb5bba6343438935aab32240c9bad261f72024\n";
        header = (String)header + "branch_factor " + tree.branchFactor + "\n";
        header = (String)header + "maximum_level " + tree.maximumLevel + "\n";
        header = (String)header + "nodes.size " + tree.nodes.size + "\n";
        header = (String)header + "descriptions.size " + tree.descriptions.size() + "\n";
        header = (String)header + "point_type " + tree.descriptions.getElementType().getSimpleName() + "\n";
        header = (String)header + "point_dof " + ((TupleDesc)tree.descriptions.getTemp(0)).size() + "\n";
        header = (String)header + "distance.name " + tree.distanceFunction.getClass().getName() + "\n";
        header = (String)header + "BEGIN_GRAPH\n";
        try {
            int nodeIdx;
            out.write(((String)header).getBytes(StandardCharsets.UTF_8));
            DataOutputStream dout = new DataOutputStream(out);
            for (nodeIdx = 0; nodeIdx < tree.nodes.size; ++nodeIdx) {
                HierarchicalVocabularyTree.Node n = (HierarchicalVocabularyTree.Node)tree.nodes.get(nodeIdx);
                dout.writeInt(n.index);
                dout.writeInt(n.parent);
                dout.writeInt(n.branch);
                dout.writeInt(n.descIdx);
                dout.writeInt(n.userIdx);
                dout.writeDouble(n.weight);
                dout.writeInt(n.childrenIndexes.size);
                for (int i = 0; i < n.childrenIndexes.size; ++i) {
                    dout.writeInt(n.childrenIndexes.get(i));
                }
            }
            dout.writeUTF("BEGIN_DESCRIPTIONS");
            for (nodeIdx = 0; nodeIdx < tree.descriptions.size(); ++nodeIdx) {
                RecognitionIO.writeBin((TupleDesc)tree.descriptions.getTemp(nodeIdx), dout);
            }
            dout.writeUTF("END_BOOFCV_HIERARCHICAL_VOCABULARY_TREE");
            dout.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <TD extends TupleDesc<TD>> HierarchicalVocabularyTree<TD> loadTreeBin(InputStream in, @Nullable HierarchicalVocabularyTree<TD> tree) {
        StringBuilder builder = new StringBuilder();
        try {
            TupleDesc_F64 tuple;
            PackedTupleBigArray_F64 descriptions;
            TuplePointDistanceEuclideanSq.F64 distanceFunction;
            String line = UtilIO.readLine(in, builder);
            if (!line.equals("BOOFCV_HIERARCHICAL_VOCABULARY_TREE")) {
                throw new IOException("Unexpected first line. line.length=" + line.length());
            }
            String pointType = "";
            String distanceClass = "";
            int dof = 0;
            int numDescriptions = 0;
            int branchFactor = 0;
            int maximumLevel = 0;
            int nodesSize = 0;
            while (!(line = UtilIO.readLine(in, builder)).equals("BEGIN_GRAPH")) {
                if (line.startsWith("#")) continue;
                String[] words = line.split("\\s");
                if (words[0].equals("branch_factor")) {
                    branchFactor = Integer.parseInt(words[1]);
                    continue;
                }
                if (words[0].equals("maximum_level")) {
                    maximumLevel = Integer.parseInt(words[1]);
                    continue;
                }
                if (words[0].equals("nodes.size")) {
                    nodesSize = Integer.parseInt(words[1]);
                    continue;
                }
                if (words[0].equals("descriptions.size")) {
                    numDescriptions = Integer.parseInt(words[1]);
                    continue;
                }
                if (words[0].equals("point_type")) {
                    pointType = words[1];
                    continue;
                }
                if (words[0].equals("point_dof")) {
                    dof = Integer.parseInt(words[1]);
                    continue;
                }
                if (!words[0].equals("distance.name")) continue;
                distanceClass = words[1];
            }
            switch (pointType) {
                case "TupleDesc_F64": {
                    distanceFunction = new TuplePointDistanceEuclideanSq.F64();
                    descriptions = new PackedTupleBigArray_F64(dof);
                    tuple = new TupleDesc_F64(dof);
                    break;
                }
                case "TupleDesc_F32": {
                    distanceFunction = new TuplePointDistanceEuclideanSq.F32();
                    descriptions = new PackedTupleBigArray_F32(dof);
                    tuple = new TupleDesc_F32(dof);
                    break;
                }
                case "TupleDesc_U8": {
                    distanceFunction = new TuplePointDistanceEuclideanSq.U8();
                    descriptions = new PackedTupleBigArray_U8(dof);
                    tuple = new TupleDesc_U8(dof);
                    break;
                }
                case "TupleDesc_S8": {
                    distanceFunction = new TuplePointDistanceEuclideanSq.S8();
                    descriptions = new PackedTupleBigArray_U8(dof);
                    tuple = new TupleDesc_S8(dof);
                    break;
                }
                case "TupleDesc_B": {
                    distanceFunction = new TuplePointDistanceHamming();
                    descriptions = new PackedTupleBigArray_B(dof);
                    tuple = new TupleDesc_B(dof);
                    break;
                }
                default: {
                    throw new IOException("Unknown point type. " + pointType);
                }
            }
            if (tree == null) {
                tree = new HierarchicalVocabularyTree((PointDistance)distanceFunction, (PackedArray)descriptions);
            } else {
                tree.distanceFunction = distanceFunction;
            }
            if (!tree.distanceFunction.getClass().getName().equals(distanceClass)) {
                throw new IOException("Distance functions do not match: Expected=" + distanceClass);
            }
            tree.branchFactor = branchFactor;
            tree.maximumLevel = maximumLevel;
            tree.nodes.resize(nodesSize);
            DataInputStream input = new DataInputStream(in);
            for (int nodeIdx = 0; nodeIdx < tree.nodes.size; ++nodeIdx) {
                HierarchicalVocabularyTree.Node n = (HierarchicalVocabularyTree.Node)tree.nodes.get(nodeIdx);
                n.index = input.readInt();
                n.parent = input.readInt();
                n.branch = input.readInt();
                n.descIdx = input.readInt();
                n.userIdx = input.readInt();
                n.weight = input.readDouble();
                n.childrenIndexes.resize(input.readInt());
                for (int i = 0; i < n.childrenIndexes.size; ++i) {
                    n.childrenIndexes.data[i] = input.readInt();
                }
            }
            RecognitionIO.readCheckUTF(input, "BEGIN_DESCRIPTIONS");
            for (int i = 0; i < numDescriptions; ++i) {
                RecognitionIO.readBin(tuple, input);
                tree.descriptions.append((Object)tuple);
            }
            RecognitionIO.readCheckUTF(input, "END_BOOFCV_HIERARCHICAL_VOCABULARY_TREE");
            return tree;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <TD extends TupleDesc<TD>> void saveDictionaryBin(List<TD> dictionary, int dof, Class<TD> descType, OutputStream out) {
        Object header = "BOOFCV_TUPLE_DICTIONARY\n";
        header = (String)header + "# tuple format: raw array used internally\n";
        header = (String)header + "format_version 1\n";
        header = (String)header + "boofcv_version 0.43.1\n";
        header = (String)header + "git_sha 5cbb5bba6343438935aab32240c9bad261f72024\n";
        header = (String)header + "point_type " + descType.getSimpleName() + "\n";
        header = (String)header + "point_dof " + dof + "\n";
        header = (String)header + "size " + dictionary.size() + "\n";
        header = (String)header + "BEGIN_DICTIONARY\n";
        try {
            out.write(((String)header).getBytes(StandardCharsets.UTF_8));
            DataOutputStream dout = new DataOutputStream(out);
            for (int wordIdx = 0; wordIdx < dictionary.size(); ++wordIdx) {
                RecognitionIO.writeBin((TupleDesc)dictionary.get(wordIdx), dout);
            }
            dout.writeUTF("END_BOOFCV_TUPLE_DICTIONARY");
            dout.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <TD extends TupleDesc<TD>> List<TD> loadDictionaryBin(InputStream in) {
        ArrayList<TupleDesc> dictionary = new ArrayList<TupleDesc>();
        StringBuilder builder = new StringBuilder();
        try {
            TupleDesc_F64 tuple;
            String line = UtilIO.readLine(in, builder);
            if (!line.equals("BOOFCV_TUPLE_DICTIONARY")) {
                throw new IOException("Unexpected first line. line.length=" + line.length());
            }
            String pointType = "";
            int dof = 0;
            int size = 0;
            while (!(line = UtilIO.readLine(in, builder)).equals("BEGIN_DICTIONARY")) {
                if (line.startsWith("#")) continue;
                String[] words = line.split("\\s");
                if (words[0].equals("point_type")) {
                    pointType = words[1];
                    continue;
                }
                if (words[0].equals("point_dof")) {
                    dof = Integer.parseInt(words[1]);
                    continue;
                }
                if (!words[0].equals("size")) continue;
                size = Integer.parseInt(words[1]);
            }
            switch (pointType) {
                case "TupleDesc_F64": {
                    tuple = new TupleDesc_F64(dof);
                    break;
                }
                case "TupleDesc_F32": {
                    tuple = new TupleDesc_F32(dof);
                    break;
                }
                case "TupleDesc_U8": {
                    tuple = new TupleDesc_U8(dof);
                    break;
                }
                case "TupleDesc_S8": {
                    tuple = new TupleDesc_S8(dof);
                    break;
                }
                case "TupleDesc_B": {
                    tuple = new TupleDesc_B(dof);
                    break;
                }
                default: {
                    throw new IOException("Unknown point type. " + pointType);
                }
            }
            DataInputStream input = new DataInputStream(in);
            for (int i = 0; i < size; ++i) {
                RecognitionIO.readBin(tuple, input);
                dictionary.add(tuple.copy());
            }
            RecognitionIO.readCheckUTF(input, "END_BOOFCV_TUPLE_DICTIONARY");
            return dictionary;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveNearestNeighborBin(RecognitionNearestNeighborInvertedFile<?> nn, OutputStream out) {
        DogArray inverted = nn.getInvertedFiles();
        BigDogArray_I32 imageDB = nn.getImagesDB();
        Object header = "BOOFCV_RECOGNITION_NEAREST_NEIGHBOR\n";
        header = (String)header + "# inverted files: (int=size), array [int=index, float=weights]\n";
        header = (String)header + "format_version 1\n";
        header = (String)header + "boofcv_version 0.43.1\n";
        header = (String)header + "git_sha 5cbb5bba6343438935aab32240c9bad261f72024\n";
        header = (String)header + "images.size " + imageDB.size + "\n";
        header = (String)header + "inverted.size " + inverted.size() + "\n";
        header = (String)header + "BEGIN_INVERTED\n";
        try {
            out.write(((String)header).getBytes(StandardCharsets.UTF_8));
            DataOutputStream dout = new DataOutputStream(out);
            for (int invertedIdx = 0; invertedIdx < inverted.size(); ++invertedIdx) {
                InvertedFile inv = (InvertedFile)inverted.get(invertedIdx);
                dout.writeInt(inv.size);
                for (int imageIdx = 0; imageIdx < inv.size; ++imageIdx) {
                    dout.writeInt(inv.get(imageIdx));
                    dout.writeFloat(inv.weights.get(imageIdx));
                }
            }
            dout.writeUTF("BEGIN_IMAGES");
            imageDB.forEach(0, imageDB.size, index -> {
                try {
                    dout.writeInt(index);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            dout.writeUTF("END_BOOFCV_RECOGNITION_NEAREST_NEIGHBOR");
            dout.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void loadNearestNeighborBin(InputStream in, RecognitionNearestNeighborInvertedFile<?> nn) {
        DogArray inverted = nn.getInvertedFiles();
        BigDogArray_I32 imageDB = nn.getImagesDB();
        inverted.reset();
        imageDB.reset();
        StringBuilder builder = new StringBuilder();
        try {
            String line = UtilIO.readLine(in, builder);
            if (!line.equals("BOOFCV_RECOGNITION_NEAREST_NEIGHBOR")) {
                throw new IOException("Unexpected first line. line.length=" + line.length());
            }
            int invertedCount = 0;
            int imageCount = 0;
            while (!(line = UtilIO.readLine(in, builder)).startsWith("BEGIN_INVERTED")) {
                if (line.startsWith("#")) continue;
                String[] words = line.split("\\s");
                if (words[0].equals("inverted.size")) {
                    invertedCount = Integer.parseInt(words[1]);
                    continue;
                }
                if (!words[0].equals("images.size")) continue;
                imageCount = Integer.parseInt(words[1]);
            }
            DataInputStream input = new DataInputStream(in);
            for (int invertedIdx = 0; invertedIdx < invertedCount; ++invertedIdx) {
                InvertedFile inv = (InvertedFile)inverted.grow();
                int fileCount = input.readInt();
                for (int imageIdx = 0; imageIdx < fileCount; ++imageIdx) {
                    int index = input.readInt();
                    float weight = input.readFloat();
                    inv.addImage(index, weight);
                }
            }
            RecognitionIO.readCheckUTF(input, "BEGIN_IMAGES");
            for (int imageIdx = 0; imageIdx < imageCount; ++imageIdx) {
                imageDB.add(input.readInt());
            }
            RecognitionIO.readCheckUTF(input, "END_BOOFCV_RECOGNITION_NEAREST_NEIGHBOR");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <TD extends TupleDesc<TD>> void writeBin(TD tuple, DataOutputStream dout) throws IOException {
        if (tuple instanceof TupleDesc_F64) {
            TupleDesc_F64 desc = (TupleDesc_F64)tuple;
            for (int i = 0; i < desc.size(); ++i) {
                dout.writeDouble(desc.data[i]);
            }
        } else if (tuple instanceof TupleDesc_F32) {
            TupleDesc_F32 desc = (TupleDesc_F32)tuple;
            for (int i = 0; i < desc.size(); ++i) {
                dout.writeFloat(desc.data[i]);
            }
        } else if (tuple instanceof TupleDesc_I8) {
            TupleDesc_I8 desc = (TupleDesc_I8)tuple;
            dout.write(desc.data, 0, desc.size());
        } else if (tuple instanceof TupleDesc_B) {
            TupleDesc_B desc = (TupleDesc_B)tuple;
            for (int i = 0; i < desc.data.length; ++i) {
                dout.writeInt(desc.data[i]);
            }
        } else {
            throw new IllegalArgumentException("Unknown type " + tuple.getClass().getSimpleName());
        }
    }

    public static <TD extends TupleDesc<TD>> void readBin(TD tuple, DataInputStream in) throws IOException {
        if (tuple instanceof TupleDesc_F64) {
            TupleDesc_F64 desc = (TupleDesc_F64)tuple;
            for (int i = 0; i < desc.size(); ++i) {
                desc.data[i] = in.readDouble();
            }
        } else if (tuple instanceof TupleDesc_F32) {
            TupleDesc_F32 desc = (TupleDesc_F32)tuple;
            for (int i = 0; i < desc.size(); ++i) {
                desc.data[i] = in.readFloat();
            }
        } else if (tuple instanceof TupleDesc_I8) {
            TupleDesc_I8 desc = (TupleDesc_I8)tuple;
            BoofMiscOps.checkEq((int)desc.data.length, (int)in.read(desc.data, 0, desc.data.length));
        } else if (tuple instanceof TupleDesc_B) {
            TupleDesc_B desc = (TupleDesc_B)tuple;
            for (int i = 0; i < desc.data.length; ++i) {
                desc.data[i] = in.readInt();
            }
        } else {
            throw new IllegalArgumentException("Unknown type " + tuple.getClass().getSimpleName());
        }
    }

    public static <TD extends TupleDesc<TD>> void saveTreeBin(RecognitionVocabularyTreeNister2006<TD> db, File file) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 0x100000);
            RecognitionIO.saveBin(db, out);
            out.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <TD extends TupleDesc<TD>> void loadTreeBin(File file, RecognitionVocabularyTreeNister2006<TD> db) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), 0x100000);
            RecognitionIO.loadBin(in, db);
            in.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <TD extends TupleDesc<TD>> void saveBin(RecognitionVocabularyTreeNister2006<TD> db, OutputStream out) {
        HierarchicalVocabularyTree tree = db.getTree();
        Objects.requireNonNull(tree, "Tree must be specified before it can be saved");
        Object header = "BOOFCV_RECOGNITION_NISTER_2006\n";
        header = (String)header + "# Image DB: id=int,descTermFreq.size=int,array[key=int,value=float]\n";
        header = (String)header + "# Leaf Info: images.size=int,images.data=array[int]\n";
        header = (String)header + "format_version 1\n";
        header = (String)header + "boofcv_version 0.43.1\n";
        header = (String)header + "git_sha 5cbb5bba6343438935aab32240c9bad261f72024\n";
        header = (String)header + "images_db.size " + db.getImagesDB().size + "\n";
        header = (String)header + "BEGIN_TREE\n";
        try {
            out.write(((String)header).getBytes(StandardCharsets.UTF_8));
            RecognitionIO.saveTreeBin(tree, out);
            DataOutputStream dout = new DataOutputStream(out);
            dout.writeUTF("BEGIN_IMAGE_DB");
            BigDogArray_I32 imageDB = db.getImagesDB();
            for (int dbIdx = 0; dbIdx < imageDB.size; ++dbIdx) {
                dout.writeInt(imageDB.get(dbIdx));
            }
            dout.writeUTF("BEGIN_INVERTED_FILES");
            BoofMiscOps.checkEq((int)db.invertedFiles.size(), (int)tree.nodes.size);
            for (int nodeIdx = 0; nodeIdx < db.invertedFiles.size(); ++nodeIdx) {
                int i;
                InvertedFile node = (InvertedFile)db.invertedFiles.get(nodeIdx);
                BoofMiscOps.checkEq((int)node.size, (int)node.weights.size);
                dout.writeInt(node.size());
                for (i = 0; i < node.size; ++i) {
                    dout.writeInt(node.get(i));
                }
                for (i = 0; i < node.weights.size; ++i) {
                    dout.writeFloat(node.weights.get(i));
                }
            }
            dout.writeUTF("END BOOFCV_RECOGNITION_NISTER_2006");
            dout.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <TD extends TupleDesc<TD>> void loadBin(InputStream in, RecognitionVocabularyTreeNister2006<TD> db) {
        StringBuilder builder = new StringBuilder();
        try {
            String line = UtilIO.readLine(in, builder);
            if (!line.equals("BOOFCV_RECOGNITION_NISTER_2006")) {
                throw new IOException("Unexpected first line. line.length=" + line.length());
            }
            BigDogArray_I32 imagesDB = db.getImagesDB();
            while (!(line = UtilIO.readLine(in, builder)).startsWith("BEGIN_TREE")) {
                String[] words;
                if (line.startsWith("#") || !(words = line.split("\\s"))[0].equals("images_db.size")) continue;
                imagesDB.resize(Integer.parseInt(words[1]));
            }
            db.tree = RecognitionIO.loadTreeBin(in, null);
            DataInputStream input = new DataInputStream(in);
            RecognitionIO.readCheckUTF(input, "BEGIN_IMAGE_DB");
            for (int i = 0; i < imagesDB.size; ++i) {
                imagesDB.set(i, input.readInt());
            }
            RecognitionIO.readCheckUTF(input, "BEGIN_INVERTED_FILES");
            db.invertedFiles.reset();
            db.invertedFiles.resize(db.tree.nodes.size());
            for (int nodeIdx = 0; nodeIdx < db.invertedFiles.size(); ++nodeIdx) {
                int i;
                InvertedFile node = (InvertedFile)db.invertedFiles.get(nodeIdx);
                int N = input.readInt();
                node.resize(N);
                node.weights.resize(N);
                for (i = 0; i < N; ++i) {
                    node.set(i, input.readInt());
                }
                for (i = 0; i < N; ++i) {
                    node.weights.set(i, input.readFloat());
                }
            }
            RecognitionIO.readCheckUTF(input, "END BOOFCV_RECOGNITION_NISTER_2006");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void readCheckUTF(DataInputStream input, String expected) throws IOException {
        String line = input.readUTF();
        if (!line.equals(expected)) {
            throw new IOException("Expected '" + expected + "' not '" + line + "'");
        }
    }
}

