/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points;

import boofcv.alg.cloud.AccessColorIndex;
import boofcv.alg.cloud.AccessPointIndex;
import boofcv.alg.cloud.PointCloudReader;
import boofcv.alg.cloud.PointCloudWriter;
import boofcv.io.points.StlDataStructure;
import boofcv.io.points.impl.ObjFileCodec;
import boofcv.io.points.impl.PlyCodec;
import boofcv.io.points.impl.StlFileReader;
import boofcv.io.points.impl.StlFileWriter;
import boofcv.struct.Point3dRgbI_F64;
import boofcv.struct.mesh.VertexMesh;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class PointCloudIO {
    public static void save3D(Format format, PointCloudReader cloud, boolean saveRGB, OutputStream outputStream) throws IOException {
        switch (format) {
            case PLY: {
                PlyCodec.saveCloudBinary(cloud, ByteOrder.BIG_ENDIAN, saveRGB, false, outputStream);
                break;
            }
            case OBJ: {
                ObjFileCodec.save(cloud, (Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                break;
            }
            case STL: {
                throw new IllegalArgumentException("STL doesn't support point clouds");
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + format);
            }
        }
    }

    public static void save3D(Format format, VertexMesh mesh, @Nullable DogArray_I32 colorRGB, OutputStream outputStream) throws IOException {
        switch (format) {
            case PLY: {
                PlyCodec.saveMeshBinary(mesh, colorRGB, ByteOrder.BIG_ENDIAN, false, outputStream);
                break;
            }
            case OBJ: {
                ObjFileCodec.save(mesh, (Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                break;
            }
            case STL: {
                new StlFileWriter().writeBinary(mesh.toAccess(), "MeshBoofCV", outputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + format);
            }
        }
    }

    public static void save3D(Format format, final AccessPointIndex<Point3D_F64> accessPoint, final AccessColorIndex accessColor, final int size, boolean saveRGB, OutputStream outputStream) throws IOException {
        PointCloudReader reader = new PointCloudReader(){
            final Point3D_F64 tmp = new Point3D_F64();

            public void get(int index, Point3D_F32 point) {
                accessPoint.getPoint(index, (Object)this.tmp);
                point.setTo((float)this.tmp.x, (float)this.tmp.y, (float)this.tmp.z);
            }

            public int size() {
                return size;
            }

            public void get(int index, Point3D_F64 point) {
                accessPoint.getPoint(index, (Object)point);
            }

            public int getRGB(int index) {
                return accessColor.getRGB(index);
            }
        };
        PointCloudIO.save3D(format, reader, saveRGB, outputStream);
    }

    public static DogArray<Point3D_F32> load3D32F(Format format, InputStream input, @Nullable DogArray<Point3D_F32> storage) throws IOException {
        if (storage == null) {
            storage = new DogArray(Point3D_F32::new);
        }
        PointCloudWriter output = PointCloudWriter.wrapF32(storage);
        PointCloudIO.load(format, input, output);
        return storage;
    }

    public static DogArray<Point3D_F64> load3D64F(Format format, InputStream input, @Nullable DogArray<Point3D_F64> storage) throws IOException {
        if (storage == null) {
            storage = new DogArray(Point3D_F64::new);
        }
        PointCloudWriter output = PointCloudWriter.wrapF64(storage);
        PointCloudIO.load(format, input, output);
        return storage;
    }

    public static DogArray<Point3dRgbI_F64> load3DRgb64F(Format format, InputStream input, @Nullable DogArray<Point3dRgbI_F64> storage) throws IOException {
        if (storage == null) {
            storage = new DogArray(Point3dRgbI_F64::new);
        }
        PointCloudWriter output = PointCloudWriter.wrapF64RGB(storage);
        PointCloudIO.load(format, input, output);
        return storage;
    }

    public static void load(Format format, InputStream input, PointCloudWriter output) throws IOException {
        switch (format) {
            case PLY: {
                PlyCodec.readCloud(input, output);
                break;
            }
            case OBJ: {
                ObjFileCodec.load(input, output);
                break;
            }
            default: {
                throw new RuntimeException("Unknown format");
            }
        }
    }

    public static void load(Format format, InputStream input, VertexMesh mesh, DogArray_I32 vertexRgb) throws IOException {
        switch (format) {
            case PLY: {
                PlyCodec.readMesh(input, mesh, vertexRgb);
                break;
            }
            case OBJ: {
                ObjFileCodec.load(input, mesh);
                break;
            }
            case STL: {
                StlDataStructure stlMesh = new StlDataStructure();
                new StlFileReader().readBinary(input, stlMesh);
                stlMesh.toMesh(mesh);
                break;
            }
            default: {
                throw new RuntimeException("Unknown format");
            }
        }
    }

    public static void load(Format format, InputStream input, final FunctionalWriter output) throws IOException {
        PointCloudWriter pcw = new PointCloudWriter(){

            public void initialize(int size, boolean hasColor) {
            }

            public void add(double x, double y, double z, int rgb) {
                output.add(x, y, z, rgb);
            }
        };
        PointCloudIO.load(format, input, pcw);
    }

    public static enum Format {
        PLY,
        OBJ,
        STL;

    }

    @FunctionalInterface
    public static interface FunctionalWriter {
        public void add(double var1, double var3, double var5, int var7);
    }
}

