/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import java.io.IOException;
import java.io.Writer;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class ObjFileWriter {
    public String formatFloat = "%.8f";
    Writer writer;
    int vertexCount = 0;
    int lastObjectVertexCount;

    public ObjFileWriter(Writer writer) {
        this.writer = writer;
    }

    public void addComment(String comment) throws IOException {
        this.writer.write("# " + comment + "\n");
    }

    public void addVertex(double x, double y, double z) throws IOException {
        this.writer.write(118);
        this.writer.write(String.format(" " + this.formatFloat, x));
        this.writer.write(String.format(" " + this.formatFloat, y));
        this.writer.write(String.format(" " + this.formatFloat + "\n", z));
        ++this.vertexCount;
    }

    public void addVertex(double x, double y, double z, double r, double g, double b) throws IOException {
        this.writer.write(118);
        this.writer.write(String.format(" " + this.formatFloat, x));
        this.writer.write(String.format(" " + this.formatFloat, y));
        this.writer.write(String.format(" " + this.formatFloat, z));
        this.writer.write(String.format(" " + this.formatFloat, r));
        this.writer.write(String.format(" " + this.formatFloat, g));
        this.writer.write(String.format(" " + this.formatFloat + "\n", b));
        ++this.vertexCount;
    }

    public void addTextureVertex(double x, double y) throws IOException {
        this.writer.write("vt");
        this.writer.write(String.format(" " + this.formatFloat, x));
        this.writer.write(String.format(" " + this.formatFloat + "\n", y));
    }

    public void addVertexNormal(double dx, double dy, double dz) throws IOException {
        this.writer.write("vn");
        this.writer.write(String.format(" " + this.formatFloat, dx));
        this.writer.write(String.format(" " + this.formatFloat, dy));
        this.writer.write(String.format(" " + this.formatFloat + "\n", dz));
        ++this.vertexCount;
    }

    public void addMaterial(String name) throws IOException {
        this.writer.write("usemtl " + name + "\n");
    }

    public void addLibrary(String name) throws IOException {
        this.writer.write("mtllib " + name + "\n");
    }

    public void addGroup(String name) throws IOException {
        this.writer.write("g " + name + "\n");
    }

    public void addPoint(int vertex) throws IOException {
        this.writer.write("p " + vertex + "\n");
    }

    public void addLine(@Nullable DogArray_I32 vertexes) throws IOException {
        this.writeObject('l', vertexes, 1);
    }

    public void addFace(@Nullable DogArray_I32 vertexes, int count) throws IOException {
        this.writeObject('f', vertexes, count);
    }

    private void writeObject(char name, @Nullable DogArray_I32 vertexes, int count) throws IOException {
        this.writer.write(name);
        if (vertexes == null || vertexes.size == 0) {
            int v = -1;
            int i = this.lastObjectVertexCount;
            while (i < this.vertexCount) {
                this.writer.write(" " + v);
                ++i;
                --v;
            }
        } else {
            for (int i = 0; i < vertexes.size; ++i) {
                int vertIndex = vertexes.get(i);
                if (vertIndex >= this.vertexCount) {
                    throw new IllegalArgumentException("Vertex index must be less than len(vertexes)");
                }
                if (vertIndex <= -this.vertexCount) {
                    throw new IllegalArgumentException("Vertex index must be <= -len(vertexes)");
                }
                if (vertIndex >= 0) {
                    ++vertIndex;
                }
                this.writer.write(" " + vertIndex);
                for (int idxCount = 1; idxCount < count; ++idxCount) {
                    this.writer.write("/" + vertIndex);
                }
            }
        }
        this.writer.write(10);
        this.lastObjectVertexCount = this.vertexCount;
    }
}

