/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.calibration;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.io.UtilIO;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraKannalaBrandt;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.calib.MonoPlaneParameters;
import boofcv.struct.calib.MultiCameraCalibParams;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.calib.VisualDepthParameters;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class CalibrationIO {
    public static String MODEL_PINHOLE = "pinhole";
    public static String MODEL_BROWN = "pinhole_radial_tangential";
    public static String MODEL_OMNIDIRECTIONAL_UNIVERSAL = "omnidirectional_universal";
    public static String MODEL_KANNALA_BRANDT = "kannala_brandt";
    public static String MODEL_STEREO = "stereo_camera";
    public static String MODEL_MULT_CAMERA = "mult_camera";
    public static String MODEL_RIGID_BODY = "rigid_body";
    public static String MODEL_VISUAL_DEPTH = "visual_depth";
    public static String MODEL_MONO_PLANE = "monocular_plane";
    public static String VERSION = "version";

    public static <T extends CameraModel> void save(T parameters, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (parameters instanceof CameraPinholeBrown) {
            out.println("# Pinhole camera model with radial and tangential distortion");
            out.println("# (fx,fy) = focal length, (cx,cy) = principle point, (width,height) = image shape");
            out.println("# radial = radial distortion, (t1,t2) = tangential distortion");
            out.println();
            CalibrationIO.putModelBrown((CameraPinholeBrown)parameters, data);
        } else if (parameters instanceof CameraUniversalOmni) {
            out.println("# Omnidirectional camera model with radial and tangential distortion");
            out.println("# C. Mei, and P. Rives. \"Single view point omnidirectional camera calibration from planar grids.\"  ICRA 2007");
            out.println("# (fx,fy) = focal length, (cx,cy) = principle point, (width,height) = image shape");
            out.println("# mirror_offset = offset mirror along z-axis in unit circle");
            out.println("# radial = radial distortion, (t1,t2) = tangential distortion");
            out.println();
            CalibrationIO.putModelUniversalOmni((CameraUniversalOmni)parameters, data);
        } else if (parameters instanceof CameraKannalaBrandt) {
            out.println("# A camera model for pinhole, wide angle, and fisheye cameras.");
            out.println("# Kannala, J., and Brandt, S. S. \"A generic camera model and calibration method for conventional,");
            out.println("# wide-angle, and fish-eye lenses.\" IEEE transactions on pattern analysis and machine intelligence, 2006");
            out.println("# (fx,fy) = focal length, (cx,cy) = principle point, (width,height) = image shape");
            out.println("# Everything else is coefficients for different types of distortion");
            out.println();
            CalibrationIO.putKannalaBrandt((CameraKannalaBrandt)parameters, data);
        } else {
            out.println("# Pinhole camera model");
            out.println("# (fx,fy) = focal length, (cx,cy) = principle point, (width,height) = image shape");
            out.println();
            CalibrationIO.putModelPinhole((CameraPinhole)parameters, data);
        }
        yaml.dump(data, (Writer)out);
        out.flush();
    }

    public static <T extends CameraModel> void save(T parameters, String filePath) {
        try (FileOutputStream stream = new FileOutputStream(filePath);){
            CalibrationIO.save(parameters, (Writer)new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T extends CameraModel> void save(T parameters, File filePath) {
        CalibrationIO.save(parameters, filePath.getPath());
    }

    public static Yaml createYmlObject() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(30145728);
        return new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()), new Representer(dumperOptions), dumperOptions, loaderOptions);
    }

    public static void save(StereoParameters parameters, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_STEREO);
        map.put(VERSION, 0);
        map.put("left", CalibrationIO.putModelBrown(parameters.left, null));
        map.put("right", CalibrationIO.putModelBrown(parameters.right, null));
        map.put("rightToLeft", CalibrationIO.putSe3(parameters.right_to_left));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Intrinsic and extrinsic parameters for a stereo camera pair");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, (Writer)out);
        out.flush();
    }

    public static void save(StereoParameters parameters, String outputPath) {
        try (FileOutputStream stream = new FileOutputStream(outputPath);){
            CalibrationIO.save(parameters, (Writer)new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(MultiCameraCalibParams parameters, Writer outputWriter) {
        ArrayList<Map<String, Object>> intrinsics = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < parameters.intrinsics.size(); ++i) {
            intrinsics.add(CalibrationIO.putModel((CameraModel)parameters.intrinsics.get(i), null));
        }
        ArrayList<Map<String, Object>> extrinsics = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < parameters.camerasToSensor.size(); ++i) {
            extrinsics.add(CalibrationIO.putSe3((Se3_F64)parameters.camerasToSensor.get(i)));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_MULT_CAMERA);
        map.put(VERSION, 0);
        map.put("intrinsics", intrinsics);
        map.put("camerasToSensor", extrinsics);
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Intrinsic and extrinsic parameters for a multi camera system");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, (Writer)out);
        out.flush();
    }

    public static void save(MultiCameraCalibParams parameters, String outputPath) {
        try (FileOutputStream stream = new FileOutputStream(outputPath);){
            CalibrationIO.save(parameters, (Writer)new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(StereoParameters parameters, File filePath) {
        CalibrationIO.save(parameters, filePath.getPath());
    }

    public static void save(Se3_F64 rigidBody, File filePath) {
        CalibrationIO.save(rigidBody, filePath.getPath());
    }

    public static void save(Se3_F64 rigidBody, String outputPath) {
        try (FileOutputStream stream = new FileOutputStream(outputPath);){
            CalibrationIO.save(rigidBody, (Writer)new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(Se3_F64 rigidBody, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_RIGID_BODY);
        map.put(VERSION, 0);
        map.put("parameters", CalibrationIO.putSe3(rigidBody));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Rigid Body transformation");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, (Writer)out);
        out.flush();
    }

    public static void save(VisualDepthParameters parameters, File filePath) {
        CalibrationIO.save(parameters, filePath.getPath());
    }

    public static void save(VisualDepthParameters parameters, String outputPath) {
        try (FileOutputStream stream = new FileOutputStream(outputPath);){
            CalibrationIO.save(parameters, (Writer)new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(VisualDepthParameters parameters, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_VISUAL_DEPTH);
        map.put(VERSION, 0);
        map.put("max_depth", parameters.getMaxDepth());
        map.put("no_depth", parameters.getPixelNoDepth());
        map.put("intrinsic", CalibrationIO.putModelBrown(parameters.getVisualParam(), null));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# RGB Depth Camera Calibration");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, (Writer)out);
        out.flush();
    }

    public static void save(MonoPlaneParameters parameters, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_MONO_PLANE);
        map.put(VERSION, 0);
        map.put("intrinsic", CalibrationIO.putModelBrown(parameters.getIntrinsic(), null));
        map.put("plane_to_camera", CalibrationIO.putSe3(parameters.getPlaneToCamera()));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Monocular Camera with Known Plane Distance");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, (Writer)out);
        out.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T load(@Nullable URL path) {
        if (path == null) {
            throw new RuntimeException("Null path");
        }
        try (InputStream stream = path.openStream();){
            T t = CalibrationIO.load(new InputStreamReader(stream, StandardCharsets.UTF_8));
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T load(File path) {
        URL url = UtilIO.ensureURL(path.getPath());
        if (url == null) {
            throw new RuntimeException("Can't find " + path.getPath());
        }
        return CalibrationIO.load(url);
    }

    public static <T> T load(String path) {
        URL url = UtilIO.ensureURL(path);
        if (url == null) {
            throw new RuntimeException("Can't find " + path);
        }
        return CalibrationIO.load(url);
    }

    public static <T> T load(Reader reader) {
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        try {
            return CalibrationIO.load(data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T load(Map<String, Object> data) throws IOException {
        String model = (String)data.get("model");
        if (model == null) {
            throw new RuntimeException("Missing model parameter");
        }
        if (model.equals(MODEL_PINHOLE)) {
            CameraPinhole parameters = new CameraPinhole();
            CalibrationIO.loadPinhole((Map)BoofMiscOps.getOrThrow(data, (Object)"pinhole"), parameters);
            return (T)parameters;
        }
        if (model.equals(MODEL_BROWN)) {
            List list;
            CameraPinholeBrown parameters = new CameraPinholeBrown();
            CalibrationIO.loadPinhole((Map)Objects.requireNonNull(data.get("pinhole")), (CameraPinhole)parameters);
            Map distortion = (Map)BoofMiscOps.getOrThrow(data, (Object)"radial_tangential");
            if (distortion.containsKey("radial") && (list = (List)distortion.get("radial")) != null) {
                double[] radial = new double[list.size()];
                parameters.radial = radial;
                for (int i = 0; i < list.size(); ++i) {
                    radial[i] = (Double)list.get(i);
                }
            }
            if (distortion.containsKey("t1")) {
                parameters.t1 = (Double)distortion.get("t1");
            }
            if (distortion.containsKey("t2")) {
                parameters.t2 = (Double)distortion.get("t2");
            }
            return (T)parameters;
        }
        if (model.equals(MODEL_OMNIDIRECTIONAL_UNIVERSAL)) {
            List list;
            CameraUniversalOmni parameters = new CameraUniversalOmni(0);
            CalibrationIO.loadPinhole((Map)BoofMiscOps.getOrThrow(data, (Object)"pinhole"), (CameraPinhole)parameters);
            parameters.mirrorOffset = (Double)BoofMiscOps.getOrThrow(data, (Object)"mirror_offset");
            Map distortion = (Map)BoofMiscOps.getOrThrow(data, (Object)"radial_tangential");
            if (distortion.containsKey("radial") && (list = (List)distortion.get("radial")) != null) {
                parameters.radial = new double[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    parameters.radial[i] = (Double)list.get(i);
                }
            }
            if (distortion.containsKey("t1")) {
                parameters.t1 = (Double)distortion.get("t1");
            }
            if (distortion.containsKey("t2")) {
                parameters.t2 = (Double)distortion.get("t2");
            }
            return (T)parameters;
        }
        if (model.equals(MODEL_KANNALA_BRANDT)) {
            CameraKannalaBrandt parameters = new CameraKannalaBrandt();
            CalibrationIO.loadPinhole((Map)BoofMiscOps.getOrThrow(data, (Object)"pinhole"), (CameraPinhole)parameters);
            parameters.fsetSymmetric(CalibrationIO.loadCoefficients(data, "symmetric"));
            parameters.fsetRadial(CalibrationIO.loadCoefficients(data, "radial"));
            parameters.fsetRadialTrig(CalibrationIO.loadCoefficients(data, "radial_trig"));
            parameters.fsetTangent(CalibrationIO.loadCoefficients(data, "tangent"));
            parameters.fsetTangentTrig(CalibrationIO.loadCoefficients(data, "tangent_trig"));
            return (T)parameters;
        }
        if (model.equals(MODEL_STEREO)) {
            StereoParameters parameters = new StereoParameters();
            parameters.left = (CameraPinholeBrown)CalibrationIO.load((Map)BoofMiscOps.getOrThrow(data, (Object)"left"));
            parameters.right = (CameraPinholeBrown)CalibrationIO.load((Map)BoofMiscOps.getOrThrow(data, (Object)"right"));
            parameters.right_to_left = CalibrationIO.loadSe3((Map)BoofMiscOps.getOrThrow(data, (Object)"rightToLeft"), null);
            return (T)parameters;
        }
        if (model.equals(MODEL_MULT_CAMERA)) {
            MultiCameraCalibParams parameters = new MultiCameraCalibParams();
            List listIntrinsics = (List)BoofMiscOps.getOrThrow(data, (Object)"intrinsics");
            for (Object o : listIntrinsics) {
                parameters.intrinsics.add((CameraModel)CalibrationIO.load((Map)o));
            }
            List listExtrinsics = (List)BoofMiscOps.getOrThrow(data, (Object)"camerasToSensor");
            for (Object o : listExtrinsics) {
                parameters.camerasToSensor.add(CalibrationIO.loadSe3((Map)o, null));
            }
            return (T)parameters;
        }
        if (model.equals(MODEL_VISUAL_DEPTH)) {
            VisualDepthParameters parameters = new VisualDepthParameters();
            parameters.maxDepth = (Number)BoofMiscOps.getOrThrow(data, (Object)"max_depth");
            parameters.pixelNoDepth = (Number)BoofMiscOps.getOrThrow(data, (Object)"no_depth");
            parameters.visualParam = (CameraPinholeBrown)CalibrationIO.load((Map)BoofMiscOps.getOrThrow(data, (Object)"intrinsic"));
            return (T)parameters;
        }
        if (model.equals(MODEL_MONO_PLANE)) {
            MonoPlaneParameters parameters = new MonoPlaneParameters();
            parameters.intrinsic = (CameraPinholeBrown)CalibrationIO.load((Map)BoofMiscOps.getOrThrow(data, (Object)"intrinsic"));
            parameters.planeToCamera = CalibrationIO.loadSe3((Map)BoofMiscOps.getOrThrow(data, (Object)"plane_to_camera"), null);
            return (T)parameters;
        }
        if (model.equals(MODEL_RIGID_BODY)) {
            return (T)CalibrationIO.loadSe3((Map)BoofMiscOps.getOrThrow(data, (Object)"parameters"), null);
        }
        throw new RuntimeException("Unknown camera model: " + model);
    }

    public static Map<String, Object> putModel(CameraModel parameters, @Nullable Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (parameters instanceof CameraPinholeBrown) {
            CalibrationIO.putModelBrown((CameraPinholeBrown)parameters, map);
        } else if (parameters instanceof CameraUniversalOmni) {
            CalibrationIO.putModelUniversalOmni((CameraUniversalOmni)parameters, map);
        } else if (parameters instanceof CameraKannalaBrandt) {
            CalibrationIO.putKannalaBrandt((CameraKannalaBrandt)parameters, map);
        } else {
            CalibrationIO.putModelPinhole((CameraPinhole)parameters, map);
        }
        return map;
    }

    public static Map<String, Object> putModelPinhole(CameraPinhole parameters, @Nullable Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("model", MODEL_PINHOLE);
        map.put(VERSION, 0);
        map.put("pinhole", CalibrationIO.putParamsPinhole(parameters));
        return map;
    }

    public static Map<String, Object> putModelBrown(CameraPinholeBrown parameters, @Nullable Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("model", MODEL_BROWN);
        map.put(VERSION, 0);
        map.put("pinhole", CalibrationIO.putParamsPinhole((CameraPinhole)parameters));
        map.put("radial_tangential", CalibrationIO.putParamsRadialTangent(parameters));
        return map;
    }

    public static Map<String, Object> putModelUniversalOmni(CameraUniversalOmni parameters, @Nullable Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("model", MODEL_OMNIDIRECTIONAL_UNIVERSAL);
        map.put(VERSION, 0);
        map.put("pinhole", CalibrationIO.putParamsPinhole((CameraPinhole)parameters));
        map.put("mirror_offset", parameters.mirrorOffset);
        HashMap<String, Object> mapDistort = new HashMap<String, Object>();
        if (parameters.radial != null) {
            mapDistort.put("radial", parameters.radial);
        }
        mapDistort.put("t1", parameters.t1);
        mapDistort.put("t2", parameters.t2);
        map.put("radial_tangential", mapDistort);
        return map;
    }

    public static Map<String, Object> putKannalaBrandt(CameraKannalaBrandt parameters, @Nullable Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("model", MODEL_KANNALA_BRANDT);
        map.put(VERSION, 0);
        map.put("pinhole", CalibrationIO.putParamsPinhole((CameraPinhole)parameters));
        map.put("symmetric", parameters.symmetric);
        map.put("radial", parameters.radial);
        map.put("radial_trig", parameters.radialTrig);
        map.put("tangent", parameters.tangent);
        map.put("tangent_trig", parameters.tangentTrig);
        return map;
    }

    public static Map<String, Object> putParamsPinhole(CameraPinhole parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", parameters.width);
        map.put("height", parameters.height);
        map.put("fx", parameters.fx);
        map.put("fy", parameters.fy);
        map.put("skew", parameters.skew);
        map.put("cx", parameters.cx);
        map.put("cy", parameters.cy);
        return map;
    }

    public static Map<String, Object> putParamsRadialTangent(CameraPinholeBrown parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (parameters.radial != null) {
            map.put("radial", parameters.radial);
        }
        map.put("t1", parameters.t1);
        map.put("t2", parameters.t2);
        return map;
    }

    public static Map<String, Object> putSe3(Se3_F64 transform) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rotation", transform.R.data);
        map.put("x", transform.T.x);
        map.put("y", transform.T.y);
        map.put("z", transform.T.z);
        return map;
    }

    public static void loadPinhole(Map<String, Object> map, CameraPinhole parameters) {
        try {
            parameters.width = (Integer)BoofMiscOps.getOrThrow(map, (Object)"width");
            parameters.height = (Integer)BoofMiscOps.getOrThrow(map, (Object)"height");
            parameters.fx = (Double)BoofMiscOps.getOrThrow(map, (Object)"fx");
            parameters.fy = (Double)BoofMiscOps.getOrThrow(map, (Object)"fy");
            parameters.skew = (Double)BoofMiscOps.getOrThrow(map, (Object)"skew");
            parameters.cx = (Double)BoofMiscOps.getOrThrow(map, (Object)"cx");
            parameters.cy = (Double)BoofMiscOps.getOrThrow(map, (Object)"cy");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static double[] loadCoefficients(Map<String, Object> map, String name) {
        if (!map.containsKey(name)) {
            return new double[0];
        }
        List list = (List)map.get(name);
        double[] coefficients = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            coefficients[i] = (Double)list.get(i);
        }
        return coefficients;
    }

    public static Se3_F64 loadSe3(Map<String, Object> map, @Nullable Se3_F64 transform) {
        if (transform == null) {
            transform = new Se3_F64();
        }
        try {
            List rotation = (List)BoofMiscOps.getOrThrow(map, (Object)"rotation");
            transform.T.x = (Double)BoofMiscOps.getOrThrow(map, (Object)"x");
            transform.T.y = (Double)BoofMiscOps.getOrThrow(map, (Object)"y");
            transform.T.z = (Double)BoofMiscOps.getOrThrow(map, (Object)"z");
            for (int i = 0; i < 9; ++i) {
                transform.R.data[i] = (Double)rotation.get(i);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return transform;
    }

    public static void saveLandmarksCsv(String inputFile, String detector, CalibrationObservation landmarks, File outputFile) {
        try (FileOutputStream stream = new FileOutputStream(outputFile);){
            CalibrationIO.saveLandmarksCsv(inputFile, detector, landmarks, stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void saveLandmarksCsv(String inputFile, String detector, CalibrationObservation landmarks, OutputStream outputStream) {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        out.println("# Landmarks detected on a calibration target");
        out.println("# " + inputFile);
        out.println("# " + detector);
        out.println("# BoofCV Version: 1.1.6");
        out.println("# BoofCV GITSHA: cbb1030256e7dbac9493f05a356a1a6464850c8c");
        out.println("# (landmark id), pixel-x, pixel-y");
        for (int i = 0; i < landmarks.size(); ++i) {
            PointIndex2D_F64 p = landmarks.get(i);
            out.println(p.index + "," + ((Point2D_F64)p.p).x + "," + ((Point2D_F64)p.p).y);
        }
        out.flush();
    }

    public static CalibrationObservation loadLandmarksCsv(InputStream input) {
        CalibrationObservation ret = new CalibrationObservation();
        StringBuilder buffer = new StringBuilder();
        try {
            String line;
            while (!(line = UtilIO.readLine(input, buffer)).isEmpty()) {
                if (line.startsWith("#")) continue;
                String[] words = line.split(",");
                BoofMiscOps.checkEq((int)3, (int)words.length, (String)"Expected 3 words: int, double, double");
                int which = Integer.parseInt(words[0]);
                double x = Double.parseDouble(words[1]);
                double y = Double.parseDouble(words[2]);
                ret.add(which, x, y);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ret;
    }

    public static void saveOpencv(CameraPinholeBrown intrinsics, String path) {
        try (FileOutputStream stream = new FileOutputStream(path);){
            CalibrationIO.saveOpencv(intrinsics, new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void saveOpencv(CameraPinholeBrown intrinsics, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        try {
            Date date = Calendar.getInstance().getTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
            outputWriter.write("%YAML:1.0\n");
            outputWriter.write("calibration_time: \"" + dateFormat.format(date) + "\"\n");
            outputWriter.write("image_width: " + intrinsics.width + "\n");
            outputWriter.write("image_height: " + intrinsics.height + "\n");
            outputWriter.write("flags: 0\n");
            CalibrationIO.writeOpenCVMatrix(outputWriter, "camera_matrix", 3, 3, intrinsics.fx, intrinsics.skew, intrinsics.cx, 0.0, intrinsics.fy, intrinsics.cy, 0.0, 0.0, 1.0);
            double[] distortion = new double[5];
            if (intrinsics.radial != null) {
                if (intrinsics.radial.length > 0) {
                    distortion[0] = intrinsics.radial[0];
                }
                if (intrinsics.radial.length > 1) {
                    distortion[1] = intrinsics.radial[1];
                }
                if (intrinsics.radial.length > 2) {
                    distortion[4] = intrinsics.radial[2];
                }
            }
            distortion[2] = intrinsics.t1;
            distortion[3] = intrinsics.t2;
            CalibrationIO.writeOpenCVMatrix(outputWriter, "distortion_coefficients", 5, 1, distortion);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        out.flush();
    }

    private static void writeOpenCVMatrix(Writer writer, String name, int rows, int cols, double ... data) throws IOException {
        writer.write(name + ": !!opencv-matrix\n");
        writer.write("    rows: " + rows + "\n");
        writer.write("    cols: " + cols + "\n");
        writer.write("    dt: d\n");
        writer.write("    data: [");
        for (int i = 0; i < data.length; ++i) {
            writer.write(" " + data[i]);
            if (i + 1 == data.length) continue;
            writer.write(",");
        }
        writer.write(" ]\n");
    }

    public static CameraPinholeBrown loadOpenCV(String path) {
        URL url = UtilIO.ensureURL(path);
        if (url == null) {
            throw new RuntimeException("Unknown path=" + path);
        }
        return CalibrationIO.loadOpenCV(url);
    }

    public static CameraPinholeBrown loadOpenCV(URL path) {
        CameraPinholeBrown cameraPinholeBrown;
        block8: {
            InputStream stream = path.openStream();
            try {
                cameraPinholeBrown = CalibrationIO.loadOpenCV(new InputStreamReader(stream, StandardCharsets.UTF_8));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return cameraPinholeBrown;
    }

    public static CameraPinholeBrown loadOpenCV(Reader reader) {
        CameraPinholeBrown out = new CameraPinholeBrown();
        try {
            String filtered = IOUtils.toString((Reader)reader);
            filtered = filtered.replace("%YAML:1.0", "");
            filtered = filtered.replace("!!opencv-matrix", "");
            Representer representer = new Representer(new DumperOptions());
            representer.getPropertyUtils().setSkipMissingProperties(true);
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()), representer);
            Map map = (Map)yaml.load(filtered);
            int width = (Integer)BoofMiscOps.getOrThrow((Map)map, (Object)"image_width");
            int height = (Integer)BoofMiscOps.getOrThrow((Map)map, (Object)"image_height");
            DMatrixRMaj K = CalibrationIO.loadOpenCVMatrix((Map)BoofMiscOps.getOrThrow((Map)map, (Object)"camera_matrix"));
            DMatrixRMaj distortion = CalibrationIO.loadOpenCVMatrix((Map)BoofMiscOps.getOrThrow((Map)map, (Object)"distortion_coefficients"));
            PerspectiveOps.matrixToPinhole((DMatrixRMaj)K, (int)width, (int)height, (CameraPinhole)out);
            if (distortion.getNumElements() >= 5) {
                out.setRadial(new double[]{distortion.get(0), distortion.get(1), distortion.get(4)});
            } else if (distortion.getNumElements() >= 2) {
                out.setRadial(new double[]{distortion.get(0), distortion.get(1)});
            }
            if (distortion.getNumElements() >= 5) {
                out.fsetTangential(distortion.get(2), distortion.get(3));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out;
    }

    private static DMatrixRMaj loadOpenCVMatrix(Map<String, Object> map) throws IOException {
        int rows = (Integer)BoofMiscOps.getOrThrow(map, (Object)"rows");
        int cols = (Integer)BoofMiscOps.getOrThrow(map, (Object)"cols");
        DMatrixRMaj mat = new DMatrixRMaj(rows, cols);
        List array = (List)BoofMiscOps.getOrThrow(map, (Object)"data");
        for (int i = 0; i < array.size(); ++i) {
            mat.data[i] = (Double)array.get(i);
        }
        return mat;
    }
}

