/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.fiducial;

import boofcv.io.UtilIO;
import boofcv.io.calibration.CalibrationIO;
import boofcv.io.fiducial.RandomDotDefinition;
import georegression.struct.point.Point2D_F64;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.yaml.snakeyaml.Yaml;

public class FiducialIO {
    public static void saveRandomDotYaml(RandomDotDefinition definition, File file) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            FiducialIO.saveRandomDotYaml(definition, writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void saveRandomDotYaml(RandomDotDefinition definition, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", 1);
        map.put("random_seed", definition.randomSeed);
        if (definition.dotDiameter > 0.0) {
            map.put("dot_diameter", definition.dotDiameter);
        }
        if (definition.maxDotsPerMarker > 0) {
            map.put("num_dots", definition.maxDotsPerMarker);
        }
        if (definition.markerWidth > 0.0) {
            map.put("marker_width", definition.markerWidth);
        }
        if (definition.markerHeight > 0.0) {
            map.put("marker_height", definition.markerHeight);
        }
        if (!definition.units.isEmpty()) {
            map.put("units", definition.units);
        }
        ArrayList listMarkers = new ArrayList();
        for (List<Point2D_F64> marker : definition.markers) {
            ArrayList<double[]> listPoints = new ArrayList<double[]>();
            for (Point2D_F64 p : marker) {
                listPoints.add(new double[]{p.x, p.y});
            }
            listMarkers.add(listPoints);
        }
        map.put("markers", listMarkers);
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Description of printed UCHIYA markers created by BoofCV 1.1.6");
        out.println("# Warning: Individual markers might have less than num_dots points");
        out.println();
        CalibrationIO.createYmlObject().dump(map, (Writer)out);
    }

    public static RandomDotDefinition loadRandomDotYaml(URL url) {
        try {
            InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
            RandomDotDefinition ret = FiducialIO.loadRandomDotYaml(reader);
            reader.close();
            return ret;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static RandomDotDefinition loadRandomDotYaml(File file) {
        URL url = UtilIO.ensureURL(file.getPath());
        if (url == null) {
            throw new RuntimeException("Null url path. file=" + file.getPath());
        }
        return FiducialIO.loadRandomDotYaml(url);
    }

    public static RandomDotDefinition loadRandomDotYaml(Reader reader) {
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        RandomDotDefinition def = new RandomDotDefinition();
        if (data.containsKey("random_seed")) {
            def.randomSeed = ((Number)data.get("random_seed")).longValue();
        }
        if (data.containsKey("dot_diameter")) {
            def.dotDiameter = (Double)data.get("dot_diameter");
        }
        if (data.containsKey("num_dots")) {
            def.maxDotsPerMarker = (Integer)data.get("num_dots");
        }
        if (data.containsKey("marker_width")) {
            def.markerWidth = (Double)data.get("marker_width");
        }
        if (data.containsKey("marker_height")) {
            def.markerHeight = (Double)data.get("marker_height");
        }
        if (data.containsKey("units")) {
            def.units = (String)data.get("units");
        }
        if (def.markerHeight <= 0.0) {
            def.markerHeight = def.markerWidth;
        }
        List listMarkers = (List)Objects.requireNonNull(data.get("markers"));
        for (int markerIdx = 0; markerIdx < listMarkers.size(); ++markerIdx) {
            List listYaml = (List)listMarkers.get(markerIdx);
            ArrayList<Point2D_F64> marker = new ArrayList<Point2D_F64>(listYaml.size());
            for (List coordinates : listYaml) {
                Point2D_F64 p = new Point2D_F64(((Double)coordinates.get(0)).doubleValue(), ((Double)coordinates.get(1)).doubleValue());
                marker.add(p);
            }
            def.markers.add(marker);
        }
        return def;
    }
}

