/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.geo;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.BundleCameraState;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.geo.bundle.cameras.BundleZoomSimplified;
import boofcv.alg.similar.SimilarImagesData;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.io.calibration.CalibrationIO;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.feature.AssociatedIndex;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class MultiViewIO {
    public static void save(LookUpSimilarImages db, String path) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);
            MultiViewIO.save(db, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(LookUpSimilarImages db, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        out.println("# " + db.getClass().getSimpleName() + " in YAML format. BoofCV 1.1.6");
        List imageIds = db.getImageIDs();
        ArrayList imageInfo = new ArrayList();
        DogArray features = new DogArray(Point2D_F64::new);
        DogArray matches = new DogArray(AssociatedIndex::new);
        TObjectIntHashMap viewToIndex = new TObjectIntHashMap();
        for (int i = 0; i < imageIds.size(); ++i) {
            viewToIndex.put((Object)((String)imageIds.get(i)), i);
        }
        for (int viewIndex = 0; viewIndex < imageIds.size(); ++viewIndex) {
            String id = (String)imageIds.get(viewIndex);
            HashMap<String, Object> imageMap = new HashMap<String, Object>();
            db.lookupPixelFeats(id, features);
            double[] pixels = new double[features.size * 2];
            for (int j = 0; j < features.size; ++j) {
                Point2D_F64 p = (Point2D_F64)features.get(j);
                pixels[j * 2] = p.x;
                pixels[j * 2 + 1] = p.y;
            }
            ArrayList similarIds = new ArrayList();
            db.findSimilar(id, s -> true, similarIds);
            ArrayList listRelated = new ArrayList();
            for (int similarIdx = 0; similarIdx < similarIds.size(); ++similarIdx) {
                int similarViewIndex = viewToIndex.get(similarIds.get(similarIdx));
                if (similarViewIndex < viewIndex) continue;
                db.lookupAssociated((String)similarIds.get(similarIdx), matches);
                HashMap<String, Object> relationship = new HashMap<String, Object>();
                int[] matchesIndexes = new int[matches.size * 2];
                for (int j = 0; j < matches.size; ++j) {
                    AssociatedIndex p = (AssociatedIndex)matches.get(j);
                    matchesIndexes[j * 2] = p.src;
                    matchesIndexes[j * 2 + 1] = p.dst;
                }
                relationship.put("id", similarIds.get(similarIdx));
                relationship.put("pairs", matchesIndexes);
                listRelated.add(relationship);
            }
            imageMap.put("features", pixels);
            imageMap.put("similar", listRelated);
            imageInfo.add(imageMap);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("images", imageIds);
        data.put("info", imageInfo);
        data.put("data_type", "SimilarImages");
        data.put("version", 0);
        yaml.dump(data, (Writer)out);
        out.close();
    }

    public static void save(PairwiseImageGraph graph, String path) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);
            MultiViewIO.save(graph, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(PairwiseImageGraph graph, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        out.println("# " + graph.getClass().getSimpleName() + " in YAML format. BoofCV 1.1.6");
        ArrayList motions = new ArrayList();
        for (int motionIdx = 0; motionIdx < graph.edges.size; ++motionIdx) {
            PairwiseImageGraph.Motion pmotion = (PairwiseImageGraph.Motion)graph.edges.get(motionIdx);
            BoofMiscOps.checkEq((int)pmotion.index, (int)motionIdx);
            HashMap<String, Object> element = new HashMap<String, Object>();
            motions.add(element);
            element.put("is_3D", pmotion.is3D);
            element.put("score_3d", pmotion.score3D);
            element.put("src", pmotion.src.id);
            element.put("dst", pmotion.dst.id);
            element.put("inliers", MultiViewIO.encodeInliers((FastAccess<AssociatedIndex>)pmotion.inliers));
        }
        ArrayList views = new ArrayList();
        for (int viewIdx = 0; viewIdx < graph.nodes.size; ++viewIdx) {
            PairwiseImageGraph.View pview = (PairwiseImageGraph.View)graph.nodes.get(viewIdx);
            ArrayList connections = new ArrayList();
            pview.connections.forIdx((i, v) -> connections.add(v.index));
            HashMap<String, Object> element = new HashMap<String, Object>();
            views.add(element);
            element.put("id", pview.id);
            element.put("total_observations", pview.totalObservations);
            element.put("connections", connections);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("motions", motions);
        data.put("views", views);
        data.put("data_type", "PairwiseImageGraph");
        data.put("version", 0);
        yaml.dump(data, (Writer)out);
        out.close();
    }

    public static void save(SceneStructureMetric scene, String path) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);
            MultiViewIO.save(scene, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(SceneStructureMetric scene, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        out.println("# " + scene.getClass().getSimpleName() + " in YAML format. BoofCV 1.1.6");
        ArrayList views = new ArrayList();
        ArrayList motions = new ArrayList();
        ArrayList rigids = new ArrayList();
        ArrayList cameras = new ArrayList();
        ArrayList points = new ArrayList();
        scene.views.forEach(v -> views.add(MultiViewIO.encodeSceneView(scene, v)));
        scene.motions.forEach(m -> motions.add(MultiViewIO.encodeSceneMotion(m)));
        scene.rigids.forEach(r -> rigids.add(MultiViewIO.encodeSceneRigid(r)));
        scene.cameras.forEach(c -> cameras.add(MultiViewIO.encodeSceneCamera(c)));
        scene.points.forEach(p -> points.add(MultiViewIO.encodeScenePoint(p)));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("views", views);
        data.put("motions", motions);
        data.put("rigids", rigids);
        data.put("cameras", cameras);
        data.put("points", points);
        data.put("homogeneous", scene.isHomogeneous());
        data.put("data_type", "SceneStructureMetric");
        data.put("version", 0);
        yaml.dump(data, (Writer)out);
        out.close();
    }

    public static void save(SceneObservations scene, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        out.println("# " + scene.getClass().getSimpleName() + " in YAML format. BoofCV 1.1.6");
        ArrayList views = new ArrayList();
        ArrayList viewsRigid = new ArrayList();
        scene.views.forEach(v -> views.add(MultiViewIO.encodeObservationView(v)));
        scene.viewsRigid.forEach(v -> viewsRigid.add(MultiViewIO.encodeObservationView(v)));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("views", views);
        data.put("views_rigid", viewsRigid);
        data.put("data_type", "SceneObservations");
        data.put("version", 0);
        yaml.dump(data, (Writer)out);
        out.close();
    }

    public static void save(SceneObservations scene, File destination) {
        try (FileWriter writer = new FileWriter(destination);){
            MultiViewIO.save(scene, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Map<String, Object> encodeSceneView(SceneStructureMetric scene, SceneStructureMetric.View v) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("camera", v.camera);
        encoded.put("parent_to_view", v.parent_to_view);
        if (v.parent != null) {
            encoded.put("parent", scene.views.indexOf((Object)v.parent));
        }
        return encoded;
    }

    private static Map<String, Object> encodeSceneMotion(SceneStructureMetric.Motion m) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("known", m.known);
        encoded.put("motion", MultiViewIO.putSE3(m.parent_to_view));
        return encoded;
    }

    private static Map<String, Object> encodeSceneRigid(SceneStructureMetric.Rigid r) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("known", r.known);
        encoded.put("object_to_world", MultiViewIO.putSE3(r.object_to_world));
        encoded.put("indexFirst", r.indexFirst);
        ArrayList<Map<String, Object>> points = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < r.points.length; ++i) {
            points.add(MultiViewIO.encodeScenePoint(r.points[i]));
        }
        encoded.put("points", points);
        return encoded;
    }

    private static Map<String, Object> encodeScenePoint(SceneStructureCommon.Point p) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("coordinate", p.coordinate);
        encoded.put("views", p.views.toArray());
        return encoded;
    }

    private static Map<String, Object> encodeObservationView(SceneObservations.View v) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("point", v.point.toArray());
        encoded.put("observations", v.observations.toArray());
        if (v.cameraState != null) {
            encoded.put("camera_state", MultiViewIO.encodeCameraState(v.cameraState));
        }
        return encoded;
    }

    private static SceneStructureCommon.Point decodeScenePoint(Map<String, Object> map, @Nullable SceneStructureCommon.Point p) throws IOException {
        int i;
        List coordinate = (List)BoofMiscOps.getOrThrow(map, (Object)"coordinate");
        List views = (List)BoofMiscOps.getOrThrow(map, (Object)"views");
        if (p == null) {
            p = new SceneStructureCommon.Point(coordinate.size());
        }
        for (i = 0; i < coordinate.size(); ++i) {
            p.coordinate[i] = (Double)coordinate.get(i);
        }
        p.views.resize(views.size());
        for (i = 0; i < views.size(); ++i) {
            p.views.data[i] = (Integer)views.get(i);
        }
        return p;
    }

    private static List<Map<String, Object>> encodeInliers(FastAccess<AssociatedIndex> inliers) {
        ArrayList<Map<String, Object>> encoded = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < inliers.size; ++i) {
            AssociatedIndex a = (AssociatedIndex)inliers.get(i);
            HashMap<String, Integer> element = new HashMap<String, Integer>();
            element.put("src", a.src);
            element.put("dst", a.dst);
            encoded.add(element);
        }
        return encoded;
    }

    private static Map<String, Object> encodeSceneCamera(SceneStructureCommon.Camera c) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("known", c.known);
        encoded.put("model", c.model.toMap());
        return encoded;
    }

    private static SceneStructureCommon.Camera decodeSceneCamera(Map<String, Object> map, @Nullable SceneStructureCommon.Camera c) throws IOException {
        if (c == null) {
            c = new SceneStructureCommon.Camera();
        }
        c.known = (Boolean)BoofMiscOps.getOrThrow(map, (Object)"known");
        Map model = (Map)BoofMiscOps.getOrThrow(map, (Object)"model");
        Class type = null;
        if (model.containsKey("type")) {
            switch ((String)model.get("type")) {
                case "PinholeSimplified": {
                    type = BundlePinholeSimplified.class;
                    break;
                }
                case "PinholeBrown": {
                    type = BundlePinholeBrown.class;
                    break;
                }
                case "ZoomSimplified": {
                    type = BundleZoomSimplified.class;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown camera. type='" + type + "'");
                }
            }
        }
        try {
            if (type == null) {
                if (!model.containsKey("class-name")) {
                    throw new RuntimeException("Camera type not specified by 'type' or 'class-name'");
                }
                type = Class.forName((String)Objects.requireNonNull(model.get("class-name")));
            }
            c.model = (BundleAdjustmentCamera)type.getConstructor(new Class[0]).newInstance(new Object[0]);
            c.model.setTo(model);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return c;
    }

    private static Map<String, Object> encodeCameraState(BundleCameraState c) {
        Map encoded = c.toMap();
        encoded.put("class-name", c.getClass().getCanonicalName());
        return encoded;
    }

    private static BundleCameraState decodeCameraState(Map<String, Object> encoded) {
        try {
            String className = (String)Objects.requireNonNull(encoded.get("class-name"));
            BundleCameraState c = (BundleCameraState)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            return c.setTo(encoded);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static SceneStructureMetric load(String path, @Nullable SceneStructureMetric graph) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);
            return MultiViewIO.load((Reader)reader, graph);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SceneStructureMetric load(Reader reader, @Nullable SceneStructureMetric scene) {
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        try {
            int i;
            reader.close();
            boolean homogeneous = (Boolean)BoofMiscOps.getOrThrow((Map)data, (Object)"homogeneous");
            List yamlViews = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"views");
            List yamlMotions = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"motions");
            List yamlRigids = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"rigids");
            List yamlCameras = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"cameras");
            List yamlPoints = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"points");
            if (scene != null && scene.isHomogeneous() != homogeneous) {
                scene = null;
            }
            if (scene == null) {
                scene = new SceneStructureMetric(homogeneous);
            }
            scene.initialize(yamlCameras.size(), yamlViews.size(), yamlMotions.size(), yamlPoints.size(), yamlRigids.size());
            for (i = 0; i < yamlViews.size(); ++i) {
                SceneStructureMetric.View v = (SceneStructureMetric.View)scene.views.get(i);
                Map yamlView = (Map)yamlViews.get(i);
                v.camera = (Integer)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"camera");
                v.parent_to_view = (Integer)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"parent_to_view");
                v.parent = yamlView.containsKey("parent") ? (SceneStructureMetric.View)scene.views.get(((Integer)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"parent")).intValue()) : null;
            }
            for (i = 0; i < yamlMotions.size(); ++i) {
                SceneStructureMetric.Motion m = (SceneStructureMetric.Motion)scene.motions.grow();
                Map yamlMotion = (Map)yamlMotions.get(i);
                m.known = (Boolean)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"known");
                MultiViewIO.loadSE3((Map)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"motion"), m.parent_to_view);
            }
            for (i = 0; i < yamlRigids.size(); ++i) {
                SceneStructureMetric.Rigid r = (SceneStructureMetric.Rigid)scene.rigids.get(i);
                Map yamlRigid = (Map)yamlRigids.get(i);
                List points = (List)BoofMiscOps.getOrThrow((Map)yamlRigid, (Object)"points");
                r.init(points.size(), scene.isHomogeneous() ? 4 : 3);
                r.known = (Boolean)BoofMiscOps.getOrThrow((Map)yamlRigid, (Object)"known");
                r.indexFirst = (Integer)BoofMiscOps.getOrThrow((Map)yamlRigid, (Object)"indexFirst");
                MultiViewIO.loadSE3((Map)BoofMiscOps.getOrThrow((Map)yamlRigid, (Object)"object_to_world"), r.object_to_world);
                for (int j = 0; j < r.points.length; ++j) {
                    MultiViewIO.decodeScenePoint((Map)points.get(j), r.points[j]);
                }
            }
            for (i = 0; i < scene.points.size; ++i) {
                MultiViewIO.decodeScenePoint((Map)yamlPoints.get(i), (SceneStructureCommon.Point)scene.points.get(i));
            }
            for (i = 0; i < yamlCameras.size(); ++i) {
                MultiViewIO.decodeSceneCamera((Map)yamlCameras.get(i), (SceneStructureCommon.Camera)scene.cameras.get(i));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return scene;
    }

    public static SceneObservations load(String path, @Nullable SceneObservations graph) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);
            return MultiViewIO.load((Reader)reader, graph);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SceneObservations load(Reader reader, @Nullable SceneObservations observations) {
        if (observations == null) {
            observations = new SceneObservations();
        }
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        try {
            reader.close();
            List yamlViews = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"views");
            List yamlViewsRigid = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"views_rigid");
            observations.initialize(yamlViews.size(), !yamlViewsRigid.isEmpty());
            MultiViewIO.loadObservations((FastAccess<SceneObservations.View>)observations.views, yamlViews);
            MultiViewIO.loadObservations((FastAccess<SceneObservations.View>)observations.viewsRigid, yamlViewsRigid);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return observations;
    }

    private static void loadObservations(FastAccess<SceneObservations.View> views, List<Map<String, Object>> yamlViews) throws IOException {
        for (int viewIdx = 0; viewIdx < yamlViews.size(); ++viewIdx) {
            int i;
            Map<String, Object> yamlView = yamlViews.get(viewIdx);
            List pointValues = (List)BoofMiscOps.getOrThrow(yamlView, (Object)"point");
            List observationValues = (List)BoofMiscOps.getOrThrow(yamlView, (Object)"observations");
            SceneObservations.View v = (SceneObservations.View)views.get(viewIdx);
            v.point.resize(pointValues.size());
            for (i = 0; i < pointValues.size(); ++i) {
                v.point.data[i] = (Integer)pointValues.get(i);
            }
            v.observations.resize(observationValues.size());
            for (i = 0; i < observationValues.size(); ++i) {
                v.observations.data[i] = ((Number)observationValues.get(i)).floatValue();
            }
            if (!yamlView.containsKey("camera_state")) continue;
            v.cameraState = MultiViewIO.decodeCameraState((Map)yamlView.get("camera_state"));
        }
    }

    public static LookUpSimilarImages loadSimilarImages(String path) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);
            return MultiViewIO.loadSimilarImages(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static LookUpSimilarImages loadSimilarImages(Reader reader) {
        Yaml yaml = CalibrationIO.createYmlObject();
        SimilarImagesData ret = new SimilarImagesData();
        DogArray features = new DogArray(Point2D_F64::new);
        Map data = (Map)yaml.load(reader);
        try {
            reader.close();
            List listImages = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"images");
            List yamlInfo = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"info");
            BoofMiscOps.checkEq((int)listImages.size(), (int)yamlInfo.size());
            for (int imageIdx = 0; imageIdx < listImages.size(); ++imageIdx) {
                String id = (String)listImages.get(imageIdx);
                Map yamlImage = (Map)yamlInfo.get(imageIdx);
                List yamlPixels = (List)BoofMiscOps.getOrThrow((Map)yamlImage, (Object)"features");
                features.resize(yamlPixels.size() / 2);
                for (int i = 0; i < yamlPixels.size(); i += 2) {
                    double x = (Double)yamlPixels.get(i);
                    double y = (Double)yamlPixels.get(i + 1);
                    ((Point2D_F64)features.get(i / 2)).setTo(x, y);
                }
                ret.add(id, features.toList());
            }
            DogArray pairs = new DogArray(AssociatedIndex::new);
            for (int imageIdx = 0; imageIdx < listImages.size(); ++imageIdx) {
                String id = (String)listImages.get(imageIdx);
                Map yamlImage = (Map)yamlInfo.get(imageIdx);
                List listSimilar = (List)BoofMiscOps.getOrThrow((Map)yamlImage, (Object)"similar");
                for (int i = 0; i < listSimilar.size(); ++i) {
                    Map yamlSimilar = (Map)listSimilar.get(i);
                    String similarID = (String)BoofMiscOps.getOrThrow((Map)yamlSimilar, (Object)"id");
                    List yamlPairs = (List)BoofMiscOps.getOrThrow((Map)yamlSimilar, (Object)"pairs");
                    pairs.reset().resize(yamlPairs.size() / 2);
                    for (int j = 0; j < pairs.size; ++j) {
                        ((AssociatedIndex)pairs.get(j)).setTo(((Integer)yamlPairs.get(j * 2)).intValue(), ((Integer)yamlPairs.get(j * 2 + 1)).intValue());
                    }
                    ret.setRelationship(id, similarID, pairs.toList());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ret;
    }

    public static PairwiseImageGraph load(String path, @Nullable PairwiseImageGraph graph) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);
            return MultiViewIO.load((Reader)reader, graph);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static PairwiseImageGraph load(Reader reader, @Nullable PairwiseImageGraph graph) {
        if (graph == null) {
            graph = new PairwiseImageGraph();
        } else {
            graph.reset();
        }
        PairwiseImageGraph _graph = graph;
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        try {
            reader.close();
            List yamlViews = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"views");
            List yamlMotions = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"motions");
            graph.nodes.resize(yamlViews.size());
            graph.edges.resize(yamlMotions.size());
            int viewIdx = 0;
            while (viewIdx < yamlViews.size()) {
                Map yamlView = (Map)yamlViews.get(viewIdx);
                PairwiseImageGraph.View v = (PairwiseImageGraph.View)graph.nodes.get(viewIdx);
                v.index = viewIdx++;
                v.id = (String)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"id");
                v.totalObservations = (Integer)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"total_observations");
                List yamlConnections = (List)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"connections");
                v.connections.resize(yamlConnections.size());
                v.connections.reset();
                yamlConnections.forEach(it -> v.connections.add((Object)((PairwiseImageGraph.Motion)_graph.edges.get(it.intValue()))));
                graph.mapNodes.put(v.id, v);
            }
            int i = 0;
            while (i < yamlMotions.size()) {
                Map yamlMotion = (Map)yamlMotions.get(i);
                PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)graph.edges.get(i);
                m.score3D = (Double)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"score_3d");
                m.is3D = (Boolean)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"is_3D");
                m.src = (PairwiseImageGraph.View)BoofMiscOps.getOrThrow((Map)graph.mapNodes, (Object)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"src"));
                m.dst = (PairwiseImageGraph.View)BoofMiscOps.getOrThrow((Map)graph.mapNodes, (Object)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"dst"));
                m.index = i++;
                MultiViewIO.decodeInliers((List)BoofMiscOps.getOrThrow((Map)yamlMotion, (Object)"inliers"), (DogArray<AssociatedIndex>)m.inliers);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return graph;
    }

    private static void copyIntoMatrix(List<Double> arrayData, DMatrixRMaj matrix) {
        BoofMiscOps.checkEq((int)arrayData.size(), (int)matrix.data.length);
        for (int j = 0; j < matrix.data.length; ++j) {
            matrix.data[j] = arrayData.get(j);
        }
    }

    private static void decodeInliers(List<Map<String, Object>> encoded, DogArray<AssociatedIndex> inliers) throws IOException {
        inliers.resize(encoded.size());
        for (int i = 0; i < inliers.size; ++i) {
            Map<String, Object> element = encoded.get(i);
            AssociatedIndex a = (AssociatedIndex)inliers.get(i);
            a.src = (Integer)BoofMiscOps.getOrThrow(element, (Object)"src");
            a.dst = (Integer)BoofMiscOps.getOrThrow(element, (Object)"dst");
        }
    }

    public static void save(SceneWorkingGraph working, String path) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);
            MultiViewIO.save(working, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(SceneWorkingGraph working, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        out.println("# " + working.getClass().getSimpleName() + " in YAML format. BoofCV 1.1.6");
        ArrayList cameras = new ArrayList();
        for (int cameraIdx = 0; cameraIdx < working.listCameras.size(); ++cameraIdx) {
            SceneWorkingGraph.Camera camera = (SceneWorkingGraph.Camera)working.listCameras.get(cameraIdx);
            HashMap<String, Object> element = new HashMap<String, Object>();
            cameras.add(element);
            element.put("index_db", camera.indexDB);
            element.put("prior", CalibrationIO.putModelBrown(camera.prior, null));
            element.put("intrinsic", MultiViewIO.putPinholeSimplified(camera.intrinsic));
        }
        ArrayList views = new ArrayList();
        for (int viewIdx = 0; viewIdx < working.listViews.size(); ++viewIdx) {
            SceneWorkingGraph.View wview = (SceneWorkingGraph.View)working.listViews.get(viewIdx);
            SceneWorkingGraph.Camera camera = working.getViewCamera(wview);
            HashMap<String, Object> element = new HashMap<String, Object>();
            views.add(element);
            element.put("pview", wview.pview.id);
            element.put("projective", wview.projective.data);
            element.put("world_to_view", CalibrationIO.putSe3(wview.world_to_view));
            element.put("camera_index", camera.localIndex);
            element.put("inliers", MultiViewIO.putInlierInfo((FastAccess<SceneWorkingGraph.InlierInfo>)wview.inliers));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cameras", cameras);
        data.put("views", views);
        data.put("data_type", "SceneWorkingGraph");
        data.put("version", 0);
        yaml.dump(data, (Writer)out);
        out.close();
    }

    public static SceneWorkingGraph load(String path, PairwiseImageGraph pairwise, @Nullable SceneWorkingGraph working) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);
            return MultiViewIO.load(reader, pairwise, working);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SceneWorkingGraph load(Reader reader, PairwiseImageGraph pairwise, @Nullable SceneWorkingGraph working) {
        if (working == null) {
            working = new SceneWorkingGraph();
        } else {
            working.reset();
        }
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        try {
            reader.close();
            List yamlCameras = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"cameras");
            for (int cameraIdx = 0; cameraIdx < yamlCameras.size(); ++cameraIdx) {
                Map yamlCamera = (Map)yamlCameras.get(cameraIdx);
                int indexDB = (Integer)BoofMiscOps.getOrThrow((Map)yamlCamera, (Object)"index_db");
                SceneWorkingGraph.Camera camera = working.addCamera(indexDB);
                camera.prior.setTo((CameraPinholeBrown)CalibrationIO.load((Map)BoofMiscOps.getOrThrow((Map)yamlCamera, (Object)"prior")));
                MultiViewIO.loadPinholeSimplified((Map)BoofMiscOps.getOrThrow((Map)yamlCamera, (Object)"intrinsic"), camera.intrinsic);
            }
            List yamlViews = (List)BoofMiscOps.getOrThrow((Map)data, (Object)"views");
            for (Map yamlView : yamlViews) {
                PairwiseImageGraph.View pview = pairwise.lookupNode((String)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"pview"));
                int cameraIdx = (Integer)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"camera_index");
                SceneWorkingGraph.Camera camera = (SceneWorkingGraph.Camera)working.listCameras.get(cameraIdx);
                working.addView(pview, camera);
            }
            for (Map yamlView : yamlViews) {
                SceneWorkingGraph.View wview = working.lookupView((String)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"pview"));
                MultiViewIO.copyIntoMatrix((List)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"projective"), wview.projective);
                CalibrationIO.loadSe3((Map)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"world_to_view"), wview.world_to_view);
                MultiViewIO.loadInlierInfo((List)BoofMiscOps.getOrThrow((Map)yamlView, (Object)"inliers"), pairwise, (DogArray<SceneWorkingGraph.InlierInfo>)wview.inliers);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return working;
    }

    public static List<Object> putInlierInfo(FastAccess<SceneWorkingGraph.InlierInfo> listInliers) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int infoIdx = 0; infoIdx < listInliers.size; ++infoIdx) {
            SceneWorkingGraph.InlierInfo inliers = (SceneWorkingGraph.InlierInfo)listInliers.get(infoIdx);
            HashMap map = new HashMap();
            ArrayList views = new ArrayList();
            inliers.views.forIdx((i, v) -> views.add(v.id));
            ArrayList observations = new ArrayList();
            for (int viewIdx = 0; viewIdx < inliers.views.size; ++viewIdx) {
                ArrayList obs = new ArrayList();
                ((DogArray_I32)inliers.observations.get(viewIdx)).forIdx((i, v) -> obs.add(v));
                observations.add(obs);
            }
            map.put("views", views);
            map.put("observations", observations);
            list.add(map);
        }
        return list;
    }

    public static void loadInlierInfo(List<Object> list, PairwiseImageGraph pairwise, DogArray<SceneWorkingGraph.InlierInfo> listInliers) throws IOException {
        listInliers.reset().resize(list.size());
        for (int infoIdx = 0; infoIdx < list.size(); ++infoIdx) {
            Map map = (Map)list.get(infoIdx);
            SceneWorkingGraph.InlierInfo inliers = (SceneWorkingGraph.InlierInfo)listInliers.get(infoIdx);
            List views = (List)BoofMiscOps.getOrThrow((Map)map, (Object)"views");
            List observations = (List)BoofMiscOps.getOrThrow((Map)map, (Object)"observations");
            inliers.views.resize(views.size());
            inliers.views.reset();
            BoofMiscOps.forIdx((List)views, (i, v) -> inliers.views.add((Object)pairwise.lookupNode(v)));
            inliers.observations.resize(views.size());
            for (int viewIdx = 0; viewIdx < inliers.views.size; ++viewIdx) {
                List src = (List)observations.get(viewIdx);
                DogArray_I32 dst = (DogArray_I32)inliers.observations.get(viewIdx);
                dst.resize(src.size());
                dst.reset();
                src.forEach(arg_0 -> ((DogArray_I32)dst).add(arg_0));
            }
        }
    }

    public static BundlePinholeSimplified loadPinholeSimplified(Map<String, Object> map, @Nullable BundlePinholeSimplified intrinsic) {
        if (intrinsic == null) {
            intrinsic = new BundlePinholeSimplified();
        }
        try {
            intrinsic.f = (Double)BoofMiscOps.getOrThrow(map, (Object)"f");
            intrinsic.k1 = (Double)BoofMiscOps.getOrThrow(map, (Object)"k1");
            intrinsic.k2 = (Double)BoofMiscOps.getOrThrow(map, (Object)"k2");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return intrinsic;
    }

    public static Map<String, Object> putPinholeSimplified(BundlePinholeSimplified intrinsic) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("f", intrinsic.f);
        map.put("k1", intrinsic.k1);
        map.put("k2", intrinsic.k2);
        return map;
    }

    public static Map<String, Object> putSE3(Se3_F64 m) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", m.T.x);
        map.put("y", m.T.y);
        map.put("z", m.T.z);
        map.put("R", m.R.data);
        return map;
    }

    public static Se3_F64 loadSE3(Map<String, Object> map, @Nullable Se3_F64 m) throws IOException {
        if (m == null) {
            m = new Se3_F64();
        }
        m.T.x = (Double)BoofMiscOps.getOrThrow(map, (Object)"x");
        m.T.y = (Double)BoofMiscOps.getOrThrow(map, (Object)"y");
        m.T.z = (Double)BoofMiscOps.getOrThrow(map, (Object)"z");
        MultiViewIO.copyIntoMatrix((List)BoofMiscOps.getOrThrow(map, (Object)"R"), m.R);
        return m;
    }
}

