/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import boofcv.alg.cloud.PointCloudReader;
import boofcv.alg.cloud.PointCloudWriter;
import boofcv.io.UtilIO;
import boofcv.io.points.impl.PlyReader;
import boofcv.io.points.impl.PlyWriter;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.mesh.VertexMesh;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class PlyCodec {
    public static void saveAscii(PlyWriter data, Writer outputWriter) throws IOException {
        PlyCodec.writeAsciiHeader(data.getVertexCount(), data.getPolygonCount(), data.isColor(), data.isTextured(), data.getTextureName(), data.isVertexNormals(), outputWriter);
        boolean color = data.isColor();
        Point3D_F64 p = new Point3D_F64();
        Point3D_F64 v = new Point3D_F64();
        for (int i = 0; i < data.getVertexCount(); ++i) {
            data.getVertex(i, p);
            outputWriter.write(String.format("%f %f %f", p.x, p.y, p.z));
            if (data.isVertexNormals()) {
                data.getVertexNormal(i, (GeoTuple3D_F64<?>)v);
                outputWriter.write(String.format(" %f %f %f", v.x, v.y, v.z));
            }
            if (color) {
                int rgb = data.getColor(i);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                outputWriter.write(String.format(" %d %d %d", r, g, b));
            }
            outputWriter.write(10);
        }
        int[] arrayI = new int[100];
        float[] arrayF = new float[100];
        for (int i = 0; i < data.getPolygonCount(); ++i) {
            int idx;
            int size = data.getIndexes(i, arrayI);
            outputWriter.write(size);
            for (idx = 0; idx < size; ++idx) {
                outputWriter.write(" " + arrayI[idx]);
            }
            outputWriter.write(10);
            if (!data.isTextured()) continue;
            BoofMiscOps.checkEq((int)size, (int)data.getTextureCoors(i, arrayF));
            outputWriter.write(size);
            for (idx = 0; idx < size * 2; ++idx) {
                outputWriter.write(" " + arrayF[idx]);
            }
            outputWriter.write(10);
        }
        outputWriter.flush();
    }

    public static void saveMeshAscii(VertexMesh mesh, @Nullable DogArray_I32 colorRGB, Writer outputWriter) throws IOException {
        PlyCodec.saveAscii(PlyCodec.wrapMeshForWriting(mesh, colorRGB), outputWriter);
    }

    public static void saveCloudAscii(PointCloudReader cloud, boolean saveRgb, Writer outputWriter) throws IOException {
        PlyCodec.saveAscii(PlyCodec.wrapCloudForWriting(cloud, saveRgb), outputWriter);
    }

    private static void writeAsciiHeader(int vertexCount, int triangleCount, boolean hasColor, boolean hasTexture, String textureName, boolean hasNormals, Writer outputWriter) throws IOException {
        outputWriter.write("ply\n");
        outputWriter.write("format ascii 1.0\n");
        outputWriter.write("comment Created using BoofCV!\n");
        if (textureName.isEmpty() && hasTexture) {
            System.err.println("Texture file name not specified and it has texture coordinates");
        }
        if (!textureName.isEmpty()) {
            outputWriter.write("comment TextureFile " + textureName + "\n");
        }
        outputWriter.write("element vertex " + vertexCount + "\nproperty float x\nproperty float y\nproperty float z\n");
        if (hasNormals) {
            outputWriter.write("property float nx\nproperty float ny\nproperty float nz\n");
        }
        if (hasColor) {
            outputWriter.write("property uchar red\nproperty uchar green\nproperty uchar blue\n");
        }
        if (triangleCount > 0) {
            outputWriter.write("element face " + triangleCount + "\nproperty list uchar int vertex_indices\n");
            if (hasTexture) {
                outputWriter.write("property list uchar float texcoord\n");
            }
        }
        outputWriter.write("end_header\n");
    }

    public static void saveCloudBinary(PointCloudReader cloud, ByteOrder order, boolean saveRgb, boolean saveAsFloat, OutputStream outputWriter) throws IOException {
        PlyCodec.saveBinary(PlyCodec.wrapCloudForWriting(cloud, saveRgb), order, saveAsFloat, outputWriter);
    }

    public static void saveMeshBinary(VertexMesh mesh, @Nullable DogArray_I32 colorRGB, ByteOrder order, boolean saveAsFloat, OutputStream outputWriter) throws IOException {
        PlyCodec.saveBinary(PlyCodec.wrapMeshForWriting(mesh, colorRGB), order, saveAsFloat, outputWriter);
    }

    public static void saveBinary(PlyWriter data, ByteOrder order, boolean saveAsFloat, OutputStream outputWriter) throws IOException {
        String format = "UTF-8";
        int dataLength = saveAsFloat ? 4 : 8;
        PlyCodec.writeBinaryHeader(data.getVertexCount(), data.getPolygonCount(), order, data.isColor(), data.isTextured(), data.isVertexNormals(), data.getTextureName(), saveAsFloat, format, outputWriter);
        boolean color = data.isColor();
        int locNorm = dataLength * 3;
        int locColor = locNorm + (data.isVertexNormals() ? dataLength * 3 : 0);
        ByteBuffer bytes = ByteBuffer.allocate(locColor + (color ? 3 : 0));
        bytes.order(order);
        Point3D_F64 p = new Point3D_F64();
        Point3D_F64 n = new Point3D_F64();
        for (int i = 0; i < data.getVertexCount(); ++i) {
            data.getVertex(i, p);
            if (saveAsFloat) {
                bytes.putFloat(0, (float)p.x);
                bytes.putFloat(4, (float)p.y);
                bytes.putFloat(8, (float)p.z);
            } else {
                bytes.putDouble(0, p.x);
                bytes.putDouble(8, p.y);
                bytes.putDouble(16, p.z);
            }
            if (data.isVertexNormals()) {
                data.getVertexNormal(i, (GeoTuple3D_F64<?>)n);
                if (saveAsFloat) {
                    bytes.putFloat(locNorm, (float)n.x);
                    bytes.putFloat(locNorm + 4, (float)n.y);
                    bytes.putFloat(locNorm + 8, (float)n.z);
                } else {
                    bytes.putDouble(locNorm, n.x);
                    bytes.putDouble(locNorm + 8, n.y);
                    bytes.putDouble(locNorm + 16, n.z);
                }
            }
            if (color) {
                int rgb = data.getColor(i);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                bytes.put(locColor, (byte)r);
                bytes.put(locColor + 1, (byte)g);
                bytes.put(locColor + 2, (byte)b);
            }
            outputWriter.write(bytes.array());
        }
        int[] arrayI = new int[100];
        float[] arrayF = new float[100];
        bytes = ByteBuffer.allocate(1 + arrayI.length * 4);
        bytes.order(order);
        for (int i = 0; i < data.getPolygonCount(); ++i) {
            int idx;
            int size = data.getIndexes(i, arrayI);
            bytes.position(0);
            bytes.put((byte)size);
            for (idx = 0; idx < size; ++idx) {
                bytes.putInt(arrayI[idx]);
            }
            outputWriter.write(bytes.array(), 0, 1 + 4 * size);
            if (!data.isTextured()) continue;
            bytes.position(0);
            BoofMiscOps.checkEq((int)size, (int)data.getTextureCoors(i, arrayF));
            bytes.put((byte)(2 * size));
            for (idx = 0; idx < size * 2; ++idx) {
                bytes.putFloat(arrayF[idx]);
            }
            outputWriter.write(bytes.array(), 0, 1 + 8 * size);
        }
        outputWriter.flush();
    }

    private static void writeBinaryHeader(int vertexCount, int triangleCount, ByteOrder order, boolean hasColor, boolean hasTexture, boolean hasVertexNormals, String textureName, boolean saveAsFloat, String format, OutputStream outputWriter) throws IOException {
        String string;
        String dataType = saveAsFloat ? "float" : "double";
        outputWriter.write("ply\n".getBytes(format));
        switch (order.toString()) {
            case "LITTLE_ENDIAN": {
                string = "little";
                break;
            }
            case "BIG_ENDIAN": {
                string = "big";
                break;
            }
            default: {
                throw new RuntimeException("Unexpected order=" + order);
            }
        }
        String orderStr = string;
        outputWriter.write(("format binary_" + orderStr + "_endian 1.0\n").getBytes(format));
        outputWriter.write("comment Created using BoofCV!\n".getBytes(format));
        if (textureName.isEmpty() && hasTexture) {
            System.err.println("Texture file name not specified and it has texture coordinates");
        }
        if (!textureName.isEmpty()) {
            outputWriter.write(("comment TextureFile " + textureName + "\n").getBytes(format));
        }
        outputWriter.write(("element vertex " + vertexCount + "\n").getBytes(format));
        outputWriter.write(("property " + dataType + " x\nproperty " + dataType + " y\nproperty " + dataType + " z\n").getBytes(format));
        if (hasVertexNormals) {
            outputWriter.write(("property " + dataType + " nx\nproperty " + dataType + " ny\nproperty " + dataType + " nz\n").getBytes(format));
        }
        if (hasColor) {
            outputWriter.write("property uchar red\nproperty uchar green\nproperty uchar blue\n".getBytes(format));
        }
        if (triangleCount > 0) {
            outputWriter.write(("element face " + triangleCount + "\nproperty list uchar int vertex_indices\n").getBytes(format));
            if (hasTexture) {
                outputWriter.write("property list uchar float texcoord\n".getBytes(format));
            }
        }
        outputWriter.write("end_header\n".getBytes(format));
    }

    private static String readNextPly(InputStream reader, boolean failIfNull, StringBuilder buffer) throws IOException {
        String line = UtilIO.readLine(reader, buffer);
        if (line.isEmpty() && failIfNull) {
            throw new IOException("Unexpected end of file");
        }
        return line;
    }

    private static void readHeader(InputStream input, Header header) throws IOException {
        StringBuilder buffer = new StringBuilder();
        String line = UtilIO.readLine(input, buffer);
        if (line.isEmpty()) {
            throw new IOException("Missing first line");
        }
        if (line.compareToIgnoreCase("ply") != 0) {
            throw new IOException("Expected PLY at start of file");
        }
        line = PlyCodec.readNextPly(input, true, buffer);
        boolean previousVertex = false;
        while (!line.isEmpty()) {
            if (line.startsWith("comment")) {
                if (line.contains("TextureFile")) {
                    int start = "comment TextureFile ".length();
                    header.textureName = line.substring(start);
                }
                line = PlyCodec.readNextPly(input, true, buffer);
                continue;
            }
            if (line.equals("end_header")) break;
            String[] words = line.split("\\s+");
            if (words.length == 1) {
                throw new IOException("Expected more than one word");
            }
            if (line.startsWith("format")) {
                Format format;
                switch (words[1]) {
                    case "ascii": {
                        format = Format.ASCII;
                        break;
                    }
                    case "binary_little_endian": {
                        format = Format.BINARY_LITTLE;
                        break;
                    }
                    case "binary_big_endian": {
                        format = Format.BINARY_BIG;
                        break;
                    }
                    default: {
                        throw new IOException("Unknown format " + words[1]);
                    }
                }
                header.format = format;
            } else if (line.startsWith("element")) {
                previousVertex = false;
                if (words[1].equals("vertex")) {
                    previousVertex = true;
                    header.vertexCount = Integer.parseInt(words[2]);
                } else if (words[1].equals("face")) {
                    header.triangleCount = Integer.parseInt(words[2]);
                }
            } else if (words[0].equals("property") && previousVertex) {
                VarType v;
                DataType dataType;
                switch (words[1].toLowerCase(Locale.US)) {
                    case "float": {
                        dataType = DataType.FLOAT;
                        break;
                    }
                    case "double": {
                        dataType = DataType.DOUBLE;
                        break;
                    }
                    case "char": {
                        dataType = DataType.CHAR;
                        break;
                    }
                    case "short": {
                        dataType = DataType.SHORT;
                        break;
                    }
                    case "int": {
                        dataType = DataType.INT;
                        break;
                    }
                    case "uchar": {
                        dataType = DataType.UCHAR;
                        break;
                    }
                    case "ushort": {
                        dataType = DataType.USHORT;
                        break;
                    }
                    case "uint": {
                        dataType = DataType.UINT;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Add support for " + words[1]);
                    }
                }
                DataType d = dataType;
                switch (words[2].toLowerCase(Locale.US)) {
                    case "x": {
                        v = VarType.X;
                        break;
                    }
                    case "y": {
                        v = VarType.Y;
                        break;
                    }
                    case "z": {
                        v = VarType.Z;
                        break;
                    }
                    case "nx": {
                        v = VarType.NX;
                        break;
                    }
                    case "ny": {
                        v = VarType.NY;
                        break;
                    }
                    case "nz": {
                        v = VarType.NZ;
                        break;
                    }
                    case "red": {
                        v = VarType.R;
                        break;
                    }
                    case "green": {
                        v = VarType.G;
                        break;
                    }
                    case "blue": {
                        v = VarType.B;
                        break;
                    }
                    default: {
                        v = VarType.UNKNOWN;
                    }
                }
                header.dataWords.add(new DataWord(v, d));
            } else if (words[0].equals("property") && words[1].equals("list")) {
                if (words.length != 5) {
                    throw new IOException("Unexpected number of words in properties. Unsupported file format? count=" + words.length);
                }
                DataType countType = DataType.valueOf(words[2].toUpperCase(Locale.US));
                DataType valueType = DataType.valueOf(words[3].toUpperCase(Locale.US));
                header.properties.add(new PropertyList(words[4], countType, valueType));
            } else {
                throw new IOException("Unknown header element: '" + line + "'");
            }
            line = PlyCodec.readNextPly(input, true, buffer);
        }
        block57: for (int i = 0; i < header.dataWords.size(); ++i) {
            DataWord w = header.dataWords.get(i);
            switch (w.var) {
                case R: 
                case G: 
                case B: {
                    header.rgb = true;
                    continue block57;
                }
                case NX: 
                case NY: 
                case NZ: {
                    header.normals = true;
                    continue block57;
                }
            }
        }
    }

    public static void readCloud(InputStream input, final PointCloudWriter output) throws IOException {
        PlyCodec.read(input, new PlyReader(){

            @Override
            public void initialize(int vertexes, int triangles, boolean color) {
                output.initialize(vertexes, color);
            }

            @Override
            public void startVertex() {
                output.startPoint();
            }

            @Override
            public void stopVertex() {
                output.stopPoint();
            }

            @Override
            public void setVertexLocation(double x, double y, double z) {
                output.location(x, y, z);
            }

            @Override
            public void setVertexColor(int r, int g, int b) {
                output.color(r << 16 | g << 8 | b);
            }

            @Override
            public void setVertexNormal(double nx, double ny, double nz) {
            }

            @Override
            public void addPolygon(int[] indexes, int offset, int length) {
            }

            @Override
            public void setTextureName(String textureName) {
            }

            @Override
            public void addTexture(int count, float[] coor) {
            }
        });
    }

    public static void readMesh(InputStream input, final VertexMesh mesh) throws IOException {
        PlyCodec.read(input, new PlyReader(){

            @Override
            public void initialize(int vertexes, int triangles, boolean color) {
                mesh.reset();
                mesh.vertexes.reserve(vertexes);
                mesh.faceVertexes.reserve(triangles * 3);
            }

            @Override
            public void startVertex() {
            }

            @Override
            public void stopVertex() {
            }

            @Override
            public void setVertexLocation(double x, double y, double z) {
                mesh.vertexes.append(x, y, z);
            }

            @Override
            public void setVertexColor(int r, int g, int b) {
                mesh.rgb.add(r << 16 | g << 8 | b);
            }

            @Override
            public void setVertexNormal(double nx, double ny, double nz) {
                mesh.normals.append((float)nx, (float)ny, (float)nz);
            }

            @Override
            public void addPolygon(int[] indexes, int offset, int length) {
                mesh.faceOffsets.add(mesh.faceVertexes.size + length);
                mesh.faceVertexes.addAll(indexes, offset, offset + length);
            }

            @Override
            public void setTextureName(String textureName) {
                mesh.textureName = textureName;
            }

            @Override
            public void addTexture(int count, float[] coor) {
                mesh.addTexture(count, coor);
            }
        });
    }

    public static void read(InputStream input, PlyReader output) throws IOException {
        Header header = new Header();
        PlyCodec.readHeader(input, header);
        if (header.vertexCount == -1) {
            throw new IOException("File is missing vertex count");
        }
        if (header.format == null) {
            throw new IOException("Format is never specified");
        }
        output.initialize(header.vertexCount, header.triangleCount, header.rgb);
        output.setTextureName(header.textureName);
        switch (header.format) {
            case ASCII: {
                PlyCodec.readAscii(output, input, header);
                break;
            }
            case BINARY_LITTLE: 
            case BINARY_BIG: {
                PlyCodec.readCloudBinary(output, input, header);
                break;
            }
            default: {
                throw new RuntimeException("BUG!");
            }
        }
    }

    private static void readAscii(PlyReader output, InputStream reader, Header header) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int I32 = -1;
        double F64 = -1.0;
        int r = 0;
        int g = 0;
        int b = 0;
        double x = -1.0;
        double y = -1.0;
        double z = -1.0;
        double nx = -1.0;
        double ny = -1.0;
        double nz = -1.0;
        for (int i = 0; i < header.vertexCount; ++i) {
            String line = PlyCodec.readNextPly(reader, true, buffer);
            String[] words = line.split("\\s+");
            if (words.length != header.dataWords.size()) {
                throw new IOException("unexpected number of words. " + line);
            }
            block16: for (int j = 0; j < header.dataWords.size(); ++j) {
                DataWord d = header.dataWords.get(j);
                String word = words[j];
                switch (d.data) {
                    case FLOAT: 
                    case DOUBLE: {
                        F64 = Double.parseDouble(word);
                        break;
                    }
                    case UINT: 
                    case INT: 
                    case USHORT: 
                    case SHORT: 
                    case UCHAR: 
                    case CHAR: {
                        I32 = Integer.parseInt(word);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported");
                    }
                }
                switch (d.var) {
                    case X: {
                        x = F64;
                        continue block16;
                    }
                    case Y: {
                        y = F64;
                        continue block16;
                    }
                    case Z: {
                        z = F64;
                        continue block16;
                    }
                    case NX: {
                        nx = F64;
                        continue block16;
                    }
                    case NY: {
                        ny = F64;
                        continue block16;
                    }
                    case NZ: {
                        nz = F64;
                        continue block16;
                    }
                    case R: {
                        r = I32;
                        continue block16;
                    }
                    case G: {
                        g = I32;
                        continue block16;
                    }
                    case B: {
                        b = I32;
                        continue block16;
                    }
                }
            }
            output.startVertex();
            output.setVertexLocation(x, y, z);
            if (header.rgb) {
                output.setVertexColor(r, g, b);
            }
            if (header.normals) {
                output.setVertexNormal(nx, ny, nz);
            }
            output.stopVertex();
        }
        int[] indexes = new int[100];
        for (int i = 0; i < header.triangleCount; ++i) {
            int n;
            String line = PlyCodec.readNextPly(reader, true, buffer);
            String[] words = line.split("\\s+");
            if (words.length != (n = Integer.parseInt(words[0])) + 1) {
                throw new RuntimeException("Unexpected number of words.");
            }
            for (int wordIdx = 1; wordIdx <= n; ++wordIdx) {
                indexes[wordIdx - 1] = Integer.parseInt(words[i]);
            }
            output.addPolygon(indexes, 0, n);
        }
    }

    private static void readCloudBinary(PlyReader output, InputStream reader, Header header) throws IOException {
        int countVertexBytes = 0;
        for (int i = 0; i < header.dataWords.size(); ++i) {
            countVertexBytes += header.dataWords.get((int)i).data.size;
        }
        int maxPolygonOrder = 10;
        int countBytes = countVertexBytes;
        for (int i = 0; i < header.properties.size(); ++i) {
            int countPropBytes = header.properties.get((int)i).valueType.size * maxPolygonOrder;
            countBytes = Math.max(countBytes, countPropBytes);
        }
        ByteOrder order = header.format == Format.BINARY_LITTLE ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] line = new byte[countBytes];
        ByteBuffer bb = ByteBuffer.wrap(line);
        bb.order(order);
        int I32 = -1;
        double F64 = -1.0;
        int r = -1;
        int g = -1;
        int b = -1;
        double x = -1.0;
        double y = -1.0;
        double z = -1.0;
        double nx = -1.0;
        double ny = -1.0;
        double nz = -1.0;
        for (int i = 0; i < header.vertexCount; ++i) {
            int found = reader.read(line, 0, countVertexBytes);
            if (countVertexBytes != found) {
                throw new IOException("Read unexpected number of bytes. " + found + " vs " + countVertexBytes);
            }
            int location = 0;
            block32: for (int j = 0; j < header.dataWords.size(); ++j) {
                DataWord d = header.dataWords.get(j);
                switch (d.data) {
                    case FLOAT: {
                        F64 = bb.getFloat(location);
                        break;
                    }
                    case DOUBLE: {
                        F64 = bb.getDouble(location);
                        break;
                    }
                    case CHAR: {
                        I32 = bb.get(location);
                        break;
                    }
                    case UCHAR: {
                        I32 = bb.get(location) & 0xFF;
                        break;
                    }
                    case SHORT: {
                        I32 = bb.getShort(location);
                        break;
                    }
                    case USHORT: {
                        I32 = bb.getShort(location) & 0xFFFF;
                        break;
                    }
                    case INT: {
                        I32 = bb.getInt(location);
                        break;
                    }
                    case UINT: {
                        I32 = bb.getInt(location);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported");
                    }
                }
                location += d.data.size;
                switch (d.var) {
                    case X: {
                        x = F64;
                        continue block32;
                    }
                    case Y: {
                        y = F64;
                        continue block32;
                    }
                    case Z: {
                        z = F64;
                        continue block32;
                    }
                    case NX: {
                        nx = F64;
                        continue block32;
                    }
                    case NY: {
                        ny = F64;
                        continue block32;
                    }
                    case NZ: {
                        nz = F64;
                        continue block32;
                    }
                    case R: {
                        r = I32;
                        continue block32;
                    }
                    case G: {
                        g = I32;
                        continue block32;
                    }
                    case B: {
                        b = I32;
                        continue block32;
                    }
                }
            }
            output.startVertex();
            output.setVertexLocation(x, y, z);
            if (header.rgb) {
                output.setVertexColor(r, g, b);
            }
            if (header.normals) {
                output.setVertexNormal(nx, ny, nz);
            }
            output.stopVertex();
        }
        int[] arrayI = new int[100];
        float[] arrayF = new float[100];
        for (int i = 0; i < header.triangleCount; ++i) {
            block34: for (int idxProperty = 0; idxProperty < header.properties.size(); ++idxProperty) {
                PropertyList prop = header.properties.get(idxProperty);
                if (prop.countType != DataType.UCHAR) {
                    throw new IOException("Expected unsigned byte for count type, not " + prop.countType);
                }
                switch (prop.label) {
                    case "vertex_indices": {
                        PlyCodec.readPolygon(reader, bb, line, arrayI, header.vertexCount, output);
                        continue block34;
                    }
                    case "texcoord": {
                        PlyCodec.readTextureCoor(reader, prop.valueType, bb, line, arrayF, output);
                        continue block34;
                    }
                    default: {
                        System.err.println("Unknown property type " + prop.label);
                    }
                }
            }
        }
    }

    private static void readPolygon(InputStream reader, ByteBuffer bb, byte[] lineBytes, int[] indexes, int vertexCount, PlyReader output) throws IOException {
        if (1 != reader.read(lineBytes, 0, 1)) {
            throw new RuntimeException("Couldn't read count byte");
        }
        int count = lineBytes[0] & 0xFF;
        int bytesInLine = count * 4;
        if (lineBytes.length < bytesInLine) {
            throw new RuntimeException("polygonLine is too small. allocated=" + lineBytes.length + " required=" + bytesInLine + " degree=" + count);
        }
        int found = reader.read(lineBytes, 0, bytesInLine);
        if (found != bytesInLine) {
            throw new IOException("Read unexpected number of bytes. " + found + " vs " + bytesInLine);
        }
        for (int wordIndex = 0; wordIndex < count; ++wordIndex) {
            int foundIndex = bb.getInt(wordIndex * 4);
            if (foundIndex < 0 || foundIndex > vertexCount) {
                throw new IOException("Negative index. word: " + wordIndex + " value: " + foundIndex + " count: " + vertexCount);
            }
            indexes[wordIndex] = foundIndex;
        }
        output.addPolygon(indexes, 0, count);
    }

    private static void readTextureCoor(InputStream reader, DataType valueType, ByteBuffer bb, byte[] workBytes, float[] tempF, PlyReader output) throws IOException {
        if (1 != reader.read(workBytes, 0, 1)) {
            throw new RuntimeException("Couldn't read count byte");
        }
        int count = workBytes[0] & 0xFF;
        int bytesToRead = count * valueType.size;
        if (workBytes.length < bytesToRead) {
            throw new RuntimeException("workspace too small to read in array of " + valueType.name() + " count=" + count);
        }
        int found = reader.read(workBytes, 0, bytesToRead);
        if (found != bytesToRead) {
            throw new IOException("Read unexpected number of bytes. " + found + " vs " + bytesToRead);
        }
        block3: for (int wordIndex = 0; wordIndex < count; ++wordIndex) {
            switch (valueType) {
                case FLOAT: {
                    tempF[wordIndex] = bb.getFloat(wordIndex * valueType.size);
                    continue block3;
                }
                default: {
                    throw new RuntimeException("Unexpected type");
                }
            }
        }
        output.addTexture(count / 2, tempF);
    }

    private static PlyWriter wrapMeshForWriting(final VertexMesh mesh, final @Nullable DogArray_I32 colorRGB) {
        return new PlyWriter(){

            @Override
            public int getVertexCount() {
                return mesh.vertexes.size();
            }

            @Override
            public int getPolygonCount() {
                return mesh.faceOffsets.size - 1;
            }

            @Override
            public boolean isColor() {
                return colorRGB != null;
            }

            @Override
            public boolean isTextured() {
                return mesh.texture.size() > 0;
            }

            @Override
            public boolean isVertexNormals() {
                return mesh.normals.size() > 0;
            }

            @Override
            public String getTextureName() {
                return mesh.textureName;
            }

            @Override
            public void getVertex(int which, Point3D_F64 vertex) {
                mesh.vertexes.getCopy(which, vertex);
            }

            @Override
            public void getVertexNormal(int which, GeoTuple3D_F64<?> normal) {
                Point3D_F32 tmp = mesh.normals.getTemp(which);
                normal.setTo((double)tmp.x, (double)tmp.y, (double)tmp.z);
            }

            @Override
            public int getColor(int which) {
                return colorRGB.get(which);
            }

            @Override
            public int getIndexes(int which, int[] indexes) {
                int idx0 = mesh.faceOffsets.get(which);
                int idx1 = mesh.faceOffsets.get(which + 1);
                for (int i = idx0; i < idx1; ++i) {
                    indexes[i - idx0] = mesh.faceVertexes.get(i);
                }
                return idx1 - idx0;
            }

            @Override
            public int getTextureCoors(int which, float[] coordinates) {
                int idx0 = mesh.faceOffsets.get(which);
                int idx1 = mesh.faceOffsets.get(which + 1);
                int idxArray = 0;
                for (int i = idx0; i < idx1; ++i) {
                    Point2D_F32 p = mesh.texture.getTemp(i);
                    coordinates[idxArray++] = p.x;
                    coordinates[idxArray++] = p.y;
                }
                return idx1 - idx0;
            }
        };
    }

    private static PlyWriter wrapCloudForWriting(final PointCloudReader cloud, final boolean saveRgb) {
        return new PlyWriter(){

            @Override
            public int getVertexCount() {
                return cloud.size();
            }

            @Override
            public int getPolygonCount() {
                return 0;
            }

            @Override
            public boolean isColor() {
                return saveRgb;
            }

            @Override
            public boolean isTextured() {
                return false;
            }

            @Override
            public boolean isVertexNormals() {
                return false;
            }

            @Override
            public String getTextureName() {
                return "";
            }

            @Override
            public void getVertex(int which, Point3D_F64 vertex) {
                cloud.get(which, vertex);
            }

            @Override
            public void getVertexNormal(int which, GeoTuple3D_F64<?> normal) {
            }

            @Override
            public int getColor(int which) {
                return cloud.getRGB(which);
            }

            @Override
            public int getIndexes(int which, int[] indexes) {
                return 0;
            }

            @Override
            public int getTextureCoors(int which, float[] coordinates) {
                return 0;
            }
        };
    }

    private static class Header {
        List<DataWord> dataWords = new ArrayList<DataWord>();
        int vertexCount = -1;
        int triangleCount = -1;
        boolean rgb = false;
        boolean normals = false;
        List<PropertyList> properties = new ArrayList<PropertyList>();
        Format format = Format.ASCII;
        String textureName = "";

        private Header() {
        }
    }

    private static enum Format {
        ASCII,
        BINARY_LITTLE,
        BINARY_BIG;

    }

    private static enum DataType {
        FLOAT(4),
        DOUBLE(8),
        CHAR(1),
        SHORT(2),
        INT(4),
        UCHAR(1),
        USHORT(2),
        UINT(4);

        final int size;

        private DataType(int size) {
            this.size = size;
        }
    }

    private static enum VarType {
        X,
        Y,
        Z,
        R,
        G,
        B,
        NX,
        NY,
        NZ,
        UNKNOWN;

    }

    private static class DataWord {
        VarType var;
        DataType data;

        public DataWord(VarType var, DataType data) {
            this.var = var;
            this.data = data;
        }
    }

    private static class PropertyList {
        String label;
        DataType countType;
        DataType valueType;

        public PropertyList(String label, DataType countType, DataType valueType) {
            this.label = label;
            this.countType = countType;
            this.valueType = valueType;
        }
    }
}

