/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.io.image.LookUpImageFilesByIndex;
import boofcv.io.image.UtilImageIO;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.LookUpImages;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDimension;

public class LookUpImageFilesByPath
implements LookUpImages {
    final ImageDimension dimension = new ImageDimension(-1, -1);
    LookUpImageFilesByIndex.LoadImage loader;

    public LookUpImageFilesByPath(LookUpImageFilesByIndex.LoadImage loader) {
        this.loader = loader;
    }

    public LookUpImageFilesByPath() {
        this((path, output) -> UtilImageIO.loadImage(path, true, output));
    }

    public boolean loadShape(String path, ImageDimension shape) {
        if (this.dimension.height == -1) {
            GrayU8 gray = new GrayU8(1, 1);
            this.loader.load(path, (ImageBase)gray);
            this.dimension.width = gray.getWidth();
            this.dimension.height = gray.getHeight();
        }
        shape.setTo(this.dimension);
        return true;
    }

    public <LT extends ImageBase<LT>> boolean loadImage(String path, LT output) {
        this.loader.load(path, output);
        if (this.dimension.width == -1) {
            this.dimension.setTo(output.width, output.height);
        } else {
            BoofMiscOps.checkEq((int)this.dimension.width, (int)output.width);
            BoofMiscOps.checkEq((int)this.dimension.height, (int)output.height);
        }
        return true;
    }

    public LookUpImageFilesByIndex.LoadImage getLoader() {
        return this.loader;
    }

    public void setLoader(LookUpImageFilesByIndex.LoadImage loader) {
        this.loader = loader;
    }
}

