/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block.score;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.disparity.DisparityBlockMatchBestFive;
import boofcv.alg.disparity.block.BlockRowScore;
import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.concurrency.BoofConcurrency;
import boofcv.misc.Compare_F32;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import pabeles.concurrency.GrowArray;
import pabeles.concurrency.IntRangeObjectConsumer;

public class DisparityScoreBMBestFive_F32<DI extends ImageGray<DI>>
extends DisparityBlockMatchBestFive<GrayF32, DI> {
    DisparitySelect<float[], DI> disparitySelect0;
    BlockRowScore<GrayF32, float[], float[]> scoreRows;
    GrayF32 left;
    GrayF32 right;
    DI disparity;
    GrowArray<WorkSpace> workspace = new GrowArray(() -> new WorkSpace());
    ComputeBlock computeBlock = new ComputeBlock();

    public DisparityScoreBMBestFive_F32(int regionRadiusX, int regionRadiusY, BlockRowScore<GrayF32, float[], float[]> scoreRows, DisparitySelect<float[], DI> computeDisparity) {
        super(regionRadiusX, regionRadiusY, ImageType.SB_F32);
        this.disparitySelect0 = computeDisparity;
        this.scoreRows = scoreRows;
        this.workspace.grow();
        if (!(computeDisparity instanceof Compare_F32)) {
            throw new IllegalArgumentException("computeDisparity must also implement Compare_F32");
        }
    }

    @Override
    public void setBorder(ImageBorder<GrayF32> border) {
        super.setBorder(border);
        this.scoreRows.setBorder(border);
    }

    @Override
    public void _process(GrayF32 left, GrayF32 right, DI disparity) {
        InputSanityCheck.checkSameShape((ImageBase)left, (ImageBase)right);
        disparity.reshape(left.width, left.height);
        this.left = left;
        this.right = right;
        this.growBorderL.setImage((ImageBase)left);
        this.growBorderR.setImage((ImageBase)right);
        this.disparity = disparity;
        this.scoreRows.setInput(left, right);
        if (BoofConcurrency.USE_CONCURRENT) {
            BoofConcurrency.loopBlocks((int)0, (int)left.height, (int)this.regionHeight, this.workspace, (IntRangeObjectConsumer)this.computeBlock);
        } else {
            this.computeBlock.accept((WorkSpace)this.workspace.get(0), 0, left.height);
        }
    }

    private void computeFirstRow(int row0, WorkSpace ws) {
        int disparityMax = Math.min(this.left.width, this.disparityMax);
        ws.activeVerticalScore = 1;
        for (int row = 0; row < this.regionHeight; ++row) {
            this.growBorderL.growRow(row0 + row, this.radiusX, this.radiusX, (Object)ws.leftRow, 0);
            this.growBorderR.growRow(row0 + row, this.radiusX, this.radiusX, (Object)ws.rightRow, 0);
            float[] scores = ws.horizontalScore[row];
            this.scoreRows.scoreRow(row0 + row, ws.leftRow, ws.rightRow, scores, this.disparityMin, disparityMax, this.regionWidth, ws.elementScore);
        }
        float[] firstRow = ws.verticalScore[0];
        for (int i = 0; i < this.widthDisparityBlock; ++i) {
            float sum = 0.0f;
            for (int row = 0; row < this.regionHeight; ++row) {
                sum += ws.horizontalScore[row][i];
            }
            firstRow[i] = sum;
        }
        if (this.scoreRows.isRequireNormalize() && row0 + this.radiusY >= 0) {
            this.scoreRows.normalizeRegionScores(row0 + this.radiusY, firstRow, this.disparityMin, disparityMax, this.regionWidth, this.regionHeight, ws.verticalScoreNorm[0]);
        }
    }

    private void computeRemainingRows(int row0, int row1, WorkSpace ws) {
        int disparityMax = Math.min(this.left.width, this.disparityMax);
        int row = row0 + this.regionHeight;
        while (row < row1) {
            int i;
            int activeIndex = ws.activeVerticalScore % this.regionHeight;
            int oldRow = (row - row0) % this.regionHeight;
            float[] previous = ws.verticalScore[(ws.activeVerticalScore - 1) % this.regionHeight];
            float[] active = ws.verticalScore[activeIndex];
            float[] scores = ws.horizontalScore[oldRow];
            for (i = 0; i < this.widthDisparityBlock; ++i) {
                active[i] = previous[i] - scores[i];
            }
            this.growBorderL.growRow(row, this.radiusX, this.radiusX, (Object)ws.leftRow, 0);
            this.growBorderR.growRow(row, this.radiusX, this.radiusX, (Object)ws.rightRow, 0);
            this.scoreRows.scoreRow(row, ws.leftRow, ws.rightRow, scores, this.disparityMin, disparityMax, this.regionWidth, ws.elementScore);
            for (i = 0; i < this.widthDisparityBlock; ++i) {
                int n = i;
                active[n] = active[n] + scores[i];
            }
            if (this.scoreRows.isRequireNormalize() && row >= this.radiusY && row < this.left.height + this.radiusY) {
                this.scoreRows.normalizeRegionScores(row - this.radiusY, active, this.disparityMin, disparityMax, this.regionWidth, this.regionHeight, ws.verticalScoreNorm[activeIndex]);
            }
            if (ws.activeVerticalScore >= 2 * this.radiusY) {
                float[] bottom;
                float[] middle;
                float[] top;
                int disparityY = row - 2 * this.radiusY;
                int off0 = -2 * this.radiusY;
                int off1 = -this.radiusY;
                int off2 = 0;
                if (disparityY - this.radiusY < 0) {
                    off0 -= disparityY - this.radiusY;
                }
                if (disparityY + this.radiusY >= this.left.height) {
                    off2 = off2 - (disparityY + this.radiusY - this.left.height) - 1;
                }
                if (this.scoreRows.isRequireNormalize()) {
                    top = ws.verticalScoreNorm[(ws.activeVerticalScore + off0) % this.regionHeight];
                    middle = ws.verticalScoreNorm[(ws.activeVerticalScore + off1) % this.regionHeight];
                    bottom = ws.verticalScoreNorm[(ws.activeVerticalScore + off2) % this.regionHeight];
                } else {
                    top = ws.verticalScore[(ws.activeVerticalScore + off0) % this.regionHeight];
                    middle = ws.verticalScore[(ws.activeVerticalScore + off1) % this.regionHeight];
                    bottom = ws.verticalScore[(ws.activeVerticalScore + off2) % this.regionHeight];
                }
                this.computeScoreFive(top, middle, bottom, ws.fiveScore, this.left.width, (Compare_F32)ws.computeDisparity);
                ws.computeDisparity.process(disparityY, ws.fiveScore);
            }
            ++row;
            ++ws.activeVerticalScore;
        }
    }

    protected void computeScoreFive(float[] top, float[] middle, float[] bottom, float[] score, int width, Compare_F32 compare) {
        int disparityMax = Math.min(this.left.width, this.disparityMax);
        float WORST_SCORE = Float.MAX_VALUE * (float)compare.compare(0.0f, 1.0f);
        for (int d = this.disparityMin; d <= disparityMax; ++d) {
            int indexSrc = (d - this.disparityMin) * width + (d - this.disparityMin);
            int indexDst = (d - this.disparityMin) * width + (d - this.disparityMin);
            int i = 0;
            while (i < width - d) {
                float temp;
                float val0 = WORST_SCORE;
                float val1 = WORST_SCORE;
                float val2 = WORST_SCORE;
                float val3 = WORST_SCORE;
                if (i + d + this.radiusX < width) {
                    val1 = top[indexSrc + this.radiusX];
                    val3 = bottom[indexSrc + this.radiusX];
                }
                if (i - this.radiusX >= 0) {
                    val0 = top[indexSrc - this.radiusX];
                    val2 = bottom[indexSrc - this.radiusX];
                }
                if (compare.compare(val0, val1) < 0) {
                    temp = val0;
                    val0 = val1;
                    val1 = temp;
                }
                if (compare.compare(val2, val3) < 0) {
                    temp = val2;
                    val2 = val3;
                    val3 = temp;
                }
                float s = compare.compare(val0, val3) < 0 ? val2 + val3 : (compare.compare(val1, val2) < 0 ? val2 + val0 : val0 + val1);
                score[indexDst++] = s + middle[indexSrc];
                ++i;
                ++indexSrc;
            }
        }
    }

    @Override
    public ImageType<GrayF32> getInputType() {
        return this.scoreRows.getImageType();
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.disparitySelect0.getDisparityType();
    }

    @Override
    public int getMaxRegionError() {
        return 3 * this.regionWidth * this.regionHeight * this.getMaxPerPixelError();
    }

    @Override
    protected int getMaxPerPixelError() {
        return this.scoreRows.getMaxPerPixelError();
    }

    class WorkSpace {
        float[] elementScore;
        float[][] horizontalScore;
        float[][] verticalScore;
        float[][] verticalScoreNorm;
        int activeVerticalScore;
        float[] fiveScore;
        float[] leftRow;
        float[] rightRow;
        DisparitySelect<float[], DI> computeDisparity;

        WorkSpace() {
        }

        public void checkSize() {
            if (this.horizontalScore == null || this.verticalScore.length < DisparityScoreBMBestFive_F32.this.widthDisparityBlock) {
                this.horizontalScore = new float[DisparityScoreBMBestFive_F32.this.regionHeight][DisparityScoreBMBestFive_F32.this.widthDisparityBlock];
                this.verticalScore = new float[DisparityScoreBMBestFive_F32.this.regionHeight][DisparityScoreBMBestFive_F32.this.widthDisparityBlock];
                if (DisparityScoreBMBestFive_F32.this.scoreRows.isRequireNormalize()) {
                    this.verticalScoreNorm = new float[DisparityScoreBMBestFive_F32.this.regionHeight][DisparityScoreBMBestFive_F32.this.widthDisparityBlock];
                }
                this.elementScore = new float[DisparityScoreBMBestFive_F32.this.left.width + 2 * DisparityScoreBMBestFive_F32.this.radiusX];
                this.fiveScore = new float[DisparityScoreBMBestFive_F32.this.widthDisparityBlock];
                this.leftRow = (float[])DisparityScoreBMBestFive_F32.this.left.getImageType().getDataType().newArray(this.elementScore.length);
                this.rightRow = (float[])DisparityScoreBMBestFive_F32.this.right.getImageType().getDataType().newArray(this.elementScore.length);
            }
            if (this.computeDisparity == null) {
                this.computeDisparity = DisparityScoreBMBestFive_F32.this.disparitySelect0.concurrentCopy();
            }
            this.computeDisparity.configure(DisparityScoreBMBestFive_F32.this.disparity, DisparityScoreBMBestFive_F32.this.disparityMin, DisparityScoreBMBestFive_F32.this.disparityMax, DisparityScoreBMBestFive_F32.this.radiusX * 2);
        }
    }

    private class ComputeBlock
    implements IntRangeObjectConsumer<WorkSpace> {
        private ComputeBlock() {
        }

        public void accept(WorkSpace workspace, int minInclusive, int maxExclusive) {
            workspace.checkSize();
            int row0 = minInclusive - 2 * DisparityScoreBMBestFive_F32.this.radiusY;
            int row1 = maxExclusive + 2 * DisparityScoreBMBestFive_F32.this.radiusY;
            DisparityScoreBMBestFive_F32.this.computeFirstRow(row0, workspace);
            DisparityScoreBMBestFive_F32.this.computeRemainingRows(row0, row1, workspace);
        }
    }
}

