/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.mvs.DisparityParameters;
import boofcv.alg.mvs.MultiViewStereoOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;

public class CreateCloudFromDisparityImages {
    public double disparitySimilarTol = 1.0;
    final DogArray<Point3D_F64> cloud = new DogArray(Point3D_F64::new, p -> p.setTo(0.0, 0.0, 0.0));
    final DogArray_I32 viewPointIdx = new DogArray_I32();

    public void reset() {
        this.cloud.reset();
        this.viewPointIdx.reset();
        this.viewPointIdx.add(0);
    }

    public int addCloud(List<Point3D_F64> cloud) {
        this.viewPointIdx.add(this.cloud.size + cloud.size());
        this.cloud.copyAll(cloud, (s, d) -> d.setTo(s));
        return this.viewPointIdx.size - 1;
    }

    public int addDisparity(GrayF32 disparity, GrayU8 mask, Se3_F64 world_to_view, DisparityParameters parameters, Point2Transform2_F64 rectNorm_to_dispPixel, PixelTransform<Point2D_F64> dispPixel_to_rectNorm) {
        InputSanityCheck.checkSameShape((ImageBase)disparity, (ImageBase)mask);
        MultiViewStereoOps.maskOutPointsInCloud(this.cloud.toList(), disparity, parameters, world_to_view, rectNorm_to_dispPixel, this.disparitySimilarTol, mask);
        if (UtilEjml.isUncountable((float)ImageStatistics.sum((GrayF32)disparity))) {
            throw new RuntimeException("BUG");
        }
        Point2D_F64 norm = new Point2D_F64();
        Point3D_F64 rectP = new Point3D_F64();
        Point3D_F64 leftP = new Point3D_F64();
        CameraPinhole intrinsic = parameters.pinhole;
        double baseline = parameters.baseline;
        double disparityMin = parameters.disparityMin;
        for (int y = 0; y < disparity.height; ++y) {
            int indexDisp = y * disparity.stride + disparity.startIndex;
            int indexMask = y * mask.stride + mask.startIndex;
            int x = 0;
            while (x < disparity.width) {
                double d;
                if (mask.data[indexMask] == 0 && !((d = (double)disparity.data[indexDisp]) >= (double)parameters.disparityRange) && !((d += disparityMin) <= 0.0)) {
                    dispPixel_to_rectNorm.compute(x, y, (Object)norm);
                    rectP.z = baseline * intrinsic.fx / d;
                    rectP.x = rectP.z * norm.x;
                    rectP.y = rectP.z * norm.y;
                    GeometryMath_F64.multTran((DMatrixRMaj)parameters.rotateToRectified, (GeoTuple3D_F64)rectP, (GeoTuple3D_F64)leftP);
                    SePointOps_F64.transformReverse((Se3_F64)world_to_view, (Point3D_F64)leftP, (Point3D_F64)((Point3D_F64)this.cloud.grow()));
                }
                ++x;
                ++indexDisp;
                ++indexMask;
            }
        }
        this.viewPointIdx.add(this.cloud.size());
        return this.viewPointIdx.size - 1;
    }

    public DogArray<Point3D_F64> getCloud() {
        return this.cloud;
    }

    public DogArray_I32 getViewPointIdx() {
        return this.viewPointIdx;
    }
}

