/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.disparity;

import boofcv.factory.transform.census.CensusVariants;
import boofcv.struct.Configuration;
import boofcv.struct.pyramid.ConfigDiscreteLevels;

public interface ConfigDisparityError
extends Configuration {

    public static class HMI
    implements ConfigDisparityError {
        public int totalGrayLevels = 256;
        public ConfigDiscreteLevels pyramidLayers = new ConfigDiscreteLevels(-1, 50, -1);
        public int smoothingRadius = 3;
        public int extraIterations = 0;

        public void checkValidity() {
        }

        public void setTo(HMI src) {
            this.totalGrayLevels = src.totalGrayLevels;
            this.pyramidLayers.setTo(src.pyramidLayers);
            this.smoothingRadius = src.smoothingRadius;
            this.extraIterations = src.extraIterations;
        }
    }

    public static class NCC
    implements ConfigDisparityError {
        public double eps = 5.5E-6;
        public boolean normalizeInput = true;

        public void checkValidity() {
        }

        public void setTo(NCC src) {
            this.eps = src.eps;
            this.normalizeInput = src.normalizeInput;
        }
    }

    public static class Census
    implements ConfigDisparityError {
        public CensusVariants variant = CensusVariants.BLOCK_5_5;

        public void checkValidity() {
        }

        public void setTo(Census src) {
            this.variant = src.variant;
        }
    }
}

