/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block.score;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.disparity.DisparityBlockMatchBestFive;
import boofcv.alg.disparity.block.BlockRowScore;
import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.concurrency.BoofConcurrency;
import boofcv.misc.Compare_S32;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import pabeles.concurrency.GrowArray;
import pabeles.concurrency.IntRangeObjectConsumer;

public class DisparityScoreBMBestFive_S32<T extends ImageBase<T>, DI extends ImageGray<DI>>
extends DisparityBlockMatchBestFive<T, DI> {
    DisparitySelect<int[], DI> disparitySelect0;
    BlockRowScore<T, int[], Object> scoreRows;
    int sampleRadiusX;
    int sampleRadiusY;
    int sampleWidthX;
    int sampleWidthY;
    T left;
    T right;
    DI disparity;
    GrowArray<WorkSpace> workspace = new GrowArray(() -> new WorkSpace());
    ComputeBlock computeBlock = new ComputeBlock();

    public DisparityScoreBMBestFive_S32(int regionRadiusX, int regionRadiusY, BlockRowScore<T, int[], Object> scoreRows, DisparitySelect<int[], DI> computeDisparity, ImageType<T> imageType) {
        super(regionRadiusX, regionRadiusY, imageType);
        this.scoreRows = scoreRows;
        this.disparitySelect0 = computeDisparity;
        this.workspace.grow();
        this.sampleRadiusX = regionRadiusX * 2;
        this.sampleRadiusY = regionRadiusY * 2;
        this.sampleWidthX = this.sampleRadiusX * 2 + 1;
        this.sampleWidthY = this.sampleRadiusY * 2 + 1;
        if (!(computeDisparity instanceof Compare_S32)) {
            throw new IllegalArgumentException("computeDisparity must also implement Compare_S32");
        }
    }

    @Override
    public void setBorder(ImageBorder<T> border) {
        super.setBorder(border);
        this.scoreRows.setBorder(border);
    }

    @Override
    public void _process(T left, T right, DI disparity) {
        InputSanityCheck.checkSameShape(left, right);
        this.left = left;
        this.right = right;
        this.growBorderL.setImage(left);
        this.growBorderR.setImage(right);
        this.disparity = disparity;
        this.scoreRows.setInput(left, right);
        if (BoofConcurrency.USE_CONCURRENT) {
            BoofConcurrency.loopBlocks((int)0, (int)((ImageBase)left).height, (int)this.regionHeight, this.workspace, (IntRangeObjectConsumer)this.computeBlock);
        } else {
            this.computeBlock.accept((WorkSpace)this.workspace.get(0), 0, ((ImageBase)left).height);
        }
    }

    private void computeFirstRow(int row0, WorkSpace ws) {
        int disparityMax = Math.min(((ImageBase)this.left).width, this.disparityMax);
        ws.activeVerticalScore = 1;
        for (int row = 0; row < this.regionHeight; ++row) {
            this.growBorderL.growRow(row0 + row, this.radiusX, this.radiusX, ws.leftRow, 0);
            this.growBorderR.growRow(row0 + row, this.radiusX, this.radiusX, ws.rightRow, 0);
            int[] scores = ws.horizontalScore[row];
            this.scoreRows.scoreRow(row0 + row, ws.leftRow, ws.rightRow, scores, this.disparityMin, disparityMax, this.regionWidth, ws.elementScore);
        }
        int[] firstRow = ws.verticalScore[0];
        for (int i = 0; i < this.widthDisparityBlock; ++i) {
            int sum = 0;
            for (int row = 0; row < this.regionHeight; ++row) {
                sum += ws.horizontalScore[row][i];
            }
            firstRow[i] = sum;
        }
        if (this.scoreRows.isRequireNormalize() && row0 + this.radiusY >= 0) {
            this.scoreRows.normalizeRegionScores(row0 + this.radiusY, firstRow, this.disparityMin, disparityMax, this.regionWidth, this.regionHeight, ws.verticalScoreNorm[0]);
        }
    }

    private void computeRemainingRows(int row0, int row1, WorkSpace ws) {
        int disparityMax = Math.min(((ImageBase)this.left).width, this.disparityMax);
        int row = row0 + this.regionHeight;
        while (row < row1) {
            int i;
            int activeIndex = ws.activeVerticalScore % this.regionHeight;
            int oldRow = (row - row0) % this.regionHeight;
            int[] previous = ws.verticalScore[(ws.activeVerticalScore - 1) % this.regionHeight];
            int[] active = ws.verticalScore[activeIndex];
            int[] scores = ws.horizontalScore[oldRow];
            for (i = 0; i < this.widthDisparityBlock; ++i) {
                active[i] = previous[i] - scores[i];
            }
            this.growBorderL.growRow(row, this.radiusX, this.radiusX, ws.leftRow, 0);
            this.growBorderR.growRow(row, this.radiusX, this.radiusX, ws.rightRow, 0);
            this.scoreRows.scoreRow(row, ws.leftRow, ws.rightRow, scores, this.disparityMin, disparityMax, this.regionWidth, ws.elementScore);
            for (i = 0; i < this.widthDisparityBlock; ++i) {
                int n = i;
                active[n] = active[n] + scores[i];
            }
            if (this.scoreRows.isRequireNormalize() && row >= this.radiusY && row < ((ImageBase)this.left).height + this.radiusY) {
                this.scoreRows.normalizeRegionScores(row - this.radiusY, active, this.disparityMin, disparityMax, this.regionWidth, this.regionHeight, ws.verticalScoreNorm[activeIndex]);
            }
            if (ws.activeVerticalScore >= 2 * this.radiusY) {
                int[] bottom;
                int[] middle;
                int[] top;
                int disparityY = row - 2 * this.radiusY;
                int off0 = -2 * this.radiusY;
                int off1 = -this.radiusY;
                int off2 = 0;
                if (disparityY - this.radiusY < 0) {
                    off0 -= disparityY - this.radiusY;
                }
                if (disparityY + this.radiusY >= ((ImageBase)this.left).height) {
                    off2 = off2 - (disparityY + this.radiusY - ((ImageBase)this.left).height) - 1;
                }
                if (this.scoreRows.isRequireNormalize()) {
                    top = ws.verticalScoreNorm[(ws.activeVerticalScore + off0) % this.regionHeight];
                    middle = ws.verticalScoreNorm[(ws.activeVerticalScore + off1) % this.regionHeight];
                    bottom = ws.verticalScoreNorm[(ws.activeVerticalScore + off2) % this.regionHeight];
                } else {
                    top = ws.verticalScore[(ws.activeVerticalScore + off0) % this.regionHeight];
                    middle = ws.verticalScore[(ws.activeVerticalScore + off1) % this.regionHeight];
                    bottom = ws.verticalScore[(ws.activeVerticalScore + off2) % this.regionHeight];
                }
                this.computeScoreFive(top, middle, bottom, ws.fiveScore, ((ImageBase)this.left).width, (Compare_S32)ws.computeDisparity);
                ws.computeDisparity.process(disparityY, ws.fiveScore);
            }
            ++row;
            ++ws.activeVerticalScore;
        }
    }

    protected void computeScoreFive(int[] top, int[] middle, int[] bottom, int[] score, int width, Compare_S32 compare) {
        int disparityMax = Math.min(((ImageBase)this.left).width, this.disparityMax);
        int WORST_SCORE = Integer.MAX_VALUE * compare.compare(0, 1);
        for (int d = this.disparityMin; d <= disparityMax; ++d) {
            int indexSrc = (d - this.disparityMin) * width + (d - this.disparityMin);
            int indexDst = (d - this.disparityMin) * width + (d - this.disparityMin);
            int i = 0;
            while (i < width - d) {
                int temp;
                int val0 = WORST_SCORE;
                int val1 = WORST_SCORE;
                int val2 = WORST_SCORE;
                int val3 = WORST_SCORE;
                if (i + d + this.radiusX < width) {
                    val1 = top[indexSrc + this.radiusX];
                    val3 = bottom[indexSrc + this.radiusX];
                }
                if (i - this.radiusX >= 0) {
                    val0 = top[indexSrc - this.radiusX];
                    val2 = bottom[indexSrc - this.radiusX];
                }
                if (compare.compare(val0, val1) < 0) {
                    temp = val0;
                    val0 = val1;
                    val1 = temp;
                }
                if (compare.compare(val2, val3) < 0) {
                    temp = val2;
                    val2 = val3;
                    val3 = temp;
                }
                int s = compare.compare(val0, val3) < 0 ? val2 + val3 : (compare.compare(val1, val2) < 0 ? val2 + val0 : val0 + val1);
                score[indexDst++] = s + middle[indexSrc];
                ++i;
                ++indexSrc;
            }
        }
    }

    @Override
    public ImageType<T> getInputType() {
        return this.scoreRows.getImageType();
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.disparitySelect0.getDisparityType();
    }

    @Override
    public int getMaxRegionError() {
        return 3 * this.regionWidth * this.regionHeight * this.getMaxPerPixelError();
    }

    @Override
    protected int getMaxPerPixelError() {
        return this.scoreRows.getMaxPerPixelError();
    }

    private class ComputeBlock
    implements IntRangeObjectConsumer<WorkSpace> {
        private ComputeBlock() {
        }

        public void accept(WorkSpace workspace, int minInclusive, int maxExclusive) {
            workspace.checkSize();
            int row0 = minInclusive - 2 * DisparityScoreBMBestFive_S32.this.radiusY;
            int row1 = maxExclusive + 2 * DisparityScoreBMBestFive_S32.this.radiusY;
            DisparityScoreBMBestFive_S32.this.computeFirstRow(row0, workspace);
            DisparityScoreBMBestFive_S32.this.computeRemainingRows(row0, row1, workspace);
        }
    }

    class WorkSpace {
        int[] elementScore;
        int[][] horizontalScore;
        int[][] verticalScore;
        int[][] verticalScoreNorm;
        int activeVerticalScore;
        int[] fiveScore;
        Object leftRow;
        Object rightRow;
        DisparitySelect<int[], DI> computeDisparity;

        WorkSpace() {
        }

        public void checkSize() {
            if (this.horizontalScore == null || this.verticalScore.length < DisparityScoreBMBestFive_S32.this.widthDisparityBlock) {
                this.horizontalScore = new int[DisparityScoreBMBestFive_S32.this.regionHeight][DisparityScoreBMBestFive_S32.this.widthDisparityBlock];
                this.verticalScore = new int[DisparityScoreBMBestFive_S32.this.regionHeight][DisparityScoreBMBestFive_S32.this.widthDisparityBlock];
                if (DisparityScoreBMBestFive_S32.this.scoreRows.isRequireNormalize()) {
                    this.verticalScoreNorm = new int[DisparityScoreBMBestFive_S32.this.regionHeight][DisparityScoreBMBestFive_S32.this.widthDisparityBlock];
                }
                this.elementScore = new int[((ImageBase)DisparityScoreBMBestFive_S32.this.left).width + 2 * DisparityScoreBMBestFive_S32.this.radiusX];
                this.fiveScore = new int[DisparityScoreBMBestFive_S32.this.widthDisparityBlock];
                this.leftRow = DisparityScoreBMBestFive_S32.this.left.getImageType().getDataType().newArray(this.elementScore.length);
                this.rightRow = DisparityScoreBMBestFive_S32.this.right.getImageType().getDataType().newArray(this.elementScore.length);
            }
            if (this.computeDisparity == null) {
                this.computeDisparity = DisparityScoreBMBestFive_S32.this.disparitySelect0.concurrentCopy();
            }
            this.computeDisparity.configure(DisparityScoreBMBestFive_S32.this.disparity, DisparityScoreBMBestFive_S32.this.disparityMin, DisparityScoreBMBestFive_S32.this.disparityMax, DisparityScoreBMBestFive_S32.this.radiusX * 2);
        }
    }
}

