/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block.score;

import boofcv.alg.disparity.DisparityBlockMatch;
import boofcv.alg.disparity.block.BlockRowScore;
import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import pabeles.concurrency.GrowArray;
import pabeles.concurrency.IntRangeObjectConsumer;

public class DisparityScoreBM_S32<T extends ImageBase<T>, DI extends ImageGray<DI>>
extends DisparityBlockMatch<T, DI> {
    DisparitySelect<int[], DI> disparitySelect0;
    BlockRowScore<T, int[], Object> scoreRows;
    T left;
    T right;
    DI disparity;
    GrowArray<WorkSpace> workspace = new GrowArray(() -> new WorkSpace());
    ComputeBlock computeBlock = new ComputeBlock();

    public DisparityScoreBM_S32(int regionRadiusX, int regionRadiusY, BlockRowScore<T, int[], Object> scoreRows, DisparitySelect<int[], DI> computeDisparity, ImageType<T> imageType) {
        super(regionRadiusX, regionRadiusY, imageType);
        this.scoreRows = scoreRows;
        this.disparitySelect0 = computeDisparity;
        this.workspace.grow();
    }

    @Override
    public void setBorder(ImageBorder<T> border) {
        super.setBorder(border);
        this.scoreRows.setBorder(border);
    }

    @Override
    public void _process(T left, T right, DI disparity) {
        this.left = left;
        this.right = right;
        this.disparity = disparity;
        this.growBorderL.setImage(left);
        this.growBorderR.setImage(right);
        this.scoreRows.setInput(left, right);
        if (BoofConcurrency.USE_CONCURRENT) {
            BoofConcurrency.loopBlocks((int)0, (int)((ImageBase)left).height, (int)this.regionHeight, this.workspace, (IntRangeObjectConsumer)this.computeBlock);
        } else {
            this.computeBlock.accept((WorkSpace)this.workspace.get(0), 0, ((ImageBase)left).height);
        }
    }

    private void computeFirstRow(int row0, WorkSpace ws) {
        int disparityMax = Math.min(((ImageBase)this.left).width, this.disparityMax);
        for (int row = 0; row < this.regionHeight; ++row) {
            this.growBorderL.growRow(row0 + row, this.radiusX, this.radiusX, ws.leftRow, 0);
            this.growBorderR.growRow(row0 + row, this.radiusX, this.radiusX, ws.rightRow, 0);
            int[] scores = ws.horizontalScore[row];
            this.scoreRows.scoreRow(row0 + row, ws.leftRow, ws.rightRow, scores, this.disparityMin, disparityMax, this.regionWidth, ws.elementScore);
        }
        for (int i = 0; i < this.widthDisparityBlock; ++i) {
            int sum = 0;
            for (int row = 0; row < this.regionHeight; ++row) {
                sum += ws.horizontalScore[row][i];
            }
            ws.verticalScore[i] = sum;
        }
        if (this.scoreRows.isRequireNormalize()) {
            this.scoreRows.normalizeRegionScores(row0 + this.radiusY, ws.verticalScore, this.disparityMin, disparityMax, this.regionWidth, this.regionHeight, ws.verticalScoreNorm);
            ws.computeDisparity.process(row0 + this.radiusY, ws.verticalScoreNorm);
        } else {
            ws.computeDisparity.process(row0 + this.radiusY, ws.verticalScore);
        }
    }

    private void computeRemainingRows(int row0, int row1, WorkSpace ws) {
        int disparityMax = Math.min(((ImageBase)this.left).width, this.disparityMax);
        for (int row = row0 + this.regionHeight; row < row1; ++row) {
            int i;
            int oldRow = (row - row0) % this.regionHeight;
            int[] scores = ws.horizontalScore[oldRow];
            for (i = 0; i < this.widthDisparityBlock; ++i) {
                int n = i;
                ws.verticalScore[n] = ws.verticalScore[n] - scores[i];
            }
            this.growBorderL.growRow(row, this.radiusX, this.radiusX, ws.leftRow, 0);
            this.growBorderR.growRow(row, this.radiusX, this.radiusX, ws.rightRow, 0);
            this.scoreRows.scoreRow(row, ws.leftRow, ws.rightRow, scores, this.disparityMin, disparityMax, this.regionWidth, ws.elementScore);
            for (i = 0; i < this.widthDisparityBlock; ++i) {
                int n = i;
                ws.verticalScore[n] = ws.verticalScore[n] + scores[i];
            }
            if (this.scoreRows.isRequireNormalize()) {
                this.scoreRows.normalizeRegionScores(row - this.regionHeight + 1 + this.radiusY, ws.verticalScore, this.disparityMin, disparityMax, this.regionWidth, this.regionHeight, ws.verticalScoreNorm);
                ws.computeDisparity.process(row - this.regionHeight + 1 + this.radiusY, ws.verticalScoreNorm);
                continue;
            }
            ws.computeDisparity.process(row - this.regionHeight + 1 + this.radiusY, ws.verticalScore);
        }
    }

    @Override
    public ImageType<T> getInputType() {
        return this.scoreRows.getImageType();
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.disparitySelect0.getDisparityType();
    }

    @Override
    protected int getMaxPerPixelError() {
        return this.scoreRows.getMaxPerPixelError();
    }

    public void setDisparitySelect0(DisparitySelect<int[], DI> disparitySelect0) {
        this.disparitySelect0 = disparitySelect0;
    }

    private class ComputeBlock
    implements IntRangeObjectConsumer<WorkSpace> {
        private ComputeBlock() {
        }

        public void accept(WorkSpace workspace, int minInclusive, int maxExclusive) {
            workspace.checkSize();
            int row0 = minInclusive - DisparityScoreBM_S32.this.radiusY;
            int row1 = maxExclusive + DisparityScoreBM_S32.this.radiusY;
            DisparityScoreBM_S32.this.computeFirstRow(row0, workspace);
            DisparityScoreBM_S32.this.computeRemainingRows(row0, row1, workspace);
        }
    }

    class WorkSpace {
        int[] elementScore;
        int[][] horizontalScore = new int[0][0];
        int[] verticalScore = new int[0];
        int[] verticalScoreNorm = new int[0];
        Object leftRow;
        Object rightRow;
        DisparitySelect<int[], DI> computeDisparity;

        WorkSpace() {
        }

        public void checkSize() {
            if (this.horizontalScore.length != DisparityScoreBM_S32.this.regionHeight || this.horizontalScore[0].length != DisparityScoreBM_S32.this.widthDisparityBlock) {
                this.horizontalScore = new int[DisparityScoreBM_S32.this.regionHeight][DisparityScoreBM_S32.this.widthDisparityBlock];
                this.verticalScore = new int[DisparityScoreBM_S32.this.widthDisparityBlock];
                if (DisparityScoreBM_S32.this.scoreRows.isRequireNormalize()) {
                    this.verticalScoreNorm = new int[DisparityScoreBM_S32.this.widthDisparityBlock];
                }
                this.elementScore = new int[((ImageBase)DisparityScoreBM_S32.this.left).width + 2 * DisparityScoreBM_S32.this.radiusX];
                this.leftRow = DisparityScoreBM_S32.this.left.getImageType().getDataType().newArray(this.elementScore.length);
                this.rightRow = DisparityScoreBM_S32.this.right.getImageType().getDataType().newArray(this.elementScore.length);
            }
            if (this.computeDisparity == null) {
                this.computeDisparity = DisparityScoreBM_S32.this.disparitySelect0.concurrentCopy();
            }
            this.computeDisparity.configure(DisparityScoreBM_S32.this.disparity, DisparityScoreBM_S32.this.disparityMin, DisparityScoreBM_S32.this.disparityMax, DisparityScoreBM_S32.this.radiusX);
        }
    }
}

