/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.abst.disparity.DisparitySmoother;
import boofcv.abst.disparity.StereoDisparity;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyDistortImageOps;
import boofcv.alg.mvs.BundleToRectificationStereoParameters;
import boofcv.alg.mvs.DisparityParameters;
import boofcv.alg.mvs.MultiBaselineDisparityMedian;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.LookUpImages;
import boofcv.struct.border.BorderType;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class MultiBaselineStereoIndependent<Image extends ImageGray<Image>>
implements VerbosePrint {
    @Nullable
    private Listener<Image> listener;
    @Nullable
    StereoDisparity<Image, GrayF32> stereoDisparity = null;
    @Nullable
    DisparitySmoother<Image, GrayF32> disparitySmoother = null;
    @Nullable
    LookUpImages lookUpImages = null;
    double timeDisparity;
    double timeDisparitySmooth;
    double timeLookUpImages;
    double timeTotal;
    private SceneStructureMetric scene;
    final GrayF32 fusedDisparity = new GrayF32(1, 1);
    final DisparityParameters fusedParam = new DisparityParameters();
    final StereoResults results = new StereoResults();
    MultiBaselineDisparityMedian performFusion = new MultiBaselineDisparityMedian();
    Image image1;
    Image image2;
    Image rectified1;
    Image rectified2;
    BundleToRectificationStereoParameters computeRectification = new BundleToRectificationStereoParameters();
    final Se3_F64 left_to_world = new Se3_F64();
    final Se3_F64 left_to_right = new Se3_F64();
    final Se3_F64 world_to_left = new Se3_F64();
    final Se3_F64 world_to_right = new Se3_F64();
    final Se3_F64 tmpse3 = new Se3_F64();
    @Nullable
    PrintStream verbose = null;
    @Nullable
    PrintStream verboseProfiling = null;

    public MultiBaselineStereoIndependent(LookUpImages lookUpImages, ImageType<Image> imageType) {
        this(imageType);
        this.lookUpImages = lookUpImages;
    }

    public MultiBaselineStereoIndependent(ImageType<Image> imageType) {
        this.rectified1 = (ImageGray)imageType.createImage(1, 1);
        this.rectified2 = (ImageGray)imageType.createImage(1, 1);
        this.image1 = (ImageGray)imageType.createImage(1, 1);
        this.image2 = (ImageGray)imageType.createImage(1, 1);
    }

    public boolean process(SceneStructureMetric scene, int targetIdx, DogArray_I32 pairIdxs, BoofLambdas.IndexToString sbaIndexToViewID) {
        this.timeDisparity = 0.0;
        this.timeDisparitySmooth = 0.0;
        this.timeTotal = 0.0;
        this.timeLookUpImages = 0.0;
        long time0 = System.nanoTime();
        Objects.requireNonNull(this.stereoDisparity, "stereoDisparity must be configured");
        Objects.requireNonNull(this.lookUpImages, "lookUpImages must be configured");
        this.scene = scene;
        if (!this.lookUpImages.loadImage(sbaIndexToViewID.process(targetIdx), this.image1)) {
            if (this.verbose != null) {
                this.verbose.println("Failed to load center image[" + targetIdx + "]");
            }
            return false;
        }
        long time1 = System.nanoTime();
        this.timeLookUpImages += (double)(time1 - time0) * 1.0E-6;
        int targetCamera = ((SceneStructureMetric.View)scene.views.get((int)targetIdx)).camera;
        this.computeRectification.setView1(((SceneStructureCommon.Camera)scene.cameras.get((int)targetCamera)).model, ((ImageGray)this.image1).width, ((ImageGray)this.image1).height);
        scene.getWorldToView((SceneStructureMetric.View)scene.views.get(targetIdx), this.world_to_left, this.tmpse3);
        this.world_to_left.invert(this.left_to_world);
        this.performFusion.initialize((CameraPinhole)this.computeRectification.intrinsic1, this.computeRectification.view1_dist_to_undist);
        for (int i = 0; i < pairIdxs.size; ++i) {
            if (!this.computeDisparity(this.image1, pairIdxs.get(i), sbaIndexToViewID.process(pairIdxs.get(i)), this.results)) {
                if (this.verbose == null) continue;
                this.verbose.println("FAILED: disparity view.idx=" + pairIdxs.get(i));
                continue;
            }
            if (this.listener != null) {
                this.listener.handlePairDisparity(targetIdx, pairIdxs.get(i), this.rectified1, this.rectified2, this.results.disparity, this.results.mask, this.results.param, this.results.undist_to_rect1);
            }
            this.performFusion.addDisparity(this.results.disparity, this.results.mask, this.results.param, this.results.undist_to_rect1);
        }
        if (this.verbose != null) {
            this.verbose.println("Created fused stereo disparity image. inputs.size=" + pairIdxs.size);
        }
        if (!this.performFusion.process(this.fusedDisparity)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: Can't fuse disparity images");
            }
            return false;
        }
        this.fusedParam.disparityMin = this.performFusion.getFusedDisparityMin();
        this.fusedParam.disparityRange = this.performFusion.getFusedDisparityRange();
        this.fusedParam.pinhole.setTo((CameraPinhole)this.computeRectification.intrinsic1);
        this.fusedParam.baseline = this.performFusion.getFusedBaseline();
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.fusedParam.rotateToRectified);
        this.filterDisparity(this.image1, this.fusedDisparity, this.fusedParam);
        this.timeTotal = (double)(System.nanoTime() - time0) * 1.0E-6;
        if (this.verboseProfiling != null) {
            this.verboseProfiling.printf("Timing (ms), disp=%5.1f smooth=%5.1f lookup=%5.1f all=%5.1f, count=%d view='%s'\n", this.timeDisparity, this.timeDisparitySmooth, this.timeLookUpImages, this.timeTotal, pairIdxs.size, sbaIndexToViewID.process(targetIdx));
        }
        return true;
    }

    private boolean computeDisparity(Image image1, int rightIdx, String rightID, StereoResults info) {
        long time0 = System.nanoTime();
        if (!Objects.requireNonNull(this.lookUpImages).loadImage(rightID, this.image2)) {
            if (this.verbose != null) {
                this.verbose.println("Failed to load second image[" + rightIdx + "]");
            }
            return false;
        }
        long time1 = System.nanoTime();
        this.timeLookUpImages += (double)(time1 - time0) * 1.0E-6;
        int rightCamera = ((SceneStructureMetric.View)this.scene.views.get((int)rightIdx)).camera;
        this.scene.getWorldToView((SceneStructureMetric.View)this.scene.views.get(rightIdx), this.world_to_right, this.tmpse3);
        this.left_to_world.concat(this.world_to_right, this.left_to_right);
        this.computeRectification.processView2(((SceneStructureCommon.Camera)this.scene.cameras.get((int)rightCamera)).model, this.image2.getWidth(), this.image2.getHeight(), this.left_to_right);
        info.param.rotateToRectified.setTo((DMatrixD1)this.computeRectification.rotate_orig_to_rect);
        info.undist_to_rect1.setTo((DMatrixD1)this.computeRectification.undist_to_rect1);
        info.rectifiedK.setTo((DMatrixD1)this.computeRectification.rectifiedK);
        ImageDistort distortLeft = RectifyDistortImageOps.rectifyImage(this.computeRectification.intrinsic1, this.computeRectification.undist_to_rect1_F32, BorderType.EXTENDED, image1.getImageType());
        ImageDistort distortRight = RectifyDistortImageOps.rectifyImage(this.computeRectification.intrinsic2, this.computeRectification.undist_to_rect2_F32, BorderType.EXTENDED, this.image2.getImageType());
        ImageDimension rectifiedShape = this.computeRectification.rectifiedShape;
        info.mask.reshape(rectifiedShape.width, rectifiedShape.height);
        this.rectified1.reshape(rectifiedShape.width, rectifiedShape.height);
        this.rectified2.reshape(rectifiedShape.width, rectifiedShape.height);
        distortLeft.apply(image1, this.rectified1, info.mask);
        distortRight.apply(this.image2, this.rectified2);
        Objects.requireNonNull(this.stereoDisparity).process(this.rectified1, this.rectified2);
        info.disparity = this.stereoDisparity.getDisparity();
        DisparityParameters param = info.param;
        param.disparityMin = this.stereoDisparity.getDisparityMin();
        param.disparityRange = this.stereoDisparity.getDisparityRange();
        param.baseline = this.left_to_right.T.norm();
        PerspectiveOps.matrixToPinhole((DMatrixRMaj)info.rectifiedK, (int)rectifiedShape.width, (int)rectifiedShape.height, (CameraPinhole)param.pinhole);
        long time2 = System.nanoTime();
        this.timeDisparity += (double)(time2 - time1) * 1.0E-6;
        this.filterDisparity(this.rectified1, info.disparity, info.param);
        return true;
    }

    private void filterDisparity(Image left, GrayF32 disparity, DisparityParameters param) {
        long time0 = System.nanoTime();
        if (this.disparitySmoother != null) {
            this.disparitySmoother.process(left, disparity, param.disparityRange);
        }
        this.timeDisparitySmooth += (double)(System.nanoTime() - time0) * 1.0E-6;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)out, configuration, (VerbosePrint[])new VerbosePrint[]{this.performFusion});
        this.verboseProfiling = null;
        if (configuration != null && configuration.contains("runtime")) {
            this.verboseProfiling = out;
        }
    }

    @Nullable
    public Listener<Image> getListener() {
        return this.listener;
    }

    public void setListener(@Nullable Listener<Image> listener) {
        this.listener = listener;
    }

    @Nullable
    public StereoDisparity<Image, GrayF32> getStereoDisparity() {
        return this.stereoDisparity;
    }

    public void setStereoDisparity(@Nullable StereoDisparity<Image, GrayF32> stereoDisparity) {
        this.stereoDisparity = stereoDisparity;
    }

    @Nullable
    public DisparitySmoother<Image, GrayF32> getDisparitySmoother() {
        return this.disparitySmoother;
    }

    public void setDisparitySmoother(@Nullable DisparitySmoother<Image, GrayF32> disparitySmoother) {
        this.disparitySmoother = disparitySmoother;
    }

    @Nullable
    public LookUpImages getLookUpImages() {
        return this.lookUpImages;
    }

    public void setLookUpImages(@Nullable LookUpImages lookUpImages) {
        this.lookUpImages = lookUpImages;
    }

    public double getTimeDisparity() {
        return this.timeDisparity;
    }

    public double getTimeDisparitySmooth() {
        return this.timeDisparitySmooth;
    }

    public double getTimeLookUpImages() {
        return this.timeLookUpImages;
    }

    public double getTimeTotal() {
        return this.timeTotal;
    }

    public GrayF32 getFusedDisparity() {
        return this.fusedDisparity;
    }

    public DisparityParameters getFusedParam() {
        return this.fusedParam;
    }

    @Nullable
    public PrintStream getVerboseProfiling() {
        return this.verboseProfiling;
    }

    public void setVerboseProfiling(@Nullable PrintStream verboseProfiling) {
        this.verboseProfiling = verboseProfiling;
    }

    static class StereoResults {
        GrayF32 disparity;
        final GrayU8 mask = new GrayU8(1, 1);
        final DisparityParameters param = new DisparityParameters();
        final DMatrixRMaj undist_to_rect1 = new DMatrixRMaj(3, 3);
        final DMatrixRMaj rectifiedK = new DMatrixRMaj(3, 3);

        StereoResults() {
        }
    }

    public static interface Listener<RectImage> {
        public void handlePairDisparity(int var1, int var2, RectImage var3, RectImage var4, GrayF32 var5, GrayU8 var6, DisparityParameters var7, DMatrixRMaj var8);
    }
}

