/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block;

import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import org.jetbrains.annotations.Nullable;

public abstract class SelectDisparityWithChecksWta<Array, DI extends ImageGray<DI>>
implements DisparitySelect<Array, DI> {
    public static final int DISCRETIZER = 10000;
    protected DI imageDisparity;
    @Nullable
    protected GrayF32 imageScore;
    protected int disparityMin;
    protected int disparityMax;
    protected int disparityRange;
    protected int invalidDisparity;
    protected int localRange;
    protected int radiusX;
    protected int regionWidth;
    protected int maxError;
    protected int rightToLeftTolerance;
    protected Class<DI> disparityType;
    protected SaveScore funcSaveScore = (index, value) -> {};

    protected SelectDisparityWithChecksWta(int maxError, int rightToLeftTolerance, double texture, Class<DI> disparityType) {
        this.maxError = maxError <= 0 ? Integer.MAX_VALUE : maxError;
        this.rightToLeftTolerance = rightToLeftTolerance;
        this.disparityType = disparityType;
        this.setTexture(texture);
    }

    public abstract void setTexture(double var1);

    @Override
    public void configure(DI imageDisparity, @Nullable GrayF32 imageScore, int disparityMin, int disparityMax, int radiusX) {
        this.imageDisparity = imageDisparity;
        this.imageScore = imageScore;
        this.disparityMin = disparityMin;
        this.disparityMax = disparityMax;
        this.radiusX = radiusX;
        this.disparityRange = disparityMax - disparityMin + 1;
        this.regionWidth = radiusX * 2 + 1;
        this.invalidDisparity = this.disparityRange;
        if (this.invalidDisparity > (int)imageDisparity.getDataType().getMaxValue() - 1) {
            throw new IllegalArgumentException("Max range exceeds maximum value in disparity image. v=" + this.invalidDisparity);
        }
        this.funcSaveScore = imageScore != null ? (index, value) -> {
            imageScore.data[index] = value;
        } : (index, value) -> {};
    }

    protected abstract void setDisparity(int var1, int var2, float var3);

    protected abstract void setDisparityInvalid(int var1);

    protected int disparityMaxAtColumnL2R(int col) {
        return Math.min(col, this.disparityMax);
    }

    public void setLocalDisparityMax(int value) {
        this.localRange = value;
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.disparityType;
    }

    @FunctionalInterface
    public static interface SaveScore {
        public void saveScore(int var1, float var2);
    }
}

