/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block;

import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.disparity.block.BlockRowScore;
import boofcv.alg.misc.GPixelMath;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import org.ejml.UtilEjml;

public class BlockRowScoreNcc<T extends ImageBase<T>> {
    T meanL;
    T meanR;
    T powL;
    T powR;
    T stdevL;
    T stdevR;
    T tmpPow2;
    BlurStorageFilter<T> meanFilter;

    public BlockRowScoreNcc(int radiusX, int radiusY, ImageType<T> imageType) {
        this.meanL = imageType.createImage(1, 1);
        this.meanR = imageType.createImage(1, 1);
        this.powL = imageType.createImage(1, 1);
        this.powR = imageType.createImage(1, 1);
        this.meanFilter = FactoryBlurFilter.meanB(imageType, (int)radiusX, (int)radiusY, null);
        this.tmpPow2 = this.meanL;
        this.stdevL = this.powL;
        this.stdevR = this.powR;
    }

    public void setBorder(ImageBorder<T> border) {
        this.meanFilter.setBorder(border.copy());
    }

    public void computeStatistics(T left, T right) {
        GPixelMath.pow2(left, this.tmpPow2);
        this.meanFilter.process(this.tmpPow2, this.powL);
        GPixelMath.pow2(right, this.tmpPow2);
        this.meanFilter.process(this.tmpPow2, this.powR);
        this.meanFilter.process(left, this.meanL);
        this.meanFilter.process(right, this.meanR);
        GPixelMath.stdev(this.meanL, this.powL, this.stdevL);
        GPixelMath.stdev(this.meanR, this.powR, this.stdevR);
    }

    public static class F32
    extends BlockRowScore.ArrayS32_BF32 {
        BlockRowScoreNcc<GrayF32> helper;
        public float eps = UtilEjml.F_EPS;

        public F32(int radiusWidth, int radiusHeight) {
            this.helper = new BlockRowScoreNcc(radiusWidth, radiusHeight, ImageType.single(GrayF32.class));
        }

        @Override
        public void setInput(GrayF32 left, GrayF32 right) {
            super.setInput(left, right);
            this.helper.computeStatistics(left, right);
        }

        @Override
        public void setBorder(ImageBorder<GrayF32> border) {
            super.setBorder(border);
            this.helper.setBorder(border);
        }

        @Override
        public void score(float[] leftRow, float[] rightRow, int indexLeft, int indexRight, int offset, int length, float[] elementScore) {
            for (int i = 0; i < length; ++i) {
                elementScore[offset + i] = leftRow[indexLeft++] * rightRow[indexRight++];
            }
        }

        @Override
        public int getMaxPerPixelError() {
            throw new RuntimeException("There is no maximum error for NCC");
        }

        @Override
        public boolean isRequireNormalize() {
            return true;
        }

        @Override
        public void normalizeScore(int row, int colLeft, int colRight, int numCols, int regionWidth, int regionHeight, float[] scores, int indexScores, float[] scoresNorm) {
            float area = regionWidth * regionHeight;
            if (row < 0 || row >= ((GrayF32)this.left).height) {
                throw new IllegalArgumentException("Egads. row=" + row);
            }
            int stride = ((GrayF32)this.helper.meanL).stride;
            int idxLeft = row * stride + colLeft;
            int idxRight = row * stride + colRight;
            int i = 0;
            while (i < numCols) {
                float correlation = scores[indexScores + i] / area;
                float meanL = ((GrayF32)this.helper.meanL).data[idxLeft];
                float meanR = ((GrayF32)this.helper.meanR).data[idxRight];
                float sigmaL = ((GrayF32)this.helper.stdevL).data[idxLeft];
                float sigmaR = ((GrayF32)this.helper.stdevR).data[idxRight];
                scoresNorm[indexScores + i] = (correlation - meanL * meanR) / (this.eps + sigmaL * sigmaR);
                ++i;
                ++idxLeft;
                ++idxRight;
            }
        }

        @Override
        public ImageType<GrayF32> getImageType() {
            return ((GrayF32)this.helper.meanL).getImageType();
        }
    }
}

