/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;

public class RectifyDistortImageOps {
    public static <T extends ImageGray<T>> ImageDistort<T, T> rectifyImage(FMatrixRMaj rectify, BorderType borderType, Class<T> imageType) {
        boolean skip;
        boolean bl = skip = borderType == BorderType.SKIP;
        if (skip) {
            borderType = BorderType.EXTENDED;
        }
        InterpolatePixelS interp = FactoryInterpolation.bilinearPixelS(imageType, (BorderType)borderType);
        FMatrixRMaj rectifyInv = new FMatrixRMaj(3, 3);
        CommonOps_FDRM.invert((FMatrixRMaj)rectify, (FMatrixRMaj)rectifyInv);
        PointTransformHomography_F32 rectifyTran = new PointTransformHomography_F32(rectifyInv);
        ImageDistort ret = FactoryDistort.distortSB((boolean)false, (InterpolatePixelS)interp, imageType);
        ret.setRenderAll(!skip);
        ret.setModel((PixelTransform)new PointToPixelTransform_F32((Point2Transform2_F32)rectifyTran));
        return ret;
    }

    public static <T extends ImageBase<T>> ImageDistort<T, T> rectifyImage(CameraPinholeBrown param, FMatrixRMaj rectify, BorderType borderType, ImageType<T> imageType) {
        boolean skip;
        boolean bl = skip = borderType == BorderType.SKIP;
        if (skip) {
            borderType = BorderType.EXTENDED;
        }
        InterpolatePixel interp = FactoryInterpolation.createPixel((double)0.0, (double)255.0, (InterpolationType)InterpolationType.BILINEAR, (BorderType)borderType, imageType);
        ImageDistort ret = FactoryDistort.distort((boolean)true, (InterpolatePixel)interp, imageType);
        ret.setRenderAll(!skip);
        Point2Transform2_F32 transform = RectifyImageOps.transformRectToPixel((CameraPinholeBrown)param, (FMatrixRMaj)rectify);
        ret.setModel((PixelTransform)new PointToPixelTransform_F32(transform));
        return ret;
    }

    public static void applyMask(GrayF32 disparity, GrayU8 mask, int radius) {
        if (disparity.isSubimage() || mask.isSubimage()) {
            throw new RuntimeException("Input is subimage. Currently not support but no reason why it can't be. Ask for it");
        }
        int N = disparity.width * disparity.height;
        for (int i = 0; i < N; ++i) {
            if (mask.data[i] != 0) continue;
            disparity.data[i] = 255.0f;
        }
        if (radius > 0) {
            int r;
            for (int y = r = radius; y < mask.height - r - 1; ++y) {
                int indexMsk = y * mask.stride + r;
                int x = r;
                while (x < mask.width - r - 1) {
                    int deltaX = mask.data[indexMsk] - mask.data[indexMsk + 1];
                    int deltaY = mask.data[indexMsk] - mask.data[indexMsk + mask.stride];
                    if (deltaX != 0 || deltaY != 0) {
                        if (deltaX < 0) {
                            deltaX = 0;
                        }
                        if (deltaY < 0) {
                            deltaY = 0;
                        }
                        for (int i = -r; i <= r; ++i) {
                            for (int j = -r; j <= r; ++j) {
                                disparity.set(deltaX + x + j, deltaY + y + i, 255.0f);
                            }
                        }
                    }
                    ++x;
                    ++indexMsk;
                }
            }
        }
    }

    public static void applyMask(GrayU8 disparity, GrayU8 mask, int radius) {
        if (disparity.isSubimage() || mask.isSubimage()) {
            throw new RuntimeException("Input is subimage. Currently not support but no reason why it can't be. Ask for it");
        }
        int N = disparity.width * disparity.height;
        for (int i = 0; i < N; ++i) {
            if (mask.data[i] != 0) continue;
            disparity.data[i] = -1;
        }
        if (radius > 0) {
            int r;
            for (int y = r = radius; y < mask.height - r - 1; ++y) {
                int indexMsk = y * mask.stride + r;
                int x = r;
                while (x < mask.width - r - 1) {
                    int deltaX = mask.data[indexMsk] - mask.data[indexMsk + 1];
                    int deltaY = mask.data[indexMsk] - mask.data[indexMsk + mask.stride];
                    if (deltaX != 0 || deltaY != 0) {
                        if (deltaX < 0) {
                            deltaX = 0;
                        }
                        if (deltaY < 0) {
                            deltaY = 0;
                        }
                        for (int i = -r; i <= r; ++i) {
                            for (int j = -r; j <= r; ++j) {
                                disparity.set(deltaX + x + j, deltaY + y + i, 255);
                            }
                        }
                    }
                    ++x;
                    ++indexMsk;
                }
            }
        }
    }
}

