/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class GlobalOtsuBinaryFilter<T extends ImageGray<T>>
implements InputToBinary<T> {
    ImageType<T> inputType;
    boolean down;
    int minValue;
    int maxValue;

    public GlobalOtsuBinaryFilter(int minValue, int maxValue, boolean down, ImageType<T> inputType) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.down = down;
        this.inputType = inputType;
    }

    @Override
    public void process(T input, GrayU8 output) {
        double threshold = GThresholdImageOps.computeOtsu(input, this.minValue, this.maxValue);
        GThresholdImageOps.threshold(input, output, threshold, this.down);
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }

    @Override
    public ImageType<GrayU8> getOutputType() {
        return ImageType.single(GrayU8.class);
    }
}

