/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class LocalGaussianBinaryFilter<T extends ImageGray<T>>
implements InputToBinary<T> {
    ImageType<T> inputType;
    T work1;
    ImageGray work2;
    int radius;
    double scale;
    boolean down;

    public LocalGaussianBinaryFilter(int radius, double scale, boolean down, ImageType<T> inputType) {
        this.radius = radius;
        this.scale = scale;
        this.down = down;
        this.inputType = inputType;
        this.work1 = (ImageGray)inputType.createImage(1, 1);
        this.work2 = (ImageGray)inputType.createImage(1, 1);
    }

    @Override
    public void process(T input, GrayU8 output) {
        ((ImageGray)this.work1).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.work2.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        GThresholdImageOps.localGaussian(input, output, this.radius, this.scale, this.down, this.work1, this.work2);
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }

    @Override
    public ImageType<GrayU8> getOutputType() {
        return ImageType.single(GrayU8.class);
    }
}

