/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.impl.ThresholdSauvola;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class LocalSauvolaBinaryFilter<T extends ImageGray<T>>
implements InputToBinary<T> {
    ImageType<T> inputType;
    ThresholdSauvola alg;
    GrayF32 input;

    public LocalSauvolaBinaryFilter(int radius, float k, boolean down, ImageType<T> inputType) {
        this.inputType = inputType;
        if (inputType.getDataType() != ImageDataType.F32) {
            this.input = new GrayF32(1, 1);
        }
        this.alg = new ThresholdSauvola(radius, k, down);
    }

    @Override
    public void process(T input, GrayU8 output) {
        if (this.input == null) {
            this.alg.process((GrayF32)input, output);
        } else {
            this.input.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            GConvertImage.convert(input, this.input);
            this.alg.process(this.input, output);
        }
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }

    @Override
    public ImageType<GrayU8> getOutputType() {
        return ImageType.single(GrayU8.class);
    }
}

