/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.ThresholdSquareBlockMinMax;
import boofcv.alg.filter.binary.impl.ThresholdSquareBlockMinMax_F32;
import boofcv.alg.filter.binary.impl.ThresholdSquareBlockMinMax_U8;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class LocalSquareBlockMinMaxBinaryFilter<T extends ImageGray<T>>
implements InputToBinary<T> {
    ThresholdSquareBlockMinMax alg;
    ImageType<T> imageType;

    public LocalSquareBlockMinMaxBinaryFilter(double minimumSpread, int requestedBlockWidth, double scale, boolean down, Class<T> imageType) {
        if (imageType == GrayF32.class) {
            this.alg = new ThresholdSquareBlockMinMax_F32((float)minimumSpread, requestedBlockWidth, (float)scale, down);
        } else if (imageType == GrayU8.class) {
            this.alg = new ThresholdSquareBlockMinMax_U8(minimumSpread, requestedBlockWidth, scale, down);
        } else {
            throw new IllegalArgumentException("Unsupported image type");
        }
        this.imageType = ImageType.single(imageType);
    }

    @Override
    public void process(T input, GrayU8 output) {
        this.alg.process(input, output);
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.imageType;
    }

    @Override
    public ImageType<GrayU8> getOutputType() {
        return ImageType.single(GrayU8.class);
    }
}

