/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.enhance;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.enhance.impl.ImplEnhanceFilter;
import boofcv.alg.enhance.impl.ImplEnhanceHistogram;
import boofcv.alg.misc.ImageStatistics;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class EnhanceImageOps {
    public static void equalize(int[] histogram, int[] transform) {
        int sum = 0;
        for (int i = 0; i < histogram.length; ++i) {
            transform[i] = sum += histogram[i];
        }
        int maxValue = histogram.length - 1;
        for (int i = 0; i < histogram.length; ++i) {
            transform[i] = transform[i] * maxValue / sum;
        }
    }

    public static void applyTransform(GrayU8 input, int[] transform, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceHistogram.applyTransform(input, transform, output);
    }

    public static void applyTransform(GrayU16 input, int[] transform, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceHistogram.applyTransform(input, transform, output);
    }

    public static void applyTransform(GrayS8 input, int[] transform, int minValue, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceHistogram.applyTransform(input, transform, minValue, output);
    }

    public static void applyTransform(GrayS16 input, int[] transform, int minValue, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceHistogram.applyTransform(input, transform, minValue, output);
    }

    public static void applyTransform(GrayS32 input, int[] transform, int minValue, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceHistogram.applyTransform(input, transform, minValue, output);
    }

    public static void equalizeLocal(GrayU8 input, int radius, GrayU8 output, int[] histogram, int[] transform) {
        InputSanityCheck.checkSameShape(input, output);
        int width = radius * 2 + 1;
        if (input.width >= width && input.height >= width) {
            ImplEnhanceHistogram.equalizeLocalInner(input, radius, output, histogram);
            ImplEnhanceHistogram.equalizeLocalRow(input, radius, 0, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalRow(input, radius, input.height - radius, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalCol(input, radius, 0, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalCol(input, radius, input.width - radius, output, histogram, transform);
        } else if (input.width < width && input.height < width) {
            ImageStatistics.histogram(input, 0, histogram);
            EnhanceImageOps.equalize(histogram, transform);
            EnhanceImageOps.applyTransform(input, transform, output);
        } else {
            ImplEnhanceHistogram.equalizeLocalNaive(input, radius, output, transform);
        }
    }

    public static void equalizeLocal(GrayU16 input, int radius, GrayU16 output, int[] histogram, int[] transform) {
        InputSanityCheck.checkSameShape(input, output);
        int width = radius * 2 + 1;
        if (input.width >= width && input.height >= width) {
            ImplEnhanceHistogram.equalizeLocalInner(input, radius, output, histogram);
            ImplEnhanceHistogram.equalizeLocalRow(input, radius, 0, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalRow(input, radius, input.height - radius, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalCol(input, radius, 0, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalCol(input, radius, input.width - radius, output, histogram, transform);
        } else if (input.width < width && input.height < width) {
            ImageStatistics.histogram(input, 0, histogram);
            EnhanceImageOps.equalize(histogram, transform);
            EnhanceImageOps.applyTransform(input, transform, output);
        } else {
            ImplEnhanceHistogram.equalizeLocalNaive(input, radius, output, transform);
        }
    }

    public static void sharpen4(GrayU8 input, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceFilter.sharpenInner4(input, output, 0, 255);
        ImplEnhanceFilter.sharpenBorder4(input, output, 0, 255);
    }

    public static void sharpen4(GrayF32 input, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceFilter.sharpenInner4(input, output, 0.0f, 255.0f);
        ImplEnhanceFilter.sharpenBorder4(input, output, 0.0f, 255.0f);
    }

    public static void sharpen8(GrayU8 input, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceFilter.sharpenInner8(input, output, 0, 255);
        ImplEnhanceFilter.sharpenBorder8(input, output, 0, 255);
    }

    public static void sharpen8(GrayF32 input, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceFilter.sharpenInner8(input, output, 0.0f, 255.0f);
        ImplEnhanceFilter.sharpenBorder8(input, output, 0.0f, 255.0f);
    }
}

