/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.abst.filter.binary.LocalSquareBlockMinMaxBinaryFilter;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.filter.binary.impl.ThresholdSauvola;
import boofcv.alg.misc.GImageStatistics;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class GThresholdImageOps {
    public static int computeOtsu(ImageGray input, int minValue, int maxValue) {
        int range = 1 + maxValue - minValue;
        int[] histogram = new int[range];
        GImageStatistics.histogram(input, minValue, histogram);
        int total = input.width * input.height;
        return GThresholdImageOps.computeOtsu(histogram, range, total) + minValue;
    }

    public static int computeOtsu(int[] histogram, int length, int totalPixels) {
        double dlength = length;
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += (double)i / dlength * (double)histogram[i];
        }
        double sumB = 0.0;
        int wB = 0;
        double varMax = 0.0;
        int threshold = 0;
        for (int i = 0; i < length; ++i) {
            double mF;
            double varBetween;
            if ((wB += histogram[i]) == 0) continue;
            int wF = totalPixels - wB;
            if (wF == 0) break;
            double mB = (sumB += (double)i / dlength * (double)histogram[i]) / (double)wB;
            if (!((varBetween = (double)wB * (double)wF * (mB - (mF = (sum - sumB) / (double)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = i;
        }
        return threshold;
    }

    public static int computeEntropy(ImageGray input, int minValue, int maxValue) {
        int range = 1 + maxValue - minValue;
        int[] histogram = new int[range];
        GImageStatistics.histogram(input, minValue, histogram);
        int total = input.width * input.height;
        return GThresholdImageOps.computeEntropy(histogram, range, total) + minValue;
    }

    public static int computeEntropy(int[] histogram, int length, int totalPixels) {
        double[] p = new double[length];
        for (int i = 0; i < length; ++i) {
            int h = histogram[i];
            if (h == 0) {
                p[i] = 0.0;
                continue;
            }
            p[i] = (double)h / (double)totalPixels;
            int n = i;
            p[n] = p[n] * Math.log(p[i]);
        }
        double bestScore = 0.0;
        int bestIndex = 0;
        int countF = 0;
        for (int i = 0; i < length; ++i) {
            double sumF = (double)(countF += histogram[i]) / (double)totalPixels;
            if (sumF == 0.0 || sumF == 1.0) continue;
            double sumB = 1.0 - sumF;
            double HA = 0.0;
            for (int j = 0; j <= i; ++j) {
                HA += p[j];
            }
            HA /= sumF;
            double HB = 0.0;
            for (int j = i + 1; j < length; ++j) {
                HB += p[j];
            }
            HB /= sumB;
            double entropy = Math.log(sumF) + Math.log(sumB) - HA - HB;
            if (!(entropy > bestScore)) continue;
            bestScore = entropy;
            bestIndex = i;
        }
        return bestIndex;
    }

    public static <T extends ImageGray<T>> GrayU8 threshold(T input, GrayU8 output, double threshold, boolean down) {
        if (input instanceof GrayF32) {
            return ThresholdImageOps.threshold((GrayF32)input, output, (float)threshold, down);
        }
        if (input instanceof GrayU8) {
            return ThresholdImageOps.threshold((GrayU8)input, output, (int)threshold, down);
        }
        if (input instanceof GrayU16) {
            return ThresholdImageOps.threshold((GrayU16)input, output, (int)threshold, down);
        }
        if (input instanceof GrayS16) {
            return ThresholdImageOps.threshold((GrayS16)input, output, (int)threshold, down);
        }
        if (input instanceof GrayS32) {
            return ThresholdImageOps.threshold((GrayS32)input, output, (int)threshold, down);
        }
        if (input instanceof GrayF64) {
            return ThresholdImageOps.threshold((GrayF64)input, output, threshold, down);
        }
        throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
    }

    public static <T extends ImageGray<T>> GrayU8 localSquare(T input, GrayU8 output, int radius, double scale, boolean down, T work1, T work2) {
        if (input instanceof GrayF32) {
            return ThresholdImageOps.localSquare((GrayF32)input, output, radius, (float)scale, down, (GrayF32)work1, (GrayF32)work2);
        }
        if (input instanceof GrayU8) {
            return ThresholdImageOps.localSquare((GrayU8)input, output, radius, (float)scale, down, (GrayU8)work1, (GrayU8)work2);
        }
        throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
    }

    public static <T extends ImageGray<T>> GrayU8 localGaussian(T input, GrayU8 output, int radius, double scale, boolean down, T work1, ImageGray work2) {
        if (input instanceof GrayF32) {
            return ThresholdImageOps.localGaussian((GrayF32)input, output, radius, (float)scale, down, (GrayF32)work1, (GrayF32)work2);
        }
        if (input instanceof GrayU8) {
            return ThresholdImageOps.localGaussian((GrayU8)input, output, radius, (float)scale, down, (GrayU8)work1, (GrayU8)work2);
        }
        throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
    }

    public static <T extends ImageGray<T>> GrayU8 localSauvola(T input, GrayU8 output, int radius, float k, boolean down) {
        ThresholdSauvola alg = new ThresholdSauvola(radius, k, down);
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        }
        if (input instanceof GrayF32) {
            alg.process((GrayF32)input, output);
        } else {
            GrayF32 conv = new GrayF32(input.width, input.height);
            GConvertImage.convert(input, conv);
            alg.process(conv, output);
        }
        return output;
    }

    public static <T extends ImageGray<T>> GrayU8 localBlockMinMax(T input, GrayU8 output, int radius, double scale, boolean down, double textureThreshold) {
        LocalSquareBlockMinMaxBinaryFilter alg = new LocalSquareBlockMinMaxBinaryFilter(textureThreshold, radius * 2 + 1, scale, down, input.getClass());
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        }
        alg.process(input, output);
        return output;
    }
}

