/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class ConvolveImageStandard_SB {
    public static void horizontal(Kernel1D_F32 kernel, GrayF32 image, GrayF32 dest) {
        float[] dataSrc = image.data;
        float[] dataDst = dest.data;
        float[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                float total = 0.0f;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, GrayF32 image, GrayF32 dest) {
        float[] dataSrc = image.data;
        float[] dataDst = dest.data;
        float[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                float total = 0.0f;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, GrayF32 src, GrayF32 dest) {
        float[] dataKernel = kernel.data;
        float[] dataSrc = src.data;
        float[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int offsetL = kernel.offset;
        int offsetR = kernel.width - kernel.offset - 1;
        for (int y = offsetL; y < height - offsetR; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + offsetL;
            for (int x = offsetL; x < width - offsetR; ++x) {
                float total = 0.0f;
                int indexKer = 0;
                for (int ki = 0; ki < kernel.width; ++ki) {
                    int indexSrc = src.startIndex + (y + ki - offsetL) * src.stride + x - offsetL;
                    for (int kj = 0; kj < kernel.width; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void horizontal(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                double total = 0.0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                double total = 0.0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void convolve(Kernel2D_F64 kernel, GrayF64 src, GrayF64 dest) {
        double[] dataKernel = kernel.data;
        double[] dataSrc = src.data;
        double[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int offsetL = kernel.offset;
        int offsetR = kernel.width - kernel.offset - 1;
        for (int y = offsetL; y < height - offsetR; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + offsetL;
            for (int x = offsetL; x < width - offsetR; ++x) {
                double total = 0.0;
                int indexKer = 0;
                for (int ki = 0; ki < kernel.width; ++ki) {
                    int indexSrc = src.startIndex + (y + ki - offsetL) * src.stride + x - offsetL;
                    for (int kj = 0; kj < kernel.width; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayU8 image, GrayI16 dest) {
        byte[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc++] & 0xFF) * dataKer[k];
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayU8 image, GrayI16 dest) {
        byte[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc] & 0xFF) * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayU8 src, GrayI16 dest) {
        int[] dataKernel = kernel.data;
        byte[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int offsetL = kernel.offset;
        int offsetR = kernel.width - kernel.offset - 1;
        for (int y = offsetL; y < height - offsetR; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + offsetL;
            for (int x = offsetL; x < width - offsetR; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = 0; ki < kernel.width; ++ki) {
                    int indexSrc = src.startIndex + (y + ki - offsetL) * src.stride + x - offsetL;
                    for (int kj = 0; kj < kernel.width; ++kj) {
                        total += (dataSrc[indexSrc + kj] & 0xFF) * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayU8 image, GrayS32 dest) {
        byte[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc++] & 0xFF) * dataKer[k];
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayU8 image, GrayS32 dest) {
        byte[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc] & 0xFF) * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayU8 src, GrayS32 dest) {
        int[] dataKernel = kernel.data;
        byte[] dataSrc = src.data;
        int[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int offsetL = kernel.offset;
        int offsetR = kernel.width - kernel.offset - 1;
        for (int y = offsetL; y < height - offsetR; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + offsetL;
            for (int x = offsetL; x < width - offsetR; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = 0; ki < kernel.width; ++ki) {
                    int indexSrc = src.startIndex + (y + ki - offsetL) * src.stride + x - offsetL;
                    for (int kj = 0; kj < kernel.width; ++kj) {
                        total += (dataSrc[indexSrc + kj] & 0xFF) * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayU16 image, GrayI8 dest, int divisor) {
        short[] dataSrc = image.data;
        byte[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc] & 0xFFFF) * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (byte)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayS16 image, GrayI16 dest) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayS16 image, GrayI16 dest) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayS16 src, GrayI16 dest) {
        int[] dataKernel = kernel.data;
        short[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int offsetL = kernel.offset;
        int offsetR = kernel.width - kernel.offset - 1;
        for (int y = offsetL; y < height - offsetR; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + offsetL;
            for (int x = offsetL; x < width - offsetR; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = 0; ki < kernel.width; ++ki) {
                    int indexSrc = src.startIndex + (y + ki - offsetL) * src.stride + x - offsetL;
                    for (int kj = 0; kj < kernel.width; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayU8 image, GrayI8 dest, int divisor) {
        byte[] dataSrc = image.data;
        byte[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc++] & 0xFF) * dataKer[k];
                }
                dataDst[indexDst++] = (byte)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayU8 image, GrayI8 dest, int divisor) {
        byte[] dataSrc = image.data;
        byte[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc] & 0xFF) * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (byte)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayU8 src, GrayI8 dest, int divisor) {
        int[] dataKernel = kernel.data;
        byte[] dataSrc = src.data;
        byte[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int halfDivisor = divisor / 2;
        int offsetL = kernel.offset;
        int offsetR = kernel.width - kernel.offset - 1;
        for (int y = offsetL; y < height - offsetR; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + offsetL;
            for (int x = offsetL; x < width - offsetR; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = 0; ki < kernel.width; ++ki) {
                    int indexSrc = src.startIndex + (y + ki - offsetL) * src.stride + x - offsetL;
                    for (int kj = 0; kj < kernel.width; ++kj) {
                        total += (dataSrc[indexSrc + kj] & 0xFF) * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (byte)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayS16 image, GrayI16 dest, int divisor) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = (short)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayS16 image, GrayI16 dest, int divisor) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (short)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayS16 src, GrayI16 dest, int divisor) {
        int[] dataKernel = kernel.data;
        short[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int halfDivisor = divisor / 2;
        int offsetL = kernel.offset;
        int offsetR = kernel.width - kernel.offset - 1;
        for (int y = offsetL; y < height - offsetR; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + offsetL;
            for (int x = offsetL; x < width - offsetR; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = 0; ki < kernel.width; ++ki) {
                    int indexSrc = src.startIndex + (y + ki - offsetL) * src.stride + x - offsetL;
                    for (int kj = 0; kj < kernel.width; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (short)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayS32 image, GrayI16 dest, int divisor) {
        int[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (short)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayS32 image, GrayS32 dest) {
        int[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayS32 image, GrayS32 dest) {
        int[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayS32 src, GrayS32 dest) {
        int[] dataKernel = kernel.data;
        int[] dataSrc = src.data;
        int[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int offsetL = kernel.offset;
        int offsetR = kernel.width - kernel.offset - 1;
        for (int y = offsetL; y < height - offsetR; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + offsetL;
            for (int x = offsetL; x < width - offsetR; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = 0; ki < kernel.width; ++ki) {
                    int indexSrc = src.startIndex + (y + ki - offsetL) * src.stride + x - offsetL;
                    for (int kj = 0; kj < kernel.width; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayS32 image, GrayS32 dest, int divisor) {
        int[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = (total + halfDivisor) / divisor;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayS32 image, GrayS32 dest, int divisor) {
        int[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (total + halfDivisor) / divisor;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayS32 src, GrayS32 dest, int divisor) {
        int[] dataKernel = kernel.data;
        int[] dataSrc = src.data;
        int[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int halfDivisor = divisor / 2;
        int offsetL = kernel.offset;
        int offsetR = kernel.width - kernel.offset - 1;
        for (int y = offsetL; y < height - offsetR; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + offsetL;
            for (int x = offsetL; x < width - offsetR; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = 0; ki < kernel.width; ++ki) {
                    int indexSrc = src.startIndex + (y + ki - offsetL) * src.stride + x - offsetL;
                    for (int kj = 0; kj < kernel.width; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (total + halfDivisor) / divisor;
            }
        }
    }
}

