/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.image.GrayF64;

public class ConvolveImageUnrolled_SB_F64_F64 {
    public static boolean horizontal(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        if (kernel.offset != kernel.width / 2 || kernel.width % 2 == 0) {
            return false;
        }
        switch (kernel.width) {
            case 3: {
                ConvolveImageUnrolled_SB_F64_F64.horizontal3(kernel, image, dest);
                break;
            }
            case 5: {
                ConvolveImageUnrolled_SB_F64_F64.horizontal5(kernel, image, dest);
                break;
            }
            case 7: {
                ConvolveImageUnrolled_SB_F64_F64.horizontal7(kernel, image, dest);
                break;
            }
            case 9: {
                ConvolveImageUnrolled_SB_F64_F64.horizontal9(kernel, image, dest);
                break;
            }
            case 11: {
                ConvolveImageUnrolled_SB_F64_F64.horizontal11(kernel, image, dest);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static boolean vertical(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        if (kernel.offset != kernel.width / 2 || kernel.width % 2 == 0) {
            return false;
        }
        switch (kernel.width) {
            case 3: {
                ConvolveImageUnrolled_SB_F64_F64.vertical3(kernel, image, dest);
                break;
            }
            case 5: {
                ConvolveImageUnrolled_SB_F64_F64.vertical5(kernel, image, dest);
                break;
            }
            case 7: {
                ConvolveImageUnrolled_SB_F64_F64.vertical7(kernel, image, dest);
                break;
            }
            case 9: {
                ConvolveImageUnrolled_SB_F64_F64.vertical9(kernel, image, dest);
                break;
            }
            case 11: {
                ConvolveImageUnrolled_SB_F64_F64.vertical11(kernel, image, dest);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static boolean convolve(Kernel2D_F64 kernel, GrayF64 image, GrayF64 dest) {
        if (kernel.offset != kernel.width / 2 || kernel.width % 2 == 0) {
            return false;
        }
        switch (kernel.width) {
            case 3: {
                ConvolveImageUnrolled_SB_F64_F64.convolve3(kernel, image, dest);
                break;
            }
            case 5: {
                ConvolveImageUnrolled_SB_F64_F64.convolve5(kernel, image, dest);
                break;
            }
            case 7: {
                ConvolveImageUnrolled_SB_F64_F64.convolve7(kernel, image, dest);
                break;
            }
            case 9: {
                ConvolveImageUnrolled_SB_F64_F64.convolve9(kernel, image, dest);
                break;
            }
            case 11: {
                ConvolveImageUnrolled_SB_F64_F64.convolve11(kernel, image, dest);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static void horizontal3(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double k1 = kernel.data[0];
        double k2 = kernel.data[1];
        double k3 = kernel.data[2];
        int radius = kernel.getRadius();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int indexDst = dest.startIndex + i * dest.stride + radius;
            int j = image.startIndex + i * image.stride - radius;
            int jEnd = j + width - radius;
            j += radius;
            while (j < jEnd) {
                int indexSrc = j;
                double total = dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                dataDst[indexDst++] = total += dataSrc[indexSrc] * k3;
                ++j;
            }
        }
    }

    public static void horizontal5(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double k1 = kernel.data[0];
        double k2 = kernel.data[1];
        double k3 = kernel.data[2];
        double k4 = kernel.data[3];
        double k5 = kernel.data[4];
        int radius = kernel.getRadius();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int indexDst = dest.startIndex + i * dest.stride + radius;
            int j = image.startIndex + i * image.stride - radius;
            int jEnd = j + width - radius;
            j += radius;
            while (j < jEnd) {
                int indexSrc = j;
                double total = dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                dataDst[indexDst++] = total += dataSrc[indexSrc] * k5;
                ++j;
            }
        }
    }

    public static void horizontal7(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double k1 = kernel.data[0];
        double k2 = kernel.data[1];
        double k3 = kernel.data[2];
        double k4 = kernel.data[3];
        double k5 = kernel.data[4];
        double k6 = kernel.data[5];
        double k7 = kernel.data[6];
        int radius = kernel.getRadius();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int indexDst = dest.startIndex + i * dest.stride + radius;
            int j = image.startIndex + i * image.stride - radius;
            int jEnd = j + width - radius;
            j += radius;
            while (j < jEnd) {
                int indexSrc = j;
                double total = dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                dataDst[indexDst++] = total += dataSrc[indexSrc] * k7;
                ++j;
            }
        }
    }

    public static void horizontal9(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double k1 = kernel.data[0];
        double k2 = kernel.data[1];
        double k3 = kernel.data[2];
        double k4 = kernel.data[3];
        double k5 = kernel.data[4];
        double k6 = kernel.data[5];
        double k7 = kernel.data[6];
        double k8 = kernel.data[7];
        double k9 = kernel.data[8];
        int radius = kernel.getRadius();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int indexDst = dest.startIndex + i * dest.stride + radius;
            int j = image.startIndex + i * image.stride - radius;
            int jEnd = j + width - radius;
            j += radius;
            while (j < jEnd) {
                int indexSrc = j;
                double total = dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                total += dataSrc[indexSrc++] * k7;
                total += dataSrc[indexSrc++] * k8;
                dataDst[indexDst++] = total += dataSrc[indexSrc] * k9;
                ++j;
            }
        }
    }

    public static void horizontal11(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double k1 = kernel.data[0];
        double k2 = kernel.data[1];
        double k3 = kernel.data[2];
        double k4 = kernel.data[3];
        double k5 = kernel.data[4];
        double k6 = kernel.data[5];
        double k7 = kernel.data[6];
        double k8 = kernel.data[7];
        double k9 = kernel.data[8];
        double k10 = kernel.data[9];
        double k11 = kernel.data[10];
        int radius = kernel.getRadius();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int indexDst = dest.startIndex + i * dest.stride + radius;
            int j = image.startIndex + i * image.stride - radius;
            int jEnd = j + width - radius;
            j += radius;
            while (j < jEnd) {
                int indexSrc = j;
                double total = dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                total += dataSrc[indexSrc++] * k7;
                total += dataSrc[indexSrc++] * k8;
                total += dataSrc[indexSrc++] * k9;
                total += dataSrc[indexSrc++] * k10;
                dataDst[indexDst++] = total += dataSrc[indexSrc] * k11;
                ++j;
            }
        }
    }

    public static void vertical3(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double k1 = kernel.data[0];
        double k2 = kernel.data[1];
        double k3 = kernel.data[2];
        int radius = kernel.getRadius();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - radius;
        for (int y = radius; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - radius) * image.stride; i < iEnd; ++i) {
                int indexSrc = i;
                double total = dataSrc[indexSrc] * k1;
                total += dataSrc[indexSrc += image.stride] * k2;
                dataDst[indexDst++] = total += dataSrc[indexSrc += image.stride] * k3;
            }
        }
    }

    public static void vertical5(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double k1 = kernel.data[0];
        double k2 = kernel.data[1];
        double k3 = kernel.data[2];
        double k4 = kernel.data[3];
        double k5 = kernel.data[4];
        int radius = kernel.getRadius();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - radius;
        for (int y = radius; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - radius) * image.stride; i < iEnd; ++i) {
                int indexSrc = i;
                double total = dataSrc[indexSrc] * k1;
                total += dataSrc[indexSrc += image.stride] * k2;
                total += dataSrc[indexSrc += image.stride] * k3;
                total += dataSrc[indexSrc += image.stride] * k4;
                dataDst[indexDst++] = total += dataSrc[indexSrc += image.stride] * k5;
            }
        }
    }

    public static void vertical7(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double k1 = kernel.data[0];
        double k2 = kernel.data[1];
        double k3 = kernel.data[2];
        double k4 = kernel.data[3];
        double k5 = kernel.data[4];
        double k6 = kernel.data[5];
        double k7 = kernel.data[6];
        int radius = kernel.getRadius();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - radius;
        for (int y = radius; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - radius) * image.stride; i < iEnd; ++i) {
                int indexSrc = i;
                double total = dataSrc[indexSrc] * k1;
                total += dataSrc[indexSrc += image.stride] * k2;
                total += dataSrc[indexSrc += image.stride] * k3;
                total += dataSrc[indexSrc += image.stride] * k4;
                total += dataSrc[indexSrc += image.stride] * k5;
                total += dataSrc[indexSrc += image.stride] * k6;
                dataDst[indexDst++] = total += dataSrc[indexSrc += image.stride] * k7;
            }
        }
    }

    public static void vertical9(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double k1 = kernel.data[0];
        double k2 = kernel.data[1];
        double k3 = kernel.data[2];
        double k4 = kernel.data[3];
        double k5 = kernel.data[4];
        double k6 = kernel.data[5];
        double k7 = kernel.data[6];
        double k8 = kernel.data[7];
        double k9 = kernel.data[8];
        int radius = kernel.getRadius();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - radius;
        for (int y = radius; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - radius) * image.stride; i < iEnd; ++i) {
                int indexSrc = i;
                double total = dataSrc[indexSrc] * k1;
                total += dataSrc[indexSrc += image.stride] * k2;
                total += dataSrc[indexSrc += image.stride] * k3;
                total += dataSrc[indexSrc += image.stride] * k4;
                total += dataSrc[indexSrc += image.stride] * k5;
                total += dataSrc[indexSrc += image.stride] * k6;
                total += dataSrc[indexSrc += image.stride] * k7;
                total += dataSrc[indexSrc += image.stride] * k8;
                dataDst[indexDst++] = total += dataSrc[indexSrc += image.stride] * k9;
            }
        }
    }

    public static void vertical11(Kernel1D_F64 kernel, GrayF64 image, GrayF64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double k1 = kernel.data[0];
        double k2 = kernel.data[1];
        double k3 = kernel.data[2];
        double k4 = kernel.data[3];
        double k5 = kernel.data[4];
        double k6 = kernel.data[5];
        double k7 = kernel.data[6];
        double k8 = kernel.data[7];
        double k9 = kernel.data[8];
        double k10 = kernel.data[9];
        double k11 = kernel.data[10];
        int radius = kernel.getRadius();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - radius;
        for (int y = radius; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - radius) * image.stride; i < iEnd; ++i) {
                int indexSrc = i;
                double total = dataSrc[indexSrc] * k1;
                total += dataSrc[indexSrc += image.stride] * k2;
                total += dataSrc[indexSrc += image.stride] * k3;
                total += dataSrc[indexSrc += image.stride] * k4;
                total += dataSrc[indexSrc += image.stride] * k5;
                total += dataSrc[indexSrc += image.stride] * k6;
                total += dataSrc[indexSrc += image.stride] * k7;
                total += dataSrc[indexSrc += image.stride] * k8;
                total += dataSrc[indexSrc += image.stride] * k9;
                total += dataSrc[indexSrc += image.stride] * k10;
                dataDst[indexDst++] = total += dataSrc[indexSrc += image.stride] * k11;
            }
        }
    }

    public static void convolve3(Kernel2D_F64 kernel, GrayF64 src, GrayF64 dest) {
        int kernelRadius;
        double[] dataSrc = src.data;
        double[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.getRadius(); y < height - kernelRadius; ++y) {
            double k1 = kernel.data[0];
            double k2 = kernel.data[1];
            double k3 = kernel.data[2];
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            int indexSrcRow = src.startIndex + (y - kernelRadius) * src.stride - kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int indexSrc = indexSrcRow + x;
                double total = 0.0;
                total += dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                dataDst[indexDst++] = total += dataSrc[indexSrc] * k3;
            }
            for (int i = 1; i < 3; ++i) {
                indexDst = dest.startIndex + y * dest.stride + kernelRadius;
                indexSrcRow = src.startIndex + (y + i - kernelRadius) * src.stride - kernelRadius;
                k1 = kernel.data[i * 3 + 0];
                k2 = kernel.data[i * 3 + 1];
                k3 = kernel.data[i * 3 + 2];
                for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                    int indexSrc = indexSrcRow + x;
                    double total = 0.0;
                    total += dataSrc[indexSrc++] * k1;
                    total += dataSrc[indexSrc++] * k2;
                    int n = indexDst++;
                    dataDst[n] = dataDst[n] + (total += dataSrc[indexSrc] * k3);
                }
            }
        }
    }

    public static void convolve5(Kernel2D_F64 kernel, GrayF64 src, GrayF64 dest) {
        int kernelRadius;
        double[] dataSrc = src.data;
        double[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.getRadius(); y < height - kernelRadius; ++y) {
            double k1 = kernel.data[0];
            double k2 = kernel.data[1];
            double k3 = kernel.data[2];
            double k4 = kernel.data[3];
            double k5 = kernel.data[4];
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            int indexSrcRow = src.startIndex + (y - kernelRadius) * src.stride - kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int indexSrc = indexSrcRow + x;
                double total = 0.0;
                total += dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                dataDst[indexDst++] = total += dataSrc[indexSrc] * k5;
            }
            for (int i = 1; i < 5; ++i) {
                indexDst = dest.startIndex + y * dest.stride + kernelRadius;
                indexSrcRow = src.startIndex + (y + i - kernelRadius) * src.stride - kernelRadius;
                k1 = kernel.data[i * 5 + 0];
                k2 = kernel.data[i * 5 + 1];
                k3 = kernel.data[i * 5 + 2];
                k4 = kernel.data[i * 5 + 3];
                k5 = kernel.data[i * 5 + 4];
                for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                    int indexSrc = indexSrcRow + x;
                    double total = 0.0;
                    total += dataSrc[indexSrc++] * k1;
                    total += dataSrc[indexSrc++] * k2;
                    total += dataSrc[indexSrc++] * k3;
                    total += dataSrc[indexSrc++] * k4;
                    int n = indexDst++;
                    dataDst[n] = dataDst[n] + (total += dataSrc[indexSrc] * k5);
                }
            }
        }
    }

    public static void convolve7(Kernel2D_F64 kernel, GrayF64 src, GrayF64 dest) {
        int kernelRadius;
        double[] dataSrc = src.data;
        double[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.getRadius(); y < height - kernelRadius; ++y) {
            double k1 = kernel.data[0];
            double k2 = kernel.data[1];
            double k3 = kernel.data[2];
            double k4 = kernel.data[3];
            double k5 = kernel.data[4];
            double k6 = kernel.data[5];
            double k7 = kernel.data[6];
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            int indexSrcRow = src.startIndex + (y - kernelRadius) * src.stride - kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int indexSrc = indexSrcRow + x;
                double total = 0.0;
                total += dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                dataDst[indexDst++] = total += dataSrc[indexSrc] * k7;
            }
            for (int i = 1; i < 7; ++i) {
                indexDst = dest.startIndex + y * dest.stride + kernelRadius;
                indexSrcRow = src.startIndex + (y + i - kernelRadius) * src.stride - kernelRadius;
                k1 = kernel.data[i * 7 + 0];
                k2 = kernel.data[i * 7 + 1];
                k3 = kernel.data[i * 7 + 2];
                k4 = kernel.data[i * 7 + 3];
                k5 = kernel.data[i * 7 + 4];
                k6 = kernel.data[i * 7 + 5];
                k7 = kernel.data[i * 7 + 6];
                for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                    int indexSrc = indexSrcRow + x;
                    double total = 0.0;
                    total += dataSrc[indexSrc++] * k1;
                    total += dataSrc[indexSrc++] * k2;
                    total += dataSrc[indexSrc++] * k3;
                    total += dataSrc[indexSrc++] * k4;
                    total += dataSrc[indexSrc++] * k5;
                    total += dataSrc[indexSrc++] * k6;
                    int n = indexDst++;
                    dataDst[n] = dataDst[n] + (total += dataSrc[indexSrc] * k7);
                }
            }
        }
    }

    public static void convolve9(Kernel2D_F64 kernel, GrayF64 src, GrayF64 dest) {
        int kernelRadius;
        double[] dataSrc = src.data;
        double[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.getRadius(); y < height - kernelRadius; ++y) {
            double k1 = kernel.data[0];
            double k2 = kernel.data[1];
            double k3 = kernel.data[2];
            double k4 = kernel.data[3];
            double k5 = kernel.data[4];
            double k6 = kernel.data[5];
            double k7 = kernel.data[6];
            double k8 = kernel.data[7];
            double k9 = kernel.data[8];
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            int indexSrcRow = src.startIndex + (y - kernelRadius) * src.stride - kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int indexSrc = indexSrcRow + x;
                double total = 0.0;
                total += dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                total += dataSrc[indexSrc++] * k7;
                total += dataSrc[indexSrc++] * k8;
                dataDst[indexDst++] = total += dataSrc[indexSrc] * k9;
            }
            for (int i = 1; i < 9; ++i) {
                indexDst = dest.startIndex + y * dest.stride + kernelRadius;
                indexSrcRow = src.startIndex + (y + i - kernelRadius) * src.stride - kernelRadius;
                k1 = kernel.data[i * 9 + 0];
                k2 = kernel.data[i * 9 + 1];
                k3 = kernel.data[i * 9 + 2];
                k4 = kernel.data[i * 9 + 3];
                k5 = kernel.data[i * 9 + 4];
                k6 = kernel.data[i * 9 + 5];
                k7 = kernel.data[i * 9 + 6];
                k8 = kernel.data[i * 9 + 7];
                k9 = kernel.data[i * 9 + 8];
                for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                    int indexSrc = indexSrcRow + x;
                    double total = 0.0;
                    total += dataSrc[indexSrc++] * k1;
                    total += dataSrc[indexSrc++] * k2;
                    total += dataSrc[indexSrc++] * k3;
                    total += dataSrc[indexSrc++] * k4;
                    total += dataSrc[indexSrc++] * k5;
                    total += dataSrc[indexSrc++] * k6;
                    total += dataSrc[indexSrc++] * k7;
                    total += dataSrc[indexSrc++] * k8;
                    int n = indexDst++;
                    dataDst[n] = dataDst[n] + (total += dataSrc[indexSrc] * k9);
                }
            }
        }
    }

    public static void convolve11(Kernel2D_F64 kernel, GrayF64 src, GrayF64 dest) {
        int kernelRadius;
        double[] dataSrc = src.data;
        double[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.getRadius(); y < height - kernelRadius; ++y) {
            double k1 = kernel.data[0];
            double k2 = kernel.data[1];
            double k3 = kernel.data[2];
            double k4 = kernel.data[3];
            double k5 = kernel.data[4];
            double k6 = kernel.data[5];
            double k7 = kernel.data[6];
            double k8 = kernel.data[7];
            double k9 = kernel.data[8];
            double k10 = kernel.data[9];
            double k11 = kernel.data[10];
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            int indexSrcRow = src.startIndex + (y - kernelRadius) * src.stride - kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int indexSrc = indexSrcRow + x;
                double total = 0.0;
                total += dataSrc[indexSrc++] * k1;
                total += dataSrc[indexSrc++] * k2;
                total += dataSrc[indexSrc++] * k3;
                total += dataSrc[indexSrc++] * k4;
                total += dataSrc[indexSrc++] * k5;
                total += dataSrc[indexSrc++] * k6;
                total += dataSrc[indexSrc++] * k7;
                total += dataSrc[indexSrc++] * k8;
                total += dataSrc[indexSrc++] * k9;
                total += dataSrc[indexSrc++] * k10;
                dataDst[indexDst++] = total += dataSrc[indexSrc] * k11;
            }
            for (int i = 1; i < 11; ++i) {
                indexDst = dest.startIndex + y * dest.stride + kernelRadius;
                indexSrcRow = src.startIndex + (y + i - kernelRadius) * src.stride - kernelRadius;
                k1 = kernel.data[i * 11 + 0];
                k2 = kernel.data[i * 11 + 1];
                k3 = kernel.data[i * 11 + 2];
                k4 = kernel.data[i * 11 + 3];
                k5 = kernel.data[i * 11 + 4];
                k6 = kernel.data[i * 11 + 5];
                k7 = kernel.data[i * 11 + 6];
                k8 = kernel.data[i * 11 + 7];
                k9 = kernel.data[i * 11 + 8];
                k10 = kernel.data[i * 11 + 9];
                k11 = kernel.data[i * 11 + 10];
                for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                    int indexSrc = indexSrcRow + x;
                    double total = 0.0;
                    total += dataSrc[indexSrc++] * k1;
                    total += dataSrc[indexSrc++] * k2;
                    total += dataSrc[indexSrc++] * k3;
                    total += dataSrc[indexSrc++] * k4;
                    total += dataSrc[indexSrc++] * k5;
                    total += dataSrc[indexSrc++] * k6;
                    total += dataSrc[indexSrc++] * k7;
                    total += dataSrc[indexSrc++] * k8;
                    total += dataSrc[indexSrc++] * k9;
                    total += dataSrc[indexSrc++] * k10;
                    int n = indexDst++;
                    dataDst[n] = dataDst[n] + (total += dataSrc[indexSrc] * k11);
                }
            }
        }
    }
}

