/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.ConvolveImageNoBorder;
import boofcv.alg.filter.convolve.ConvolveWithBorder;
import boofcv.alg.filter.derivative.GradientPrewitt;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.core.image.border.BorderIndex1D_Extend;
import boofcv.core.image.border.ImageBorder1D_F32;
import boofcv.core.image.border.ImageBorder1D_S32;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayS16;

public class HessianFromGradient {
    public static void hessianPrewitt(GrayS16 inputDerivX, GrayS16 inputDerivY, GrayS16 derivXX, GrayS16 derivYY, GrayS16 derivXY, ImageBorder_S32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientPrewitt.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.convolve(GradientPrewitt.kernelDerivY_I32, inputDerivY, (GrayI16)derivYY, border);
        } else {
            ConvolveImageNoBorder.convolve(GradientPrewitt.kernelDerivY_I32, inputDerivY, (GrayI16)derivYY);
        }
    }

    public static void hessianPrewitt(GrayF32 inputDerivX, GrayF32 inputDerivY, GrayF32 derivXX, GrayF32 derivYY, GrayF32 derivXY, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientPrewitt.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.convolve(GradientPrewitt.kernelDerivY_F32, inputDerivY, derivYY, border);
        } else {
            ConvolveImageNoBorder.convolve(GradientPrewitt.kernelDerivY_F32, inputDerivY, derivYY);
        }
    }

    public static void hessianSobel(GrayS16 inputDerivX, GrayS16 inputDerivY, GrayS16 derivXX, GrayS16 derivYY, GrayS16 derivXY, ImageBorder_S32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientSobel.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.convolve(GradientSobel.kernelDerivY_I32, inputDerivY, (GrayI16)derivYY, new ImageBorder1D_S32(BorderIndex1D_Extend.class));
        } else {
            ConvolveImageNoBorder.convolve(GradientSobel.kernelDerivY_I32, inputDerivY, (GrayI16)derivYY);
        }
    }

    public static void hessianSobel(GrayF32 inputDerivX, GrayF32 inputDerivY, GrayF32 derivXX, GrayF32 derivYY, GrayF32 derivXY, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientSobel.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.convolve(GradientSobel.kernelDerivY_F32, inputDerivY, derivYY, new ImageBorder1D_F32(BorderIndex1D_Extend.class));
        } else {
            ConvolveImageNoBorder.convolve(GradientSobel.kernelDerivY_F32, inputDerivY, derivYY);
        }
    }

    public static void hessianThree(GrayS16 inputDerivX, GrayS16 inputDerivY, GrayS16 derivXX, GrayS16 derivYY, GrayS16 derivXY, ImageBorder_S32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientThree.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.vertical(GradientThree.kernelDeriv_I32, inputDerivY, (GrayI16)derivYY, new ImageBorder1D_S32(BorderIndex1D_Extend.class));
        } else {
            ConvolveImageNoBorder.vertical(GradientThree.kernelDeriv_I32, inputDerivY, (GrayI16)derivYY);
        }
    }

    public static void hessianThree(GrayF32 inputDerivX, GrayF32 inputDerivY, GrayF32 derivXX, GrayF32 derivYY, GrayF32 derivXY, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(inputDerivX, inputDerivY, derivXX, derivYY, derivXY);
        GradientThree.process(inputDerivX, derivXX, derivXY, border);
        if (border != null) {
            ConvolveWithBorder.vertical(GradientThree.kernelDeriv_F32, inputDerivY, derivYY, new ImageBorder1D_F32(BorderIndex1D_Extend.class));
        } else {
            ConvolveImageNoBorder.vertical(GradientThree.kernelDeriv_F32, inputDerivY, derivYY);
        }
    }
}

