/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;

public class ImageStatistics {
    public static int min(GrayU8 input) {
        return ImageStatistics.minU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int min(InterleavedU8 input) {
        return ImageStatistics.minU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int minU(byte[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFF;
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int max(GrayU8 input) {
        return ImageStatistics.maxU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int max(InterleavedU8 input) {
        return ImageStatistics.maxU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int maxU(byte[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFF;
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxAbs(GrayU8 input) {
        return ImageStatistics.maxAbsU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int maxAbs(InterleavedU8 input) {
        return ImageStatistics.maxAbsU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int maxAbsU(byte[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFF;
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(GrayU8 imgA, GrayU8 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedU8 imgA, InterleavedU8 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffSqU(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFF) - (dataB[indexB] & 0xFF);
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(GrayU8 imgA, GrayU8 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedU8 imgA, InterleavedU8 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffAbsU(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFF) - (dataB[indexB] & 0xFF);
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static int sum(GrayU8 img) {
        int rows = img.height;
        int columns = img.width;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFF;
            }
        }
        return total;
    }

    public static double mean(GrayU8 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static int sum(InterleavedU8 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFF;
            }
        }
        return total;
    }

    public static double mean(InterleavedU8 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayU8 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)(img.data[index] & 0xFF) - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static void histogram(GrayU8 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = (input.data[index] & 0xFF) - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static int min(GrayS8 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int min(InterleavedS8 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int min(byte[] array, int startIndex, int rows, int columns, int stride) {
        byte output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                byte v = array[index];
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int max(GrayS8 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int max(InterleavedS8 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int max(byte[] array, int startIndex, int rows, int columns, int stride) {
        byte output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                byte v = array[index];
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxAbs(GrayS8 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int maxAbs(InterleavedS8 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int maxAbs(byte[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(GrayS8 imgA, GrayS8 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedS8 imgA, InterleavedS8 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffSq(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(GrayS8 imgA, GrayS8 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedS8 imgA, InterleavedS8 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffAbs(byte[] dataA, int startIndexA, int strideA, byte[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static int sum(GrayS8 img) {
        int rows = img.height;
        int columns = img.width;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(GrayS8 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static int sum(InterleavedS8 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(InterleavedS8 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayS8 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static void histogram(GrayS8 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = input.data[index] - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static int min(GrayU16 input) {
        return ImageStatistics.minU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int min(InterleavedU16 input) {
        return ImageStatistics.minU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int minU(short[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFFFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFFFF;
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int max(GrayU16 input) {
        return ImageStatistics.maxU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int max(InterleavedU16 input) {
        return ImageStatistics.maxU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int maxU(short[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFFFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFFFF;
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxAbs(GrayU16 input) {
        return ImageStatistics.maxAbsU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int maxAbs(InterleavedU16 input) {
        return ImageStatistics.maxAbsU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int maxAbsU(short[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex] & 0xFFFF;
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index] & 0xFFFF;
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(GrayU16 imgA, GrayU16 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedU16 imgA, InterleavedU16 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffSqU(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFFFF) - (dataB[indexB] & 0xFFFF);
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(GrayU16 imgA, GrayU16 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedU16 imgA, InterleavedU16 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffAbsU(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = (dataA[indexA] & 0xFFFF) - (dataB[indexB] & 0xFFFF);
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static int sum(GrayU16 img) {
        int rows = img.height;
        int columns = img.width;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFFFF;
            }
        }
        return total;
    }

    public static double mean(GrayU16 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static int sum(InterleavedU16 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index] & 0xFFFF;
            }
        }
        return total;
    }

    public static double mean(InterleavedU16 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayU16 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)(img.data[index] & 0xFFFF) - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static void histogram(GrayU16 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = (input.data[index] & 0xFFFF) - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static int min(GrayS16 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int min(InterleavedS16 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int min(short[] array, int startIndex, int rows, int columns, int stride) {
        short output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                short v = array[index];
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int max(GrayS16 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int max(InterleavedS16 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int max(short[] array, int startIndex, int rows, int columns, int stride) {
        short output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                short v = array[index];
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxAbs(GrayS16 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int maxAbs(InterleavedS16 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int maxAbs(short[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(GrayS16 imgA, GrayS16 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedS16 imgA, InterleavedS16 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffSq(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(GrayS16 imgA, GrayS16 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedS16 imgA, InterleavedS16 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffAbs(short[] dataA, int startIndexA, int strideA, short[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static int sum(GrayS16 img) {
        int rows = img.height;
        int columns = img.width;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(GrayS16 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static int sum(InterleavedS16 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(InterleavedS16 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayS16 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static void histogram(GrayS16 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = input.data[index] - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static int min(GrayS32 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int min(InterleavedS32 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int min(int[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index];
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int max(GrayS32 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int max(InterleavedS32 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int max(int[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = array[index];
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static int maxAbs(GrayS32 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int maxAbs(InterleavedS32 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static int maxAbs(int[] array, int startIndex, int rows, int columns, int stride) {
        int output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                int v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(GrayS32 imgA, GrayS32 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedS32 imgA, InterleavedS32 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffSq(int[] dataA, int startIndexA, int strideA, int[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(GrayS32 imgA, GrayS32 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedS32 imgA, InterleavedS32 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffAbs(int[] dataA, int startIndexA, int strideA, int[] dataB, int startIndexB, int strideB, int rows, int columns) {
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                int difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static int sum(GrayS32 img) {
        int rows = img.height;
        int columns = img.width;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(GrayS32 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static int sum(InterleavedS32 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        int total = 0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(InterleavedS32 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayS32 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static void histogram(GrayS32 input, int minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = input.data[index] - minValue;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static long min(GrayS64 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static long min(InterleavedS64 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static long min(long[] array, int startIndex, int rows, int columns, int stride) {
        long output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                long v = array[index];
                if (v >= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static long max(GrayS64 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static long max(InterleavedS64 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static long max(long[] array, int startIndex, int rows, int columns, int stride) {
        long output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                long v = array[index];
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static long maxAbs(GrayS64 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static long maxAbs(InterleavedS64 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static long maxAbs(long[] array, int startIndex, int rows, int columns, int stride) {
        long output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                long v = Math.abs(array[index]);
                if (v <= output) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(GrayS64 imgA, GrayS64 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedS64 imgA, InterleavedS64 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffSq(long[] dataA, int startIndexA, int strideA, long[] dataB, int startIndexB, int strideB, int rows, int columns) {
        long total = 0L;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                long difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(GrayS64 imgA, GrayS64 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedS64 imgA, InterleavedS64 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffAbs(long[] dataA, int startIndexA, int strideA, long[] dataB, int startIndexB, int strideB, int rows, int columns) {
        long total = 0L;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                long difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static long sum(GrayS64 img) {
        int rows = img.height;
        int columns = img.width;
        long total = 0L;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(GrayS64 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static long sum(InterleavedS64 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        long total = 0L;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(InterleavedS64 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayS64 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = (double)img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static void histogram(GrayS64 input, long minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = (int)(input.data[index] - minValue);
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static float min(GrayF32 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static float min(InterleavedF32 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static float min(float[] array, int startIndex, int rows, int columns, int stride) {
        float output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                float v = array[index];
                if (!(v < output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static float max(GrayF32 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static float max(InterleavedF32 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static float max(float[] array, int startIndex, int rows, int columns, int stride) {
        float output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                float v = array[index];
                if (!(v > output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static float maxAbs(GrayF32 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static float maxAbs(InterleavedF32 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static float maxAbs(float[] array, int startIndex, int rows, int columns, int stride) {
        float output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                float v = Math.abs(array[index]);
                if (!(v > output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(GrayF32 imgA, GrayF32 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedF32 imgA, InterleavedF32 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffSq(float[] dataA, int startIndexA, int strideA, float[] dataB, int startIndexB, int strideB, int rows, int columns) {
        float total = 0.0f;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                float difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static double meanDiffAbs(GrayF32 imgA, GrayF32 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedF32 imgA, InterleavedF32 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffAbs(float[] dataA, int startIndexA, int strideA, float[] dataB, int startIndexB, int strideB, int rows, int columns) {
        float total = 0.0f;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                float difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return (double)total / (double)(rows * columns);
    }

    public static float sum(GrayF32 img) {
        int rows = img.height;
        int columns = img.width;
        float total = 0.0f;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static float mean(GrayF32 img) {
        return ImageStatistics.sum(img) / (float)(img.width * img.height);
    }

    public static float sum(InterleavedF32 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        float total = 0.0f;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static float mean(InterleavedF32 img) {
        return ImageStatistics.sum(img) / (float)(img.width * img.height * img.numBands);
    }

    public static float variance(GrayF32 img, float mean) {
        float variance = 0.0f;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                float d = img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (float)(img.width * img.height);
    }

    public static void histogram(GrayF32 input, float minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = (int)(input.data[index] - minValue);
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static double min(GrayF64 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static double min(InterleavedF64 input) {
        return ImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static double min(double[] array, int startIndex, int rows, int columns, int stride) {
        double output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                double v = array[index];
                if (!(v < output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static double max(GrayF64 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static double max(InterleavedF64 input) {
        return ImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static double max(double[] array, int startIndex, int rows, int columns, int stride) {
        double output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                double v = array[index];
                if (!(v > output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static double maxAbs(GrayF64 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static double maxAbs(InterleavedF64 input) {
        return ImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    private static double maxAbs(double[] array, int startIndex, int rows, int columns, int stride) {
        double output = array[startIndex];
        for (int y = 0; y < rows; ++y) {
            int index;
            int end = index + columns;
            for (index = startIndex + y * stride; index < end; ++index) {
                double v = Math.abs(array[index]);
                if (!(v > output)) continue;
                output = v;
            }
        }
        return output;
    }

    public static double meanDiffSq(GrayF64 imgA, GrayF64 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedF64 imgA, InterleavedF64 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffSq(double[] dataA, int startIndexA, int strideA, double[] dataB, int startIndexB, int strideB, int rows, int columns) {
        double total = 0.0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                double difference = dataA[indexA] - dataB[indexB];
                total += difference * difference;
                ++indexA;
                ++indexB;
            }
        }
        return total / (double)(rows * columns);
    }

    public static double meanDiffAbs(GrayF64 imgA, GrayF64 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedF64 imgA, InterleavedF64 imgB) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        return ImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    private static double meanDiffAbs(double[] dataA, int startIndexA, int strideA, double[] dataB, int startIndexB, int strideB, int rows, int columns) {
        double total = 0.0;
        for (int y = 0; y < rows; ++y) {
            int indexA = startIndexA + y * strideA;
            int indexB = startIndexB + y * strideB;
            int indexEnd = indexA + columns;
            while (indexA < indexEnd) {
                double difference = dataA[indexA] - dataB[indexB];
                total += Math.abs(difference);
                ++indexA;
                ++indexB;
            }
        }
        return total / (double)(rows * columns);
    }

    public static double sum(GrayF64 img) {
        int rows = img.height;
        int columns = img.width;
        double total = 0.0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(GrayF64 img) {
        return ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static double sum(InterleavedF64 img) {
        int rows = img.height;
        int columns = img.width * img.numBands;
        double total = 0.0;
        for (int y = 0; y < rows; ++y) {
            int index;
            int indexEnd = index + columns;
            for (index = img.startIndex + y * img.stride; index < indexEnd; ++index) {
                total += img.data[index];
            }
        }
        return total;
    }

    public static double mean(InterleavedF64 img) {
        return ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayF64 img, double mean) {
        double variance = 0.0;
        for (int y = 0; y < img.height; ++y) {
            int index;
            int indexEnd = index + img.width;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double d = img.data[index] - mean;
                variance += d * d;
            }
        }
        return variance / (double)(img.width * img.height);
    }

    public static void histogram(GrayF64 input, double minValue, int[] histogram) {
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (int y = 0; y < input.height; ++y) {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int n = (int)(input.data[index] - minValue);
                histogram[n] = histogram[n] + 1;
            }
        }
    }
}

