/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.derivative;

import boofcv.abst.filter.ImageFunctionSparse;
import boofcv.abst.filter.convolve.ImageConvolveSparse;
import boofcv.alg.filter.derivative.LaplacianEdge;
import boofcv.alg.filter.derivative.impl.GradientSparsePrewitt_F32;
import boofcv.alg.filter.derivative.impl.GradientSparsePrewitt_U8;
import boofcv.alg.filter.derivative.impl.GradientSparseSobel_F32;
import boofcv.alg.filter.derivative.impl.GradientSparseSobel_U8;
import boofcv.alg.filter.derivative.impl.GradientSparseThree_F32;
import boofcv.alg.filter.derivative.impl.GradientSparseThree_U8;
import boofcv.alg.filter.derivative.impl.GradientSparseTwo0_F32;
import boofcv.alg.filter.derivative.impl.GradientSparseTwo0_U8;
import boofcv.alg.filter.derivative.impl.GradientSparseTwo1_F32;
import boofcv.alg.filter.derivative.impl.GradientSparseTwo1_U8;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.factory.filter.convolve.FactoryConvolveSparse;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.sparse.GradientValue;
import boofcv.struct.sparse.SparseImageGradient;

public class FactoryDerivativeSparse {
    public static <T extends ImageGray<T>> ImageFunctionSparse<T> createLaplacian(Class<T> imageType, ImageBorder<T> border) {
        if (border == null) {
            border = FactoryImageBorder.single(imageType, BorderType.EXTENDED);
        }
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            ImageConvolveSparse<GrayF32, Kernel2D_F32> r = FactoryConvolveSparse.convolve2D(GrayF32.class, LaplacianEdge.kernel_F32);
            r.setImageBorder((ImageBorder_F32)border);
            return r;
        }
        ImageConvolveSparse<GrayI, Kernel2D_S32> r = FactoryConvolveSparse.convolve2D(GrayI.class, LaplacianEdge.kernel_I32);
        r.setImageBorder(border);
        return r;
    }

    public static <T extends ImageGray<T>, G extends GradientValue> SparseImageGradient<T, G> createSobel(Class<T> imageType, ImageBorder<T> border) {
        if (imageType == GrayF32.class) {
            return new GradientSparseSobel_F32((ImageBorder_F32)border);
        }
        if (imageType == GrayU8.class) {
            return new GradientSparseSobel_U8((ImageBorder_S32)border);
        }
        throw new IllegalArgumentException("Unsupported image type " + imageType.getSimpleName());
    }

    public static <T extends ImageGray<T>, G extends GradientValue> SparseImageGradient<T, G> createPrewitt(Class<T> imageType, ImageBorder<T> border) {
        if (imageType == GrayF32.class) {
            return new GradientSparsePrewitt_F32((ImageBorder_F32)border);
        }
        if (imageType == GrayU8.class) {
            return new GradientSparsePrewitt_U8((ImageBorder_S32)border);
        }
        throw new IllegalArgumentException("Unsupported image type " + imageType.getSimpleName());
    }

    public static <T extends ImageGray<T>, G extends GradientValue> SparseImageGradient<T, G> createThree(Class<T> imageType, ImageBorder<T> border) {
        if (imageType == GrayF32.class) {
            return new GradientSparseThree_F32((ImageBorder_F32)border);
        }
        if (imageType == GrayU8.class) {
            return new GradientSparseThree_U8((ImageBorder_S32)border);
        }
        throw new IllegalArgumentException("Unsupported image type " + imageType.getSimpleName());
    }

    public static <T extends ImageGray<T>, G extends GradientValue> SparseImageGradient<T, G> createTwo0(Class<T> imageType, ImageBorder<T> border) {
        if (imageType == GrayF32.class) {
            return new GradientSparseTwo0_F32((ImageBorder_F32)border);
        }
        if (imageType == GrayU8.class) {
            return new GradientSparseTwo0_U8((ImageBorder_S32)border);
        }
        throw new IllegalArgumentException("Unsupported image type " + imageType.getSimpleName());
    }

    public static <T extends ImageGray<T>, G extends GradientValue> SparseImageGradient<T, G> createTwo1(Class<T> imageType, ImageBorder<T> border) {
        if (imageType == GrayF32.class) {
            return new GradientSparseTwo1_F32((ImageBorder_F32)border);
        }
        if (imageType == GrayU8.class) {
            return new GradientSparseTwo1_U8((ImageBorder_S32)border);
        }
        throw new IllegalArgumentException("Unsupported image type " + imageType.getSimpleName());
    }
}

