/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.ii;

import boofcv.alg.transform.ii.impl.SparseIntegralGradient_NoBorder_F32;
import boofcv.alg.transform.ii.impl.SparseIntegralGradient_NoBorder_I32;
import boofcv.alg.transform.ii.impl.SparseIntegralHaar_NoBorder_F32;
import boofcv.alg.transform.ii.impl.SparseIntegralHaar_NoBorder_I32;
import boofcv.alg.transform.ii.impl.SparseIntegralSample_F32;
import boofcv.alg.transform.ii.impl.SparseIntegralSample_I32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.sparse.SparseScaleGradient;
import boofcv.struct.sparse.SparseScaleSample_F64;

public class FactorySparseIntegralFilters {
    public static <T extends ImageGray<T>> SparseScaleSample_F64<T> sample(Class<T> imageType) {
        if (imageType == GrayF32.class) {
            return new SparseIntegralSample_F32();
        }
        if (imageType == GrayS32.class) {
            return new SparseIntegralSample_I32();
        }
        throw new IllegalArgumentException("Unsupported image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageGray<T>> SparseScaleGradient<T, ?> gradient(Class<T> imageType) {
        if (imageType == GrayF32.class) {
            return new SparseIntegralGradient_NoBorder_F32();
        }
        if (imageType == GrayS32.class) {
            return new SparseIntegralGradient_NoBorder_I32();
        }
        throw new IllegalArgumentException("Unsupported image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageGray<T>> SparseScaleGradient<T, ?> haar(Class<T> imageType) {
        if (imageType == GrayF32.class) {
            return new SparseIntegralHaar_NoBorder_F32();
        }
        if (imageType == GrayS32.class) {
            return new SparseIntegralHaar_NoBorder_I32();
        }
        throw new IllegalArgumentException("Unsupported image type: " + imageType.getSimpleName());
    }
}

