/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public enum AutoTypeImage {
    I("GrayI", "int", true, 0),
    I8("GrayI8", "byte", true, 8),
    U8(GrayU8.class),
    S8(GrayS8.class),
    I16("GrayI16", "short", true, 16),
    U16(GrayU16.class),
    S16(GrayS16.class),
    S32(GrayS32.class),
    S64(GrayS64.class),
    F32(GrayF32.class),
    F64(GrayF64.class);

    private String imageSingleName;
    private String dataType;
    private String bitWise;
    private String sumType;
    private String largeSumType;
    private boolean isInteger;
    private boolean isSigned;
    private int numBits;
    private String abbreviatedType;
    private Class<?> primitiveType;

    private AutoTypeImage(Class<?> imageType) throws RuntimeException {
        this.imageSingleName = imageType.getSimpleName();
        this.bitWise = "";
        try {
            ImageGray img = (ImageGray)imageType.newInstance();
            this.setByDataType(img.getDataType());
            this.dataType = this.primitiveType.getSimpleName();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private AutoTypeImage(String imageSingleName, String dataType, boolean isInteger, int numBits) {
        this.imageSingleName = imageSingleName;
        this.dataType = dataType;
        this.isInteger = isInteger;
        this.numBits = numBits;
        if (isInteger) {
            this.abbreviatedType = "I";
            this.sumType = "int";
        } else {
            this.sumType = "double";
        }
        this.abbreviatedType = this.abbreviatedType + numBits;
    }

    private void setByDataType(ImageDataType type) {
        this.primitiveType = type.getDataType();
        this.numBits = type.getNumBits();
        this.abbreviatedType = type.toString();
        if (type.isInteger()) {
            this.isInteger = true;
            this.sumType = this.numBits <= 32 ? "int" : "long";
            this.largeSumType = this.numBits <= 16 ? "int" : "long";
            if (!type.isSigned()) {
                this.isSigned = false;
                if (Byte.TYPE == this.primitiveType) {
                    this.bitWise = "& 0xFF";
                } else if (Short.TYPE == this.primitiveType) {
                    this.bitWise = "& 0xFFFF";
                }
            } else {
                this.isSigned = true;
            }
        } else {
            this.isSigned = true;
            this.isInteger = false;
            this.sumType = type.getNumBits() == 32 ? "float" : "double";
            this.largeSumType = "double";
        }
    }

    public static AutoTypeImage[] getIntegerTypes() {
        return new AutoTypeImage[]{U8, S8, U16, S16, S32, S64};
    }

    public static AutoTypeImage[] getFloatingTypes() {
        return new AutoTypeImage[]{F32, F64};
    }

    public static AutoTypeImage[] getGenericTypes() {
        return new AutoTypeImage[]{I8, I16, S32, S64, F32, F64};
    }

    public static AutoTypeImage[] getReallyGenericTypes() {
        return new AutoTypeImage[]{I, S64, F32, F64};
    }

    public static AutoTypeImage[] getSpecificTypes() {
        return new AutoTypeImage[]{U8, S8, U16, S16, S32, S64, F32, F64};
    }

    public static AutoTypeImage[] getSigned() {
        return new AutoTypeImage[]{S8, S16, S32, S64, F32, F64};
    }

    public static AutoTypeImage[] getUnsigned() {
        return new AutoTypeImage[]{U8, U16};
    }

    public String getImageName(ImageType.Family family) {
        if (family == ImageType.Family.INTERLEAVED) {
            return this.getInterleavedName();
        }
        return this.getSingleBandName();
    }

    public String getKernelType() {
        return this.isInteger() ? "S32" : (this.getNumBits() == 64 ? "F64" : "F32");
    }

    public String getKernelDataType() {
        return this.isInteger() ? "int" : (this.getNumBits() == 64 ? "double" : "float");
    }

    public String getInterleavedName() {
        return "Interleaved" + this.toString();
    }

    public String getSingleBandName() {
        return this.imageSingleName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getBitWise() {
        return this.bitWise;
    }

    public String getSumType() {
        return this.sumType;
    }

    public String getLargeSumType() {
        return this.largeSumType;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public Class<?> getPrimitiveType() {
        return this.primitiveType;
    }

    public String getTypeCastFromSum() {
        if (this.sumType.compareTo(this.dataType) != 0) {
            return "(" + this.dataType + ")";
        }
        return "";
    }

    public String getAbbreviatedType() {
        return this.abbreviatedType;
    }

    public String getRandType() {
        return this.primitiveType == Float.TYPE ? "Float" : "Double";
    }

    public Number getMax() {
        if (this.isInteger) {
            if (Byte.TYPE == this.primitiveType) {
                if (this.isSigned) {
                    return (byte)127;
                }
                return 255;
            }
            if (Short.TYPE == this.primitiveType) {
                if (this.isSigned) {
                    return (short)Short.MAX_VALUE;
                }
                return 65535;
            }
            return Integer.MAX_VALUE;
        }
        if (Float.TYPE == this.primitiveType) {
            return Float.valueOf(Float.MAX_VALUE);
        }
        return Double.MAX_VALUE;
    }

    public Number getMin() {
        if (this.isInteger) {
            if (Byte.TYPE == this.primitiveType) {
                if (this.isSigned) {
                    return (byte)-128;
                }
                return 0;
            }
            if (Short.TYPE == this.primitiveType) {
                if (this.isSigned) {
                    return (short)Short.MIN_VALUE;
                }
                return 0;
            }
            return Integer.MIN_VALUE;
        }
        if (Float.TYPE == this.primitiveType) {
            return Float.valueOf(Float.MIN_VALUE);
        }
        return Double.MIN_VALUE;
    }
}

