/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import boofcv.struct.ImageRectangle;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.InterleavedF32;
import java.io.IOException;
import java.io.Reader;

public class BoofMiscOps {
    public static int numDigits(int number) {
        int digits = 1;
        if (number < 0) {
            ++digits;
            number *= -1;
        }
        number -= number % 10;
        while (number > 0) {
            number /= 10;
            number -= number % 10;
            ++digits;
        }
        return digits;
    }

    public static String toString(Reader r) {
        char[] buff = new char[1024];
        StringBuilder string = new StringBuilder();
        try {
            int size;
            while ((size = r.read(buff)) >= 0) {
                string.append(buff, 0, size);
            }
            return string.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int countNotZero(int[] a, int size) {
        int ret = 0;
        for (int i = 0; i < size; ++i) {
            if (a[i] == 0) continue;
            ++ret;
        }
        return ret;
    }

    public static double[] convertTo_F64(int[] a) {
        double[] ret = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    public static float[] convertTo_F32(double[] a, float[] ret) {
        if (ret == null) {
            ret = new float[a.length];
        }
        for (int i = 0; i < a.length; ++i) {
            ret[i] = (float)a[i];
        }
        return ret;
    }

    public static int[] convertTo_I32(double[] a, int[] ret) {
        if (ret == null) {
            ret = new int[a.length];
        }
        for (int i = 0; i < a.length; ++i) {
            ret[i] = (int)a[i];
        }
        return ret;
    }

    public static void boundRectangleInside(ImageBase b, ImageRectangle r) {
        if (r.x0 < 0) {
            r.x0 = 0;
        }
        if (r.x1 > b.width) {
            r.x1 = b.width;
        }
        if (r.y0 < 0) {
            r.y0 = 0;
        }
        if (r.y1 > b.height) {
            r.y1 = b.height;
        }
    }

    public static boolean checkInside(ImageBase b, ImageRectangle r) {
        if (r.x0 < 0) {
            return false;
        }
        if (r.x1 > b.width) {
            return false;
        }
        if (r.y0 < 0) {
            return false;
        }
        return r.y1 <= b.height;
    }

    public static boolean checkInside(ImageBase b, int x, int y, int radius) {
        if (x - radius < 0) {
            return false;
        }
        if (x + radius >= b.width) {
            return false;
        }
        if (y - radius < 0) {
            return false;
        }
        return y + radius < b.height;
    }

    public static boolean checkInside(ImageBase b, float x, float y, float radius) {
        if (x - radius < 0.0f) {
            return false;
        }
        if (x + radius > (float)(b.width - 1)) {
            return false;
        }
        if (y - radius < 0.0f) {
            return false;
        }
        return !(y + radius > (float)(b.height - 1));
    }

    public static boolean checkInside(ImageBase b, double x, double y, double radius) {
        if (x - radius < 0.0) {
            return false;
        }
        if (x + radius > (double)(b.width - 1)) {
            return false;
        }
        if (y - radius < 0.0) {
            return false;
        }
        return !(y + radius > (double)(b.height - 1));
    }

    public static boolean checkInside(ImageBase b, int x, int y, int radiusWidth, int radiusHeight) {
        if (x - radiusWidth < 0) {
            return false;
        }
        if (x + radiusWidth >= b.width) {
            return false;
        }
        if (y - radiusHeight < 0) {
            return false;
        }
        return y + radiusHeight < b.height;
    }

    public static boolean checkInside(ImageBase b, int c_x, int c_y, int radius, double theta) {
        float s;
        int r = radius;
        float c = (float)Math.cos(theta);
        if (!BoofMiscOps.checkInBounds(b, c_x, c_y, -r, -r, c, s = (float)Math.sin(theta))) {
            return false;
        }
        if (!BoofMiscOps.checkInBounds(b, c_x, c_y, -r, r, c, s)) {
            return false;
        }
        if (!BoofMiscOps.checkInBounds(b, c_x, c_y, r, r, c, s)) {
            return false;
        }
        return BoofMiscOps.checkInBounds(b, c_x, c_y, r, -r, c, s);
    }

    private static boolean checkInBounds(ImageBase b, int c_x, int c_y, int dx, int dy, float c, float s) {
        float x = (float)c_x + c * (float)dx - s * (float)dy;
        float y = (float)c_y + s * (float)dx + c * (float)dy;
        return b.isInBounds((int)x, (int)y);
    }

    public static boolean checkInside(ImageBase b, float x, float y) {
        return x >= 0.0f && x <= (float)(b.width - 1) && y >= 0.0f && y <= (float)(b.height - 1);
    }

    public static boolean checkInside(ImageBase b, double x, double y) {
        return x >= 0.0 && x <= (double)(b.width - 1) && y >= 0.0 && y <= (double)(b.height - 1);
    }

    public static boolean checkInside(int width, int height, float x, float y) {
        return x >= 0.0f && x <= (float)(width - 1) && y >= 0.0f && y <= (float)(height - 1);
    }

    public static boolean checkInside(int width, int height, double x, double y) {
        return x >= 0.0 && x <= (double)(width - 1) && y >= 0.0 && y <= (double)(height - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pause(long milli) {
        Thread t = Thread.currentThread();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < milli) {
            Thread thread = t;
            synchronized (thread) {
                try {
                    long target = milli - (System.currentTimeMillis() - start);
                    if (target > 0L) {
                        t.wait(target);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static void print(ImageGray a) {
        if (a.getDataType().isInteger()) {
            BoofMiscOps.print((GrayI)a);
        } else if (a instanceof GrayF32) {
            BoofMiscOps.print((GrayF32)a);
        } else {
            BoofMiscOps.print((GrayF64)a);
        }
    }

    public static void print(GrayF64 a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.printf("%6.2f ", a.get(x, y));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void print(GrayF32 a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.printf("%6.2f ", Float.valueOf(a.get(x, y)));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void print(InterleavedF32 a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.print("|");
                for (int band = 0; band < a.numBands; ++band) {
                    System.out.printf(" %6.2f", Float.valueOf(a.getBand(x, y, band)));
                }
                System.out.print(" |");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void print(GrayI a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.printf("%4d ", a.get(x, y));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static int[] convertArray(double[] input, int[] output) {
        if (output == null) {
            output = new int[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = (int)input[i];
        }
        return output;
    }

    public static long[] convertArray(double[] input, long[] output) {
        if (output == null) {
            output = new long[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = (long)input[i];
        }
        return output;
    }

    public static float[] convertArray(double[] input, float[] output) {
        if (output == null) {
            output = new float[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = (float)input[i];
        }
        return output;
    }

    public static double[] convertArray(float[] input, double[] output) {
        if (output == null) {
            output = new double[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public static int[] convertArray(float[] input, int[] output) {
        if (output == null) {
            output = new int[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = (int)input[i];
        }
        return output;
    }

    public static float[] convertArray(int[] input, float[] output) {
        if (output == null) {
            output = new float[input.length];
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public static void sleep(long milli) {
        try {
            Thread.sleep(milli);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

