/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import java.lang.reflect.Array;

public abstract class ImageInterleaved<T extends ImageInterleaved<T>>
extends ImageMultiBand<T> {
    public int numBands;

    protected ImageInterleaved(int width, int height, int numBands) {
        this.imageType = ImageType.il(0, this.getClass());
        this._setData(Array.newInstance(this.getPrimitiveDataType(), width * height * numBands));
        this.startIndex = 0;
        this.stride = width * numBands;
        this.numBands = numBands;
        this.width = width;
        this.height = height;
        this.imageType.numBands = numBands;
    }

    protected ImageInterleaved() {
        this.imageType = ImageType.il(0, this.getClass());
    }

    @Override
    public T subimage(int x0, int y0, int x1, int y1, T subimage) {
        ImageInterleaved ret = (ImageInterleaved)this.createNew(-1, -1);
        ret._setData(this._getData());
        ret.stride = Math.max(this.width * this.numBands, this.stride);
        ret.width = x1 - x0;
        ret.height = y1 - y0;
        ret.numBands = this.numBands;
        ret.startIndex = this.startIndex + y0 * this.stride + x0 * this.numBands;
        ret.subImage = true;
        ret.imageType = this.imageType;
        return (T)ret;
    }

    @Override
    public void reshape(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        if (this.isSubimage()) {
            throw new IllegalArgumentException("Can't reshape sub-images");
        }
        Object data = this._getData();
        if (Array.getLength(data) < width * height * this.numBands) {
            ImageInterleaved a = (ImageInterleaved)this.createNew(width, height);
            this._setData(a._getData());
        }
        this.width = width;
        this.height = height;
        this.stride = width * this.numBands;
    }

    @Override
    public int getIndex(int x, int y) {
        return this.startIndex + y * this.stride + x * this.numBands;
    }

    public int getIndex(int x, int y, int band) {
        return this.startIndex + y * this.stride + x * this.numBands + band;
    }

    @Override
    public void setTo(T orig) {
        if (((ImageInterleaved)orig).width != this.width || ((ImageInterleaved)orig).height != this.height) {
            this.reshape(((ImageInterleaved)orig).width, ((ImageInterleaved)orig).height);
        }
        if (((ImageInterleaved)orig).numBands != this.numBands) {
            throw new IllegalArgumentException("The two images have different number of bands");
        }
        if (!((ImageBase)orig).isSubimage() && !this.isSubimage()) {
            System.arraycopy(((ImageInterleaved)orig)._getData(), ((ImageInterleaved)orig).startIndex, this._getData(), this.startIndex, this.stride * this.height);
        } else {
            int indexSrc = ((ImageInterleaved)orig).startIndex;
            int indexDst = this.startIndex;
            for (int y = 0; y < this.height; ++y) {
                System.arraycopy(((ImageInterleaved)orig)._getData(), indexSrc, this._getData(), indexDst, this.width * this.numBands);
                indexSrc += ((ImageInterleaved)orig).stride;
                indexDst += this.stride;
            }
        }
    }

    @Override
    public int getNumBands() {
        return this.imageType.getNumBands();
    }

    @Override
    public final void setNumberOfBands(int numBands) {
        if (this.numBands == numBands) {
            return;
        }
        if (this.isSubimage()) {
            throw new IllegalArgumentException("Can't reshape sub-images");
        }
        this.imageType.numBands = numBands;
        this.numBands = numBands;
        this.stride = this.width * numBands;
        Object data = this._getData();
        if (data == null || Array.getLength(data) < this.width * this.height * numBands) {
            ImageInterleaved a = (ImageInterleaved)this.createNew(this.width, this.height);
            this._setData(a._getData());
        }
    }

    public abstract ImageDataType getDataType();

    protected abstract Object _getData();

    protected abstract Class getPrimitiveDataType();

    protected abstract void _setData(Object var1);

    public String toString() {
        String out = this.getClass().getSimpleName() + " : w=" + this.width + ", h=" + this.height + ", c=" + this.numBands + "\n";
        for (int y = 0; y < this.height; ++y) {
            int index = this.startIndex + y * this.stride;
            for (int x = 0; x < this.width; ++x) {
                for (int band = 0; band < this.numBands; ++band) {
                    out = out + this.toString_element(index++) + " ";
                }
                if (x >= this.width - 1) continue;
                out = out + ", ";
            }
            out = out + "\n";
        }
        return out;
    }

    public abstract String toString_element(int var1);
}

