/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageInterleaved;

public class InterleavedF32
extends ImageInterleaved<InterleavedF32> {
    public float[] data;

    public InterleavedF32(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public InterleavedF32() {
    }

    @Override
    public String toString_element(int index) {
        return String.format("%5f", Float.valueOf(this.data[index]));
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.F32;
    }

    public float[] get(int x, int y, float[] storage) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        if (storage == null) {
            storage = new float[this.numBands];
        }
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index];
            ++i;
            ++index;
        }
        return storage;
    }

    public void unsafe_get(int x, int y, float[] storage) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index];
            ++i;
            ++index;
        }
    }

    public void set(int x, int y, float ... value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = value[i];
            ++i;
            ++index;
        }
    }

    public void unsafe_set(int x, int y, float[] value) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = value[i];
            ++i;
            ++index;
        }
    }

    public float getBand(int x, int y, int band) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        return this.data[this.getIndex(x, y, band)];
    }

    public void setBand(int x, int y, int band, float value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = value;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected Class getPrimitiveDataType() {
        return Float.TYPE;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (float[])data;
    }

    @Override
    public InterleavedF32 createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new InterleavedF32();
        }
        return new InterleavedF32(imgWidth, imgHeight, this.numBands);
    }

    public void print(String format) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                System.out.printf(format + " " + format + "i ", Float.valueOf(this.getBand(x, y, 0)), Float.valueOf(this.getBand(x, y, 1)));
            }
            System.out.println();
        }
    }
}

