/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import java.lang.reflect.Array;

public class Planar<T extends ImageGray<T>>
extends ImageMultiBand<Planar<T>> {
    public Class<T> type;
    public T[] bands;

    public Planar(Class<T> type, int width, int height, int numBands) {
        this.type = type;
        this.stride = width;
        this.width = width;
        this.height = height;
        this.bands = (ImageGray[])Array.newInstance(type, numBands);
        for (int i = 0; i < numBands; ++i) {
            this.bands[i] = GeneralizedImageOps.createSingleBand(type, width, height);
        }
        this.imageType = ImageType.pl(numBands, type);
    }

    public Planar(Class<T> type, int numBands) {
        this.type = type;
        this.bands = (ImageGray[])Array.newInstance(type, numBands);
        this.imageType = ImageType.pl(numBands, type);
    }

    public Class<T> getBandType() {
        return this.type;
    }

    @Override
    public int getNumBands() {
        return this.bands.length;
    }

    public T getBand(int band) {
        if (band >= this.bands.length || band < 0) {
            throw new IllegalArgumentException("The specified band is out of bounds: " + band);
        }
        return this.bands[band];
    }

    @Override
    public Planar<T> subimage(int x0, int y0, int x1, int y1, Planar<T> subimage) {
        if (x0 < 0 || y0 < 0) {
            throw new IllegalArgumentException("x0 or y0 is less than zero");
        }
        if (x1 < x0 || y1 < y0) {
            throw new IllegalArgumentException("x1 or y1 is less than x0 or y0 respectively");
        }
        if (x1 > this.width || y1 > this.height) {
            throw new IllegalArgumentException("x1 or y1 is more than the width or height respectively");
        }
        Planar<T> ret = new Planar<T>(this.type, this.bands.length);
        ret.stride = Math.max(this.width, this.stride);
        ret.width = x1 - x0;
        ret.height = y1 - y0;
        ret.startIndex = this.startIndex + y0 * this.stride + x0;
        ret.subImage = true;
        for (int i = 0; i < this.bands.length; ++i) {
            ret.bands[i] = (ImageGray)((ImageBase)this.bands[i]).subimage(x0, y0, x1, y1);
        }
        return ret;
    }

    @Override
    public void setTo(Planar<T> orig) {
        if (orig.width != this.width || orig.height != this.height) {
            this.reshape(orig.width, orig.height);
        }
        if (orig.getBandType() != this.getBandType()) {
            throw new IllegalArgumentException("The band type must be the same");
        }
        int N = orig.getNumBands();
        if (N != this.getNumBands()) {
            this.setNumberOfBands(orig.getNumBands());
        }
        for (int i = 0; i < N; ++i) {
            ((ImageGray)this.bands[i]).setTo(orig.getBand(i));
        }
    }

    @Override
    public void reshape(int width, int height) {
        for (int i = 0; i < this.bands.length; ++i) {
            ((ImageGray)this.bands[i]).reshape(width, height);
        }
        this.startIndex = 0;
        this.stride = width;
        this.width = width;
        this.height = height;
    }

    @Override
    public Planar<T> createNew(int imgWidth, int imgHeight) {
        return new Planar<T>(this.type, imgWidth, imgHeight, this.bands.length);
    }

    public Planar<T> partialSpectrum(int ... which) {
        Planar<T> out = new Planar<T>(this.getBandType(), which.length);
        out.setWidth(this.width);
        out.setHeight(this.height);
        out.setStride(this.stride);
        for (int i = 0; i < which.length; ++i) {
            out.setBand(i, this.getBand(which[i]));
        }
        return out;
    }

    public void reorderBands(int ... order) {
        ImageGray[] bands = (ImageGray[])Array.newInstance(this.type, order.length);
        for (int i = 0; i < order.length; ++i) {
            bands[i] = this.bands[order[i]];
        }
        this.bands = bands;
    }

    @Override
    public void setNumberOfBands(int numberOfBands) {
        int i;
        if (numberOfBands == this.bands.length) {
            return;
        }
        ImageGray[] bands = (ImageGray[])Array.newInstance(this.type, numberOfBands);
        int N = Math.min(numberOfBands, this.bands.length);
        for (i = 0; i < N; ++i) {
            bands[i] = this.bands[i];
        }
        for (i = N; i < bands.length; ++i) {
            bands[i] = GeneralizedImageOps.createSingleBand(this.type, this.width, this.height);
        }
        this.bands = bands;
    }

    public void setBandType(Class<T> type) {
        this.type = type;
    }

    public T[] getBands() {
        return this.bands;
    }

    public void setBands(T[] bands) {
        this.bands = bands;
    }

    public void setBand(int which, T image) {
        this.bands[which] = image;
    }
}

