/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.pyramid;

import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ImagePyramidBase;

public abstract class PyramidFloat<T extends ImageBase<T>>
extends ImagePyramidBase<T> {
    public double[] scale;

    public PyramidFloat(ImageType<T> imageType, double ... scaleFactors) {
        super(imageType, false);
        if (scaleFactors.length > 0) {
            this.setScaleFactors(scaleFactors);
        }
    }

    public void setScaleFactors(double ... scaleFactors) {
        if (this.scale != null && this.scale.length == scaleFactors.length) {
            boolean theSame = true;
            for (int i = 0; i < this.scale.length; ++i) {
                if (this.scale[i] == scaleFactors[i]) continue;
                theSame = false;
                break;
            }
            if (theSame) {
                return;
            }
        }
        this.bottomHeight = 0;
        this.bottomWidth = 0;
        this.scale = (double[])scaleFactors.clone();
        this.checkScales();
    }

    @Override
    public double getScale(int layer) {
        return this.scale[layer];
    }

    @Override
    public int getNumLayers() {
        return this.scale.length;
    }
}

